/*
 * Decompiled with CFR 0.152.
 */
package utilt;

import java.util.Comparator;
import mlib.MLogger;
import mlib.MLogging;
import mlib.MString;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlNodeUtil {
    public static final short ANYNODETYPE = -1;
    private static final char NODEDELIM = '|';
    private static final char ATTRIBSTART = '(';
    private static final char ATTRIBEND = ')';

    public static void listXml(Node node, MLogging logger, boolean recurse, String indent) throws Exception {
        String prefix = logger.prefix();
        logger.setPrefix(String.valueOf(prefix) + indent);
        String nodeStr = String.valueOf(node.getNodeName()) + "," + XmlNodeUtil.nodeType(node);
        logger.writeln(nodeStr, false);
        NamedNodeMap map = node.getAttributes();
        if (map != null && map.getLength() > 0) {
            int i = 0;
            while (i < map.getLength()) {
                Node attrib = map.item(i);
                if (recurse) {
                    XmlNodeUtil.listXml(attrib, logger, true, indent);
                }
                logger.setPrefix(prefix);
                ++i;
            }
        }
        if (recurse) {
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 3) {
                    String prefix1 = logger.prefix();
                    logger.setPrefix(String.valueOf(prefix1) + indent);
                    nodeStr = "\"" + child.getNodeValue() + "\"," + XmlNodeUtil.nodeType(child);
                    logger.writeln(nodeStr, false);
                    logger.setPrefix(prefix1);
                } else {
                    XmlNodeUtil.listXml(child, logger, recurse, indent);
                    logger.setPrefix(prefix);
                }
                ++i;
            }
        }
        logger.setPrefix(prefix);
    }

    public static String nodeType(short type) {
        String str = "other";
        if (type == 2) {
            str = "attribute";
        } else if (type == 9) {
            str = "document";
        } else if (type == 1) {
            str = "element";
        } else if (type == 6) {
            str = "entity";
        } else if (type == 3) {
            str = "text";
        } else if (type == -1) {
            str = "all";
        }
        return str;
    }

    public static String nodeType(Node node) {
        short type = node.getNodeType();
        return XmlNodeUtil.nodeType(type);
    }

    public static short nodeType(String strType) {
        int type = -1;
        if (strType.equals("attribute")) {
            type = 2;
        } else if (strType.equals("document")) {
            type = 9;
        } else if (strType.equals("element")) {
            type = 1;
        } else if (strType.equals("entity")) {
            type = 6;
        } else if (strType.equals("text")) {
            type = 3;
        }
        return (short)type;
    }

    public static MString nodeToString(Node node) {
        MString str = new MString();
        str.concat(String.valueOf('|') + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null && map.getLength() > 0) {
            str.concat('(');
            int i = 0;
            while (i < map.getLength()) {
                Node attrib = map.item(i);
                if (i == 0) {
                    str.concat(attrib.getNodeName());
                } else {
                    str.concat(String.valueOf('|') + attrib.getNodeName());
                }
                str.concat(XmlNodeUtil.nodeToString(attrib));
                ++i;
            }
            str.concat(')');
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                str.concat(String.valueOf('|') + child.getNodeValue());
            } else {
                str.concat(XmlNodeUtil.nodeToString(child));
            }
            ++i;
        }
        return str;
    }

    public static class NodeStrComparator
    implements Comparator<Node> {
        @Override
        public int compare(Node node1, Node node2) {
            MLogger.MString logger = new MLogger.MString();
            int result = -1;
            try {
                XmlNodeUtil.listXml(node1, logger, false, "");
                String str1 = logger.string().toString();
                logger.clear();
                XmlNodeUtil.listXml(node2, logger, false, "");
                String str2 = logger.string().toString();
                result = str1.compareTo(str2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }
    }
}

