/*
 * Decompiled with CFR 0.152.
 */
package utilt;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.zip.GZIPInputStream;
import mlib.MConsoleApp;
import utilt.Showable;

public class Show
extends MConsoleApp {
    public static final String UNKNOWNOPTION = "Unknown option: ";
    private static final String FILEARG = "f";
    private static final String SUMMARYARG = "s";
    private static final String DETAILSARG = "d";
    private static final String IDARG = "i";
    private static final String OTHERARG = "o";
    private static final String HELPARG = "h";
    private static final String PROGNAME = "Show File";
    private static final String VERSION = "19-Mar-2023";
    private static final String PROGTITLE = "Show File version 19-Mar-2023";

    public static void main(String[] args) {
        try {
            Show program = new Show();
            if (program.parseArgs(args)) {
                program.process();
            }
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    private static Showable readObj(String path) throws Exception {
        Showable obj = null;
        try (ObjectInputStream in = null;){
            try {
                in = new ObjectInputStream(new FileInputStream(path));
                obj = (Showable)in.readObject();
            }
            catch (Exception xcp) {
                GZIPInputStream zipin = new GZIPInputStream(new FileInputStream(path));
                in = new ObjectInputStream(zipin);
                obj = (Showable)in.readObject();
                if (in != null) {
                    in.close();
                }
            }
        }
        return obj;
    }

    public Show() throws Exception {
        super(PROGTITLE);
        this.progArgs().addArg(FILEARG, "File path (no default)", null, true, 1, 1);
        this.progArgs().addArg(IDARG, "Show id", null, false, 0, 0);
        this.progArgs().addArg(SUMMARYARG, "Show summary", null, false, 0, 0);
        this.progArgs().addArg(DETAILSARG, "Show details", null, false, 0, 0);
        this.progArgs().addArg(OTHERARG, "Show other", null, false, 1, 1);
        this.progArgs().addArg(HELPARG, "Help", null, false, 0, 0);
    }

    @Override
    public void process() throws Exception {
        this.logger().writeln(this.progTitle(), false);
        String path = this.progArgs().argValue(FILEARG, 0);
        File file = new File(path);
        if (!file.exists()) {
            this.logger().writeln("file not found", true);
        } else {
            Showable obj = Show.readObj(path);
            if (this.progArgs().argSupplied(HELPARG)) {
                this.logger().write("Parameters: ", false);
                obj.showHelp(this.logger());
            } else if (this.progArgs().argSupplied(IDARG)) {
                obj.showId(this.logger());
            } else if (this.progArgs().argSupplied(SUMMARYARG)) {
                obj.showSummary(this.logger());
            } else if (this.progArgs().argSupplied(DETAILSARG)) {
                obj.showDetails(this.logger());
            } else if (this.progArgs().argSupplied(OTHERARG)) {
                String parm = this.progArgs().argValue(OTHERARG, 0);
                obj.showOther(parm, this.logger());
            } else {
                obj.showId(this.logger());
            }
        }
    }
}

