/*
 * Decompiled with CFR 0.152.
 */
package utilt;

import java.io.File;
import java.util.LinkedList;
import mlib.MReport;
import mlib.MString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class PdfReport {
    public static final int MAXLINELEN = 95;

    public static void main(String[] args) {
        try {
            MReport report = new MReport("Test Report");
            int i = 0;
            while (i < 100) {
                report.addLine("01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234");
                ++i;
            }
            String path = String.valueOf(System.getProperty("user.dir")) + File.separator + "test.pdf";
            PdfReport.make(report, path, null);
            System.out.println("Wrote " + path);
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public static void make(MReport report, String path, String password) throws Exception {
        LinkedList<String> lines = report.lines();
        PDDocument doc = new PDDocument();
        int numLines = Integer.MAX_VALUE;
        int pageNum = 1;
        PDPageContentStream contents = null;
        try {
            for (String line : lines) {
                if (numLines > 55) {
                    numLines = 0;
                    if (contents != null) {
                        PdfReport.endPage(contents, pageNum);
                        ++pageNum;
                    }
                    PDPage page = new PDPage();
                    doc.addPage(page);
                    if (contents != null) {
                        contents.close();
                    }
                    contents = new PDPageContentStream(doc, page);
                    contents.beginText();
                    contents.setFont((PDFont)PDType1Font.COURIER, 9.0f);
                    contents.setLeading(12.0f);
                    contents.newLineAtOffset(50.0f, 750.0f);
                }
                if (contents == null) continue;
                contents.showText(line);
                contents.newLine();
                ++numLines;
            }
            PdfReport.endPage(contents, pageNum);
            if (password != null) {
                PdfReport.protectPdf(doc, password);
            }
            doc.save(path);
        }
        finally {
            if (contents != null) {
                contents.close();
            }
            doc.close();
        }
    }

    private static void protectPdf(PDDocument doc, String password) throws Exception {
        AccessPermission perm = new AccessPermission();
        perm.setCanPrint(false);
        StandardProtectionPolicy spp = new StandardProtectionPolicy("alfa8c2900", password, perm);
        spp.setEncryptionKeyLength(128);
        spp.setPermissions(perm);
        doc.protect((ProtectionPolicy)spp);
    }

    private static void endPage(PDPageContentStream contents, int pageNum) throws Exception {
        String page = "Page " + pageNum;
        MString align = new MString();
        int i = 0;
        while (i < 95 - page.length()) {
            align.concat(" ");
            ++i;
        }
        align.concat(page);
        contents.showText(align.toString());
        contents.endText();
        contents.close();
    }

    private PdfReport() {
    }
}

