/*
 * Decompiled with CFR 0.152.
 */
package utilt;

import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import files.FileInfo;
import files.Filesystem;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import mlib.MLogger;
import utilt.Utility;

public class JpegTifFileInfo
extends FileInfo.Local
implements Serializable {
    private TreeMap<String, ExifTag> iTags = new TreeMap();
    private static final String TIF = ".tif";
    private static final int MAXEXIFLEN = 50;
    static final long serialVersionUID = -4436676006557624870L;

    public JpegTifFileInfo(Filesystem fs, File file) throws Exception {
        super(fs, file);
        boolean isImage;
        String path = file.getAbsolutePath().toLowerCase();
        boolean bl = isImage = path.endsWith(".jpg") || path.endsWith(TIF);
        if (!isImage) {
            Utility.throwError("Not an image: " + path);
        }
    }

    public boolean isJpg() {
        return this.name().toLowerCase().endsWith(".jpg");
    }

    public boolean isTif() {
        return this.name().toLowerCase().endsWith(TIF);
    }

    public void doExif(File file) throws Exception {
        Metadata metadata = ImageMetadataReader.readMetadata((File)file);
        Iterable dirs = metadata.getDirectories();
        for (Directory dir : dirs) {
            Collection tags = dir.getTags();
            for (Tag tag : tags) {
                ExifTag exifTag = new ExifTag(tag.getTagName(), tag.getDescription());
                this.add(exifTag);
            }
        }
    }

    public boolean sameTags(JpegTifFileInfo info) {
        boolean same;
        boolean bl = same = this.iTags.size() == info.iTags.size();
        if (same) {
            Iterator<String> iter = this.iTags.keySet().iterator();
            while (same && iter.hasNext()) {
                String name = iter.next();
                ExifTag infoNext = info.iTags.get(name);
                boolean bl2 = same = infoNext != null;
                if (!same) continue;
                ExifTag next = this.iTags.get(name);
                same = next.equals(infoNext);
            }
        }
        return same;
    }

    public ExifTag tag(String name) {
        return this.iTags.get(name);
    }

    public boolean isPIE() {
        boolean is = false;
        ExifTag tag = this.iTags.get("Make");
        if (tag != null) {
            is = tag.getValue().equals("PIE");
        }
        return is;
    }

    public boolean isCyberViewX() {
        boolean is = false;
        Iterator<ExifTag> iter = this.iTags.values().iterator();
        while (!is && iter.hasNext()) {
            String value = iter.next().getValue();
            boolean bl = is = value.indexOf("CyberViewX") >= 0;
        }
        return is;
    }

    public String matchesExif(JpegTifFileInfo info, String makeName, String timeName) {
        String result = null;
        ExifTag tag = this.iTags.get("Make");
        ExifTag tag1 = info.iTags.get("Make");
        if (tag == null || tag1 == null) {
            result = "no Make tags";
        } else {
            boolean matches;
            boolean bl = matches = tag.getValue().equals(makeName) && tag1.getValue().equals(makeName);
            if (!matches) {
                result = "no " + makeName + " values";
            } else {
                tag = this.iTags.get(timeName);
                tag1 = info.iTags.get(timeName);
                if (tag == null || tag1 == null) {
                    result = "no " + timeName + " tags";
                } else {
                    matches = tag.getValue().equals(tag1.getValue());
                    if (!matches) {
                        result = "no time match";
                    }
                }
            }
        }
        return result;
    }

    public void list(MLogger logger) {
        logger.writeln(this.toString(), false);
        for (ExifTag tag : this.iTags.values()) {
            logger.writeln("   " + tag, false);
        }
    }

    @Override
    public String toString() {
        String str = String.valueOf(super.toString()) + ", " + this.iTags.size() + " tags";
        return str;
    }

    private void add(ExifTag tag) {
        boolean skip;
        boolean bl = skip = tag.getValue().endsWith("values]") || tag.getValue().length() > 50;
        if (!skip) {
            this.iTags.put(tag.getName(), tag);
        }
    }

    public static class ExifTag
    implements Comparable<ExifTag>,
    Serializable {
        private String iName = null;
        private String iValue = null;

        public ExifTag(String name, String value) {
            this.iName = name;
            this.iValue = value;
        }

        public String getName() {
            return this.iName;
        }

        public String getValue() {
            return this.iValue;
        }

        @Override
        public int compareTo(ExifTag tag) {
            int result = 0;
            if (tag != this) {
                result = -1;
                if (tag != null && (result = this.iName.compareToIgnoreCase(tag.iName)) == 0) {
                    result = this.iValue.compareToIgnoreCase(tag.iValue);
                }
            }
            return result;
        }

        public boolean equals(Object obj) {
            return this.compareTo((ExifTag)obj) == 0;
        }

        public int hashCode() {
            return (String.valueOf(this.iName) + this.iValue).hashCode();
        }

        public String toString() {
            return String.valueOf(this.iName) + "=" + this.iValue;
        }
    }
}

