/*
 * Decompiled with CFR 0.152.
 */
package userkey;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;

public class UserKey {
    private String iValue = null;
    public static final String SUCCESSMSG = "License key entered successfully";
    private static final String KEYTEMPLATE = "???-???-???-???-???-???";
    private static final int NUMSQRTDIGITS = 9;
    private static final int NUMKEYNUMDIGITS = 9;
    private static final long MINKEY = 100000000L;
    private static final long MAXKEY = 999999999L;
    private static final int MAXSAMEDIGITS = 2;

    public static void main(String[] args) {
        int numKeys = Integer.parseInt(args[0]);
        int[] nArray = new int[9];
        nArray[1] = 4;
        nArray[2] = 5;
        nArray[3] = 8;
        nArray[4] = 10;
        nArray[5] = 12;
        nArray[6] = 13;
        nArray[7] = 17;
        nArray[8] = 20;
        int[] numPos = nArray;
        int[] sqrtPos = new int[]{1, 2, 6, 9, 14, 16, 18, 21, 22};
        try {
            PrintWriter out = new PrintWriter(new FileWriter(args[1]));
            UserKey.printKeyPos(out, numPos, sqrtPos);
            LinkedList<UserKey> keys = UserKey.generateKeys(numKeys, numPos, sqrtPos);
            for (UserKey key : keys) {
                out.println(key.getValue());
                if (UserKey.isKey(key.getValue(), numPos, sqrtPos)) continue;
                System.out.println("Error: : " + key.getValue());
            }
            out.close();
        }
        catch (IOException xcp) {
            System.out.println(xcp);
        }
    }

    private static boolean isValidNum(char[] digits) {
        int[] charCounts = new int[10];
        int i = 0;
        while (i < digits.length) {
            int index;
            int n = index = digits[i] - 48;
            charCounts[n] = charCounts[n] + 1;
            ++i;
        }
        boolean valid = true;
        int i2 = 0;
        while (i2 < charCounts.length) {
            if (charCounts[i2] > 2) {
                valid = false;
                break;
            }
            ++i2;
        }
        return valid;
    }

    private static long obtainKeyNum(char[] value, int[] numPos) {
        long result = -1L;
        char[] keyNum = new char[9];
        int i = 0;
        while (i < numPos.length) {
            keyNum[i] = value[numPos[i]];
            ++i;
        }
        String num = new String(keyNum);
        try {
            result = Long.parseLong(num);
        }
        catch (NumberFormatException xcp) {
            result = -1L;
        }
        return result;
    }

    private static char[] retrieveSqrtDigits(char[] value, int[] sqrtPos) {
        char[] sqrtDigits = new char[9];
        int i = 0;
        while (i < sqrtPos.length) {
            sqrtDigits[i] = value[sqrtPos[i]];
            ++i;
        }
        return sqrtDigits;
    }

    private static void printKeyPos(PrintWriter out, int[] numPos, int[] sqrtPos) {
        String pos = "";
        int i = 0;
        while (i < 9) {
            pos = String.valueOf(pos) + Integer.toString(numPos[i]) + "-";
            ++i;
        }
        pos = pos.substring(0, pos.length() - 1);
        out.println("Number positions: " + pos);
        pos = "";
        i = 0;
        while (i < 9) {
            pos = String.valueOf(pos) + Integer.toString(sqrtPos[i]) + "-";
            ++i;
        }
        pos = pos.substring(0, pos.length() - 1);
        out.println("Sqrt positions: " + pos);
    }

    private static char[] obtainKeyDigits(long keyNum) {
        String numStr = Long.toString(keyNum);
        char[] digits = new char[9];
        int j = 0;
        int i = 0;
        while (i < 9) {
            if (numStr.charAt(j) != '.') {
                digits[i] = numStr.charAt(j);
                ++i;
            }
            ++j;
        }
        return digits;
    }

    private static char[] obtainSqrtDigits(long keyNum) {
        double sqrt = Math.sqrt(keyNum);
        String sqrtStr = Double.toString(sqrt);
        char[] digits = new char[9];
        int j = 0;
        int i = 0;
        while (i < 9) {
            if (sqrtStr.charAt(j) != '.') {
                digits[i] = sqrtStr.charAt(j);
                ++i;
            }
            ++j;
        }
        return digits;
    }

    private static void fillKeyNumDigits(char[] key, char[] digits, int[] numPos) {
        int i = 0;
        while (i < numPos.length) {
            key[numPos[i]] = digits[i];
            ++i;
        }
    }

    private static void fillSqrtDigits(char[] key, char[] digits, int[] sqrtPos) {
        int i = 0;
        while (i < sqrtPos.length) {
            key[sqrtPos[i]] = digits[i];
            ++i;
        }
    }

    public static LinkedList<UserKey> generateKeys(int numKeys, int[] numPos, int[] sqrtPos) {
        LinkedList<UserKey> keys = new LinkedList<UserKey>();
        int numGen = 0;
        while (numGen < numKeys) {
            long keyNum = (long)(8.99999999E8 * Math.random() + 1.0E8);
            char[] numDigits = UserKey.obtainKeyDigits(keyNum);
            if (!UserKey.isValidNum(numDigits)) continue;
            char[] keyChars = KEYTEMPLATE.toCharArray();
            UserKey.fillKeyNumDigits(keyChars, numDigits, numPos);
            char[] sqrtDigits = UserKey.obtainSqrtDigits(keyNum);
            UserKey.fillSqrtDigits(keyChars, sqrtDigits, sqrtPos);
            UserKey key = new UserKey();
            key.setValue(new String(keyChars));
            keys.add(key);
            ++numGen;
        }
        return keys;
    }

    public static boolean isKey(String value, int[] numPos, int[] sqrtPos) {
        boolean result;
        boolean bl = result = value.length() == KEYTEMPLATE.length();
        if (result) {
            char[] chars = value.toCharArray();
            long num = UserKey.obtainKeyNum(chars, numPos);
            boolean bl2 = result = num > 0L;
            if (result) {
                char[] valueSqrtDigits = UserKey.retrieveSqrtDigits(chars, sqrtPos);
                char[] sqrtDigits = UserKey.obtainSqrtDigits(num);
                int i = 0;
                while (i < sqrtDigits.length) {
                    if (sqrtDigits[i] != valueSqrtDigits[i]) {
                        result = false;
                        break;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public String getValue() {
        return this.iValue;
    }

    public void setValue(String newValue) {
        this.iValue = newValue;
    }
}

