/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.Dimension;
import java.awt.Font;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import swing.EntryField;

public class UpperCaseEntryField
extends EntryField {
    private static final int FONTMARGIN = 6;

    public UpperCaseEntryField() {
    }

    public UpperCaseEntryField(String text) {
        super(text);
    }

    @Override
    protected Document createDefaultModel() {
        return new UpperCaseDocument();
    }

    public void setEnabled(boolean enabled, String text) {
        super.setEnabled(enabled);
        this.setText(text);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(null);
        super.setFont(font);
        Dimension size = this.getSize();
        this.setMinimumSize(new Dimension(size.width, font.getSize() + 6));
    }

    private static class UpperCaseDocument
    extends PlainDocument {
        private UpperCaseDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet attr) throws BadLocationException {
            if (str != null) {
                char[] upper = str.toCharArray();
                int i = 0;
                while (i < upper.length) {
                    upper[i] = Character.toUpperCase(upper[i]);
                    ++i;
                }
                super.insertString(offs, new String(upper), attr);
            }
        }
    }
}

