/*
 * Decompiled with CFR 0.152.
 */
package swing;

import combo.FifoComboBox;
import dialog.CenteredDialog;
import dialog.MsgDialog;
import help.HelpPrefs;
import help.TaggedText;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import mlib.MLogger;
import mlib.MLogging;
import mlib.MProgArgs;
import mswing.Preferences;
import popup.PopupPanel;
import swing.AdjustableDigit;
import swing.CheckboxPanel;
import swing.ColorButton;
import swing.ColorPanel;
import swing.DatePanel;
import swing.EntryField;
import swing.MainFrame;
import swing.MenuItem;
import swing.NumberSpinner;
import swing.PanelLabel;
import swing.Selector;
import swing.StatusBox;
import swing.WheelComboBox;
import utilt.GifIconMgr;

public class SwingProgram
extends MainFrame {
    private String iProgTitle = null;
    private MLogging iLogger = new MLogger.System();
    private MProgArgs iProgArgs = new MProgArgs();
    private GifIconMgr iIconMgr = new GifIconMgr(SwingProgram.class, "/icons");
    private Preferences iPref = null;
    public static final Color DIALOGBACKCOLOR = SystemColor.window;
    public static final Color MSGFORECOLOR = Color.blue;
    public static final Color TAB0COLOR = Color.cyan;
    public static final Color TAB1COLOR = Color.yellow;
    public static final Color TAB2COLOR = Color.pink;
    public static final Color TAB3COLOR = Color.orange;
    public static final Color TABFORECOLOR = Color.blue;
    public static final Color TABFADECOLOR = Color.black;
    public static final String EDITCANCELLED = "Edit cancelled";
    public static final String METALLF = "Metal";
    public static final String SYSTEMLF = "System";
    public static final String MOTIFLF = "Motif";
    public static final String[] LFOPTIONS = new String[]{"Metal", "System", "Motif"};
    public static final Border STDBORDER = BorderFactory.createEtchedBorder();
    public static final Border EMPTYBORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    public static final Border STDGAP = BorderFactory.createEmptyBorder(1, 2, 1, 2);

    public static void putFontAll(Font font) {
        FifoComboBox.putFontAll(font);
        WheelComboBox.putFontAll(font);
        PanelLabel.putFontAll(font);
        EntryField.putFontAll(font);
        ColorPanel.putFontAll(font);
        CenteredDialog.putFontAll(font);
        ColorButton.putFontAll(font);
        DatePanel.putFontAll(font);
        CheckboxPanel.putFontAll(font);
        MenuItem.putFontAll(font);
        NumberSpinner.putFontAll(font);
    }

    public static void setupLF(Preferences pref) {
        try {
            if (pref.lookAndFeel().equals(METALLF)) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            } else if (pref.lookAndFeel().equals(MOTIFLF)) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            } else if (pref.lookAndFeel().equals(SYSTEMLF)) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SwingProgram(String progTitle) {
        this(1.0, 1.0);
        this.iProgTitle = progTitle;
        this.setupGui(new Preferences());
    }

    public SwingProgram(double vertFrac, double horzFrac) {
        super(vertFrac, horzFrac);
        this.setupGui(new Preferences());
    }

    public SwingProgram() {
        this("");
    }

    public void setProgTitle(String title) {
        this.iProgTitle = title;
    }

    public int center(double horzFrac, double vertFrac) {
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        int width = (int)(horzFrac * screen.getWidth() + 0.5);
        int height = (int)(vertFrac * screen.getHeight() + 0.5);
        this.setSize(width, height);
        int x = (int)(screen.getWidth() - (double)width) / 2;
        int y = (int)(screen.getHeight() - (double)height) / 2;
        this.setLocation(x, y);
        return Math.max(width, height);
    }

    public String progTitleStr() {
        return "|" + this.iProgTitle + "|";
    }

    public MProgArgs progArgs() {
        return this.iProgArgs;
    }

    public MLogging logger() {
        return this.iLogger;
    }

    public Preferences pref() {
        return this.iPref;
    }

    public void setLogger(MLogging logger) {
        this.iLogger = logger;
    }

    public String progTitle() {
        return this.iProgTitle;
    }

    public GifIconMgr iconMgr() {
        return this.iIconMgr;
    }

    public void setupGui(Preferences pref) {
        this.iPref = pref;
        SwingProgram.setupLF(pref);
        SwingProgram.putFontAll(pref.menuFont());
        WheelComboBox.putForeColorAll(pref.entryForeColor());
        WheelComboBox.putBackColorAll(pref.entryBackColor());
        PanelLabel.putBackColorAll(pref.dialogColor());
        EntryField.putForeColorAll(pref.entryForeColor());
        EntryField.putBackColorAll(pref.entryBackColor());
        EntryField.putHilightColorAll(pref.entryHilightColor());
        ColorPanel.putBackColorAll(pref.panelBackColor());
        ColorPanel.putForeColorAll(pref.panelForeColor());
        PopupPanel.putBackColorAll(pref.panelBackColor());
        PopupPanel.putForeColorAll(pref.panelForeColor());
        PopupPanel.putSelectColorAll(pref.selectionColor());
        StatusBox.singleton().setErrorColor(pref.errorMsgColor());
        CenteredDialog.putBackColorAll(pref.dialogColor());
        DatePanel.putBackColorAll(pref.entryBackColor());
        DatePanel.putForeColorAll(pref.entryForeColor());
        AdjustableDigit.putBackColorAll(pref.panelBackColor());
        AdjustableDigit.putSelectionColorAll(pref.panelBackColor());
        AdjustableDigit.putForeColorAll(pref.panelForeColor());
        Selector.putBackColorAll(pref.entryBackColor());
        Selector.putHilightColorAll(pref.entryHilightColor());
        Selector.putForeColorAll(pref.entryForeColor());
        NumberSpinner.putForeColorAll(pref.entryForeColor());
        NumberSpinner.putBackColorAll(pref.entryBackColor());
        NumberSpinner.putHilightColorAll(pref.entryHilightColor());
        UIManager.put("ToolTip.font", new FontUIResource("SansSerif", 0, 14));
        ToolTipManager.sharedInstance().setInitialDelay(250);
        ToolTipManager.sharedInstance().setDismissDelay(2000);
        ToolTipManager.sharedInstance().setEnabled(true);
    }

    public void showInstructions(String instr, float widthFrac, float heightFrac, boolean undecorated, WindowListener listener, HelpPrefs prefs) {
        TaggedText tagged = TaggedText.parseText(instr);
        MsgDialog dialog = new MsgDialog(this, "Instructions", tagged, prefs);
        if (undecorated) {
            dialog.setUndecorated(true);
        }
        dialog.setModal(true);
        dialog.removeCancelButton();
        dialog.putAcceptLabel("Ok", 'O');
        dialog.center(widthFrac, heightFrac);
        dialog.setVisible(true);
        dialog.requestFocus();
        if (listener != null) {
            listener.windowClosing(new WindowEvent(this, 0));
        }
    }

    protected boolean parseArgs(String[] args) {
        boolean status = this.iProgArgs.parse(args);
        if (this.iProgArgs.numFound() >= this.iProgArgs.numRequired()) {
            this.iLogger.writeln(this.progTitleStr(), false);
            this.iProgArgs.showDesc(this.iLogger);
            status = true;
        } else if (!status) {
            this.iLogger.writeln(this.progTitleStr(), false);
            this.iProgArgs.showFirstError(this.iLogger);
            this.iProgArgs.showDesc(this.iLogger);
        }
        return status;
    }
}

