/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class NestedSplitPanel
extends JPanel {
    private JComponent iLeftComp = null;
    private JComponent iCenterComp = null;
    private JComponent iRightComp = null;
    private double iOuterAllPos = 0.0;
    private double iOuterLOnlyPos = 0.0;
    private double iOuterCOnlyPos = 0.0;
    private double iInnerPos = 0.0;
    private boolean iShowedLeft = false;
    private boolean iShowedCenter = false;
    private boolean iSettingPos = false;
    private JSplitPane jOuterSplitPane = null;
    private JSplitPane iInnerSplitPane = null;
    private JPanel iInnerPanel = null;
    private static NestedSplitPanel Singleton = null;

    public static NestedSplitPanel singleton() {
        return Singleton;
    }

    public static int dividerSize() {
        if (Singleton == null) {
            Singleton = new NestedSplitPanel();
        }
        return NestedSplitPanel.Singleton.jOuterSplitPane.getDividerSize();
    }

    public NestedSplitPanel() {
        this.setLayout(new BorderLayout());
        this.setComponentOrientation(ComponentOrientation.UNKNOWN);
        this.add((Component)this.getOuterSplitPane(), "Center");
        Singleton = this;
    }

    public JComponent getCenterComp() {
        return this.iCenterComp;
    }

    public boolean getShowedLeft() {
        return this.iShowedLeft;
    }

    private JPanel getInnerPanel() {
        if (this.iInnerPanel == null) {
            this.iInnerPanel = new JPanel();
            this.iInnerPanel.setLayout(new BorderLayout());
        }
        return this.iInnerPanel;
    }

    private JSplitPane getInnerSplitPane() {
        if (this.iInnerSplitPane == null) {
            this.iInnerSplitPane = new JSplitPane(1);
            this.iInnerSplitPane.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.iInnerSplitPane.addPropertyChangeListener(new InnerHandler());
        }
        return this.iInnerSplitPane;
    }

    public JComponent getLeftComp() {
        return this.iLeftComp;
    }

    private JSplitPane getOuterSplitPane() {
        if (this.jOuterSplitPane == null) {
            this.jOuterSplitPane = new JSplitPane(1);
            this.jOuterSplitPane.setName("OuterSplitPane");
            this.jOuterSplitPane.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.jOuterSplitPane.addPropertyChangeListener(new OuterHandler());
        }
        return this.jOuterSplitPane;
    }

    public JComponent getRightComp() {
        return this.iRightComp;
    }

    public void setCenterComp(JComponent comp) {
        this.iCenterComp = comp;
    }

    public void setLeftComp(JComponent comp) {
        this.iLeftComp = comp;
    }

    public void setRightComp(JComponent comp) {
        this.iRightComp = comp;
    }

    private void showAll() {
        if (this.iLeftComp != null && this.iCenterComp != null && this.iRightComp != null) {
            int pos;
            Toolkit tKit = Toolkit.getDefaultToolkit();
            Dimension screen = tKit.getScreenSize();
            Dimension size = this.getSize();
            this.getInnerPanel().add((Component)this.getInnerSplitPane(), "Center");
            this.getInnerSplitPane().add((Component)this.iLeftComp, "left");
            this.getInnerSplitPane().add((Component)this.iCenterComp, "right");
            this.getOuterSplitPane().add((Component)this.getInnerPanel(), "left");
            this.getOuterSplitPane().add((Component)this.iRightComp, "right");
            this.iSettingPos = true;
            if (this.iOuterAllPos > 0.0) {
                pos = (int)(this.iOuterAllPos * (double)size.width);
                this.getOuterSplitPane().setDividerLocation(pos);
            } else {
                pos = (int)(0.66 * (double)screen.width);
                this.getOuterSplitPane().setDividerLocation(pos);
            }
            if (this.iInnerPos > 0.0) {
                pos = (int)(this.iInnerPos * (double)size.width);
                this.getInnerSplitPane().setDividerLocation(pos);
            } else {
                pos = (int)(0.33 * (double)screen.width);
                this.getInnerSplitPane().setDividerLocation(pos);
            }
            this.iSettingPos = false;
        }
    }

    public void showComps(boolean showLeft, boolean showCenter) {
        int divPos = this.getOuterSplitPane().getDividerLocation();
        Dimension size = this.getSize();
        if (this.iShowedLeft && this.iShowedCenter) {
            this.iOuterAllPos = (double)divPos / (double)size.width;
        } else if (this.iShowedLeft) {
            this.iOuterLOnlyPos = (double)divPos / (double)size.width;
        } else if (this.iShowedCenter) {
            this.iOuterCOnlyPos = (double)divPos / (double)size.width;
        }
        this.removeAll();
        this.jOuterSplitPane = null;
        this.iInnerSplitPane = null;
        this.iInnerPanel = null;
        this.add(this.getOuterSplitPane());
        if (showLeft && showCenter) {
            this.showAll();
        } else if (showLeft) {
            this.showLeftRight();
        } else if (showCenter) {
            this.showCenterRight();
        } else {
            this.showRightOnly();
        }
        this.iShowedLeft = showLeft;
        this.iShowedCenter = showCenter;
        this.validate();
        this.repaint();
    }

    public void reshowComps() {
        this.showComps(this.iShowedLeft, this.iShowedCenter);
    }

    public void setupSizes() {
        Dimension dimen;
        if (this.iLeftComp != null) {
            dimen = this.iLeftComp.getSize();
            this.iLeftComp.setPreferredSize(dimen);
        }
        if (this.iRightComp != null) {
            dimen = this.iRightComp.getSize();
            this.iRightComp.setPreferredSize(dimen);
        }
        if (this.iCenterComp != null) {
            dimen = this.iCenterComp.getSize();
            this.iCenterComp.setPreferredSize(dimen);
        }
    }

    private void showLeftRight() {
        if (this.iLeftComp != null && this.iRightComp != null) {
            Dimension size = this.getSize();
            this.getOuterSplitPane().add((Component)this.iLeftComp, "left");
            this.getOuterSplitPane().add((Component)this.iRightComp, "right");
            this.iSettingPos = true;
            if (this.iOuterLOnlyPos > 0.0) {
                int pos = (int)(this.iOuterLOnlyPos * (double)size.width);
                this.getOuterSplitPane().setDividerLocation(pos);
            }
            this.iSettingPos = false;
        }
    }

    private void showCenterRight() {
        if (this.iCenterComp != null && this.iRightComp != null) {
            Dimension size = this.getSize();
            this.getOuterSplitPane().add((Component)this.iCenterComp, "left");
            this.getOuterSplitPane().add((Component)this.iRightComp, "right");
            this.iSettingPos = true;
            if (this.iOuterCOnlyPos > 0.0) {
                int pos = (int)(this.iOuterCOnlyPos * (double)size.width);
                this.getOuterSplitPane().setDividerLocation(pos);
            }
            this.iSettingPos = false;
        }
    }

    private void showRightOnly() {
        if (this.iRightComp != null) {
            this.add(this.iRightComp);
        }
    }

    private class InnerHandler
    implements PropertyChangeListener {
        private InnerHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("dividerLocation") && !NestedSplitPanel.this.iSettingPos) {
                int pos = (Integer)event.getNewValue();
                NestedSplitPanel.this.iInnerPos = (double)pos / (double)NestedSplitPanel.this.getSize().width;
                NestedSplitPanel.this.iOuterLOnlyPos = NestedSplitPanel.this.iInnerPos;
            }
        }
    }

    private class OuterHandler
    implements PropertyChangeListener {
        private OuterHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("dividerLocation") && !NestedSplitPanel.this.iSettingPos) {
                int pos = (Integer)event.getNewValue();
                if (NestedSplitPanel.this.iShowedLeft && NestedSplitPanel.this.iShowedCenter) {
                    NestedSplitPanel.this.iOuterAllPos = (double)pos / (double)NestedSplitPanel.this.getSize().width;
                } else if (NestedSplitPanel.this.iShowedLeft) {
                    NestedSplitPanel.this.iOuterLOnlyPos = (double)pos / (double)NestedSplitPanel.this.getSize().width;
                } else if (NestedSplitPanel.this.iShowedCenter) {
                    NestedSplitPanel.this.iOuterCOnlyPos = (double)pos / (double)NestedSplitPanel.this.getSize().width;
                }
            }
        }
    }
}

