/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import mlib.MString;
import swing.AdjustableDigit;
import swing.StatusBox;

public class DigitLongCounter {
    private long iCount = 0L;
    private long iMin = 0L;
    private long iMax = 100L;
    private int iStep = 1;
    private int iStrDigits = 0;
    private char[] iStr = null;
    private LinkedList<AdjustableDigit> iDigits = new LinkedList();
    private LinkedList<Listener> iLis = new LinkedList();

    public DigitLongCounter(long min, long max) {
        this.setMin(min);
        this.setMax(max);
    }

    public void setMin(long min) {
        this.iCount = this.iMin = min;
    }

    public void setMax(long max) {
        this.iMax = max;
        double digits = Math.log(this.iMax) / Math.log(10.0);
        this.iStrDigits = (int)(digits + 1.0);
        this.fixStr();
    }

    public long getCount() {
        return this.iCount;
    }

    public char digitChar(int digitPos) {
        return this.iStr[this.iStrDigits - digitPos - 1];
    }

    public synchronized boolean setCount(long count, String msg) {
        boolean set;
        boolean bl = set = count >= this.iMin && count <= this.iMax && count != this.iCount;
        if (set) {
            this.iCount = count;
            this.fixStr();
            this.showDigits();
            Event event = new Event(this, this.iCount);
            for (Listener lis : this.iLis) {
                lis.count(event);
            }
            if (msg != null) {
                StatusBox.singleton().showMsg(msg, false);
            }
        }
        return set;
    }

    public boolean change(long amount) {
        boolean set;
        boolean bl = set = amount != 0L;
        if (set) {
            long newValue = this.iCount + amount;
            set = this.setCount(newValue, null);
        }
        return set;
    }

    public void zero(int digitPos) {
        int endPos = this.iStr.length - 1;
        int i = 0;
        while (i <= digitPos) {
            this.iStr[endPos - i] = 48;
            ++i;
        }
        String str = new String(this.iStr).trim();
        long count = Long.parseLong(str);
        this.setCount(count, null);
    }

    private void fixStr() {
        MString str = new MString(Long.toString(this.iCount));
        str.addHead(' ', this.iStrDigits);
        this.iStr = str.toCharArray();
    }

    private void showDigits() {
        for (AdjustableDigit digit : this.iDigits) {
            digit.putText(this);
        }
    }

    public void addDigit(AdjustableDigit digit) {
        this.iDigits.add(digit);
    }

    public synchronized void addListener(Listener lis) {
        boolean exists = lis == null;
        Iterator iter = this.iLis.iterator();
        while (!exists && iter.hasNext()) {
            boolean bl = exists = iter.next() == lis;
        }
        if (!exists) {
            this.iLis.add(lis);
        }
    }

    public int getStep() {
        return this.iStep;
    }

    public void setStep(int step) {
        this.iStep = step;
    }

    public class Event
    extends EventObject {
        private long iCount;

        public Event(Object source, long count) {
            super(source);
            this.iCount = 0L;
            this.iCount = count;
        }

        public long getCount() {
            return this.iCount;
        }
    }

    public static interface Listener {
        public void count(Event var1);
    }
}

