/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.util.LinkedList;
import javax.swing.JPanel;
import swing.SwingProgram;
import utilt.Utility;

public class ColorPanel
extends JPanel {
    private static Color AllFore = SystemColor.windowText;
    private static Color AllBack = SwingProgram.DIALOGBACKCOLOR;
    private static LinkedList<ColorPanel> Instances = new LinkedList();
    private static Font AllFont = Utility.stdFont();

    public ColorPanel() {
        this.initialize();
    }

    public ColorPanel(boolean isDialog) {
        this.initialize();
        if (isDialog) {
            this.setBackground(SwingProgram.DIALOGBACKCOLOR);
            this.setForeground(SystemColor.windowText);
        }
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public static void putBackColorAll(Color back) {
        AllBack = back;
        for (ColorPanel panel : Instances) {
            panel.setBackground(AllBack);
        }
    }

    public static Color backColorAll() {
        return AllBack;
    }

    public static void putForeColorAll(Color fore) {
        AllFore = fore;
        for (ColorPanel panel : Instances) {
            panel.setForeground(AllFore);
        }
    }

    public static Color foreColorAll() {
        return AllFore;
    }

    public static void putFontAll(Font font) {
        AllFont = font;
        for (ColorPanel panel : Instances) {
            panel.setFont(AllFont);
        }
    }

    private void initialize() {
        this.addMouseListener(new MouseHandler());
        this.setBackground(AllBack);
        this.setForeground(AllFore);
        Instances.add(this);
    }

    private static class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }
    }
}

