/*
 * Decompiled with CFR 0.152.
 */
package popup;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

class PopupPanelLayout
extends FlowLayout
implements ComponentListener {
    private JScrollPane iScroller = null;
    private boolean iUniformHeight = false;
    private boolean iFirstTime = true;

    public PopupPanelLayout() {
        this(null, 0, 5, 5, false);
    }

    public PopupPanelLayout(JScrollPane scrollPane, int align, int hgap, int vgap, boolean uniformHeight) {
        super(align, hgap, vgap);
        this.fixScrollPane(scrollPane);
        this.iUniformHeight = uniformHeight;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateLayout();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    protected Dimension computeDesiredSize() {
        Dimension result = null;
        JViewport viewport = this.iScroller.getViewport();
        Dimension extent = viewport.getExtentSize();
        Component child = viewport.getView();
        if (child instanceof Container) {
            Container container = (Container)child;
            Insets insets = container.getInsets();
            int vgap = this.getVgap();
            int hgap = this.getHgap();
            int maxAllowedWidth = extent.width - (insets.left + insets.right + hgap * 2);
            int numComponents = container.getComponentCount();
            int x = 0;
            int y = insets.top + vgap;
            int rowh = 0;
            int maxRowWidth = 0;
            int start = 0;
            int i = 0;
            while (i < numComponents) {
                Component comp = container.getComponent(i);
                if (comp.isVisible()) {
                    Dimension dim = comp.getPreferredSize();
                    if (x == 0 || x + dim.width <= maxAllowedWidth) {
                        if (x > 0) {
                            x += hgap;
                        }
                        x += dim.width;
                        rowh = Math.max(rowh, dim.height);
                    } else {
                        if (this.iUniformHeight) {
                            this.fixHeights(container, rowh, start, i);
                        }
                        if (x > maxRowWidth - hgap) {
                            maxRowWidth = x + hgap;
                        }
                        x = dim.width;
                        y += vgap + rowh;
                        rowh = dim.height;
                        start = i;
                    }
                }
                ++i;
            }
            if (this.iUniformHeight) {
                this.fixHeights(container, rowh, start, numComponents);
            }
            if (x > maxRowWidth - hgap) {
                maxRowWidth = x + hgap;
            }
            result = new Dimension(maxRowWidth, y += vgap + rowh + insets.bottom);
        } else {
            Dimension prefSize = child.getPreferredSize();
            result = new Dimension(extent.width, prefSize.height);
        }
        return result;
    }

    public void fixHeights(Container container, int height, int startIndex, int endIndex) {
        int i = startIndex;
        while (i < endIndex) {
            Component comp = container.getComponent(i);
            if (comp instanceof JComponent) {
                this.setPreferredHeight((JComponent)comp, height);
            }
            ++i;
        }
    }

    public void fixScrollPane(JScrollPane scrollPane) {
        if (scrollPane != this.iScroller) {
            if (this.iScroller != null) {
                this.iScroller.removeComponentListener(this);
            }
            this.iScroller = scrollPane;
            if (this.iScroller != null) {
                this.iScroller.addComponentListener(this);
                JScrollBar vertBar = this.iScroller.getVerticalScrollBar();
                vertBar.setUnitIncrement(vertBar.getMaximum() / 5);
            }
        }
    }

    public boolean isUniformHeight() {
        return this.iUniformHeight;
    }

    @Override
    public void layoutContainer(Container c) {
        this.iFirstTime = true;
        if (this.iFirstTime) {
            this.updateLayout();
            this.iFirstTime = false;
        }
        super.layoutContainer(c);
    }

    public void setPreferredHeight(JComponent comp, int height) {
        Dimension prefSize = comp.getPreferredSize();
        prefSize.height = height;
        comp.setPreferredSize(prefSize);
    }

    public void setUniformHeight(boolean on) {
        if (this.iUniformHeight != on) {
            this.iUniformHeight = on;
            if (this.iScroller != null) {
                this.iScroller.doLayout();
            }
        }
    }

    protected void updateLayout() {
        if (this.iScroller != null) {
            JViewport viewport = this.iScroller.getViewport();
            Dimension viewSize = viewport.getViewSize();
            Dimension extentSize = viewport.getExtentSize();
            Dimension desiredSize = this.computeDesiredSize();
            if (viewSize.width != extentSize.width || viewSize.height != desiredSize.height) {
                Dimension newSize = new Dimension(Math.max(desiredSize.width, extentSize.width), Math.max(desiredSize.height, extentSize.height));
                Component child = viewport.getView();
                if (child instanceof JComponent) {
                    ((JComponent)child).setPreferredSize(newSize);
                }
                if (!this.iFirstTime) {
                    child.doLayout();
                    this.iScroller.doLayout();
                }
            }
        }
    }
}

