/*
 * Decompiled with CFR 0.152.
 */
package oroma.website;

import java.awt.GridLayout;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Stack;
import javax.swing.JPanel;
import mlib.MString;
import oroma.db.Database;
import oroma.db.ProgPreferences;
import oroma.db.Website;
import oroma.db.WebsiteDef;
import swing.EntryField;
import swing.WheelComboBox;
import swing.WheelSelectionPanel;
import utilt.Utility;

public class WebStructFields
extends JPanel {
    private WheelComboBox jTableCols = null;
    private WheelComboBox jTableRows = null;
    private WheelComboBox jImgAlign = null;
    private WheelComboBox jThumbSize = null;
    private WheelComboBox jMaxImgSize = null;
    private WheelComboBox jImgBorderWidth = null;
    private WheelComboBox jLinkType = null;
    private WheelComboBox jFontStyle = null;
    private WheelComboBox jTextFontSize = null;
    private WheelComboBox jHeaderFontSize = null;
    private WheelComboBox jSubtitleFontSize = null;
    private WheelComboBox jRowLines = null;
    private WheelComboBox jBackImg = null;
    private WheelComboBox jOrder = null;
    private EntryField jContact = new EntryField();
    private WheelSelectionPanel jThumbFields = WebStructFields.getFields();
    private WheelSelectionPanel jPhotoFields1 = WebStructFields.getFields();
    private WheelSelectionPanel jPhotoFields2 = WebStructFields.getFields();
    public static final String ASIS = "As is";
    public static final String NONE = "None";
    public static final int ASISINT = -1;
    public static final String SERIF = "Serif";
    public static final String SANSERIF = "Sanserif";
    public static final String[] FONTSTYLEOPTIONS = new String[]{"Serif", "Sanserif"};
    public static final String SMALLFONT = "Small";
    public static final String MEDIUMFONT = "Medium";
    public static final String LARGEFONT = "Large";
    public static final String XLARGEFONT = "X-Large";
    public static final String XXLARGEFONT = "XX-Large";
    public static final String[] FONTSIZEOPTIONS = new String[]{"Small", "Medium", "Large", "X-Large", "XX-Large"};
    public static final String[] IMAGEOPTIONS = new String[]{"480", "640", "800", "1024", "1200", "1500", "2000", "3000", "As is"};
    private static final String[] COLOPTIONS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private static final String[] ROWOPTIONS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "15"};
    private static final String[] THUMBOPTIONS = new String[]{"36", "48", "64", "96", "128", "196", "256", "384", "512"};
    private static final String[] BORDEROPTIONS = new String[]{"0", "1", "2", "3", "5", "10"};
    private static final String[] YESNOOPTIONS = new String[]{"Yes", "No"};
    private static final String[] ALIGNOPTIONS = new String[]{"Center", "Top"};
    private static final String[] LINKOPTIONS = new String[]{"Thumbnail and label", "Thumbnail, label, photo", "Thumbnail, label, photo, info"};
    private static final String[] ORDEROPTIONS = new String[]{"By date", "By region", "By group", "By id", "By pixels"};
    private static final int NUMFIELDCOMBOBOXES = 5;

    public WebStructFields() {
        this.setLayout(new GridLayout(0, 1));
        this.setBackground(ProgPreferences.singleton().dialogColor());
        this.add(this.getLinkType());
        this.add(this.getTableCols());
        this.add(this.getTableRows());
        this.add(this.getRowLines());
        this.add(this.getImgAlign());
        this.add(this.getThumbSize());
        this.add(this.getMaxImgSize());
        this.add(this.getImgBorderWidth());
        this.add(this.getFontStyle());
        this.add(this.getFontSize());
        this.add(this.getHeaderFontSize());
        this.add(this.getSubtitleFontSize());
        this.add(this.getBackImg());
        this.add(this.getOrder());
        this.add(this.jThumbFields);
        this.add(this.jPhotoFields1);
        this.add(this.jPhotoFields2);
        this.add(this.jContact);
    }

    public void fill(Website site) {
        WebsiteDef def = site.def();
        String selection = (String)this.getTableCols().getSelectedItem();
        def.setNumCols(Integer.parseInt(selection));
        selection = (String)this.getTableRows().getSelectedItem();
        def.setNumRows(Integer.parseInt(selection));
        selection = (String)this.getImgBorderWidth().getSelectedItem();
        def.setImgBorderWidth(Integer.parseInt(selection));
        selection = (String)this.getImgAlign().getSelectedItem();
        def.setImgAlign(selection);
        selection = (String)this.getLinkType().getSelectedItem();
        def.setType(selection);
        selection = (String)this.getThumbSize().getSelectedItem();
        def.setThumbSize(Integer.parseInt(selection));
        selection = (String)this.getMaxImgSize().getSelectedItem();
        if (selection.equals(ASIS)) {
            def.setMaxPicSize(-1);
        } else {
            def.setMaxPicSize(Integer.parseInt(selection));
        }
        selection = (String)this.getLinkType().getSelectedItem();
        def.setType(selection);
        selection = (String)this.getRowLines().getSelectedItem();
        def.setRowLines(selection.equals("Yes"));
        selection = (String)this.getFontStyle().getSelectedItem();
        def.setFontStyle(selection);
        selection = (String)this.getFontSize().getSelectedItem();
        def.setTextFontSize(selection);
        selection = (String)this.getHeaderFontSize().getSelectedItem();
        def.setHeaderFontSize(selection);
        selection = (String)this.getSubtitleFontSize().getSelectedItem();
        def.setSubtitleFontSize(selection);
        selection = (String)this.getBackImg().getSelectedItem();
        def.setBackImg(selection);
        def.setContact(this.jContact.getText());
        MString fields = this.jThumbFields.selections();
        String name = Utility.capFirstChar("date");
        if (fields.indexOf(name) < 0) {
            fields.concat(String.valueOf(',') + name);
        }
        def.setAnnot(fields.toString());
        fields = this.jPhotoFields1.selections();
        fields.concat(',');
        fields.concat(this.jPhotoFields2.selections());
        fields.trimTail(',');
        name = Utility.capFirstChar("date");
        if (fields.indexOf(name) < 0) {
            fields.concat(String.valueOf(',') + name);
        }
        def.setPhotoFields(fields.toString());
        selection = (String)this.getOrder().getSelectedItem();
        def.setImageOrder(selection);
    }

    public void put(Website site) {
        WebsiteDef def = site.def();
        this.getThumbSize().setEnabled(true);
        String size = Integer.toString(def.thumbSize());
        this.getThumbSize().setSelectedItem(size);
        String width = Integer.toString(def.imgBorderWidth());
        this.getImgBorderWidth().setSelectedItem(width);
        this.getImgAlign().setEnabled(true);
        this.getImgAlign().setSelectedItem(def.imgAlign());
        this.getMaxImgSize().setEnabled(true);
        int imgSize = def.maxPicSize();
        size = imgSize == -1 ? ASIS : Integer.toString(imgSize);
        this.getMaxImgSize().setSelectedItem(size);
        this.getTableCols().setEnabled(true);
        size = Integer.toString(def.numCols());
        this.getTableCols().setSelectedItem(size);
        this.getTableRows().setEnabled(true);
        size = Integer.toString(def.numRows());
        this.getTableRows().setSelectedItem(size);
        this.getLinkType().setEnabled(true);
        this.getLinkType().setSelectedItem(def.type());
        this.getRowLines().setEnabled(true);
        if (def.isRowLines()) {
            this.getRowLines().setSelectedItem("Yes");
        } else {
            this.getRowLines().setSelectedItem("No");
        }
        this.getFontStyle().setEnabled(true);
        this.getFontStyle().setSelectedItem(def.fontStyle());
        this.getFontSize().setEnabled(true);
        this.getFontSize().setSelectedItem(def.textFontSize());
        this.getHeaderFontSize().setEnabled(true);
        this.getHeaderFontSize().setSelectedItem(def.headerFontSize());
        this.getSubtitleFontSize().setEnabled(true);
        this.getSubtitleFontSize().setSelectedItem(def.subtitleFontSize());
        this.getBackImg().setEnabled(true);
        this.getBackImg().setSelectedItem(def.backImg());
        this.getOrder().setEnabled(true);
        this.getOrder().setSelectedItem(def.imageOrder());
        this.jContact.setText(def.contact());
        this.jContact.setEnabled(true);
        String[] fields = null;
        try {
            fields = Utility.parseDelimStr(site.def().annot(), ",");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Stack<String> stack = new Stack<String>();
        int i = fields.length - 1;
        while (i >= 0) {
            stack.push(fields[i]);
            --i;
        }
        this.jThumbFields.putSelections(stack);
        this.jThumbFields.setEnabled(true);
        fields = null;
        try {
            fields = Utility.parseDelimStr(site.def().photoFields(), ",");
        }
        catch (Exception exception) {
            // empty catch block
        }
        stack = new Stack();
        i = fields.length - 1;
        while (i >= 0) {
            stack.push(fields[i]);
            --i;
        }
        this.jPhotoFields1.putSelections(stack);
        this.jPhotoFields2.putSelections(stack);
        this.jPhotoFields1.setEnabled(true);
        this.jPhotoFields2.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.getTableCols().setEnabled(enable);
        this.getTableRows().setEnabled(enable);
        this.getImgAlign().setEnabled(enable);
        this.getThumbSize().setEnabled(enable);
        this.getMaxImgSize().setEnabled(enable);
        this.getImgBorderWidth().setEnabled(enable);
        this.getLinkType().setEnabled(enable);
        this.getRowLines().setEnabled(enable);
        this.getFontStyle().setEnabled(enable);
        this.getFontSize().setEnabled(enable);
        this.getHeaderFontSize().setEnabled(enable);
        this.getSubtitleFontSize().setEnabled(enable);
        this.getBackImg().setEnabled(enable);
        this.jThumbFields.setEnabled(enable);
        this.jPhotoFields1.setEnabled(enable);
        this.jPhotoFields2.setEnabled(enable);
        this.jContact.setEnabled(enable);
        this.jOrder.setEnabled(enable);
    }

    private WheelComboBox getTableCols() {
        if (this.jTableCols == null) {
            this.jTableCols = new WheelComboBox();
            this.jTableCols.setEditable(false);
            this.jTableCols.setItems(COLOPTIONS);
            this.jTableCols.setWheelEnabled(true);
            this.jTableCols.setKeepOrder(true);
        }
        return this.jTableCols;
    }

    private WheelComboBox getThumbSize() {
        if (this.jThumbSize == null) {
            this.jThumbSize = new WheelComboBox();
            this.jThumbSize.setItems(THUMBOPTIONS);
            this.jThumbSize.setEditable(false);
            this.jThumbSize.setWheelEnabled(true);
            this.jThumbSize.setKeepOrder(true);
        }
        return this.jThumbSize;
    }

    private WheelComboBox getMaxImgSize() {
        if (this.jMaxImgSize == null) {
            this.jMaxImgSize = new WheelComboBox();
            this.jMaxImgSize.setItems(IMAGEOPTIONS);
            this.jMaxImgSize.setEditable(false);
            this.jMaxImgSize.setWheelEnabled(true);
            this.jMaxImgSize.setKeepOrder(true);
        }
        return this.jMaxImgSize;
    }

    private WheelComboBox getLinkType() {
        if (this.jLinkType == null) {
            this.jLinkType = new WheelComboBox();
            this.jLinkType.setItems(LINKOPTIONS);
            this.jLinkType.setEditable(false);
            this.jLinkType.setWheelEnabled(true);
            this.jLinkType.setKeepOrder(true);
        }
        return this.jLinkType;
    }

    private WheelComboBox getFontStyle() {
        if (this.jFontStyle == null) {
            this.jFontStyle = new WheelComboBox();
            this.jFontStyle.setItems(FONTSTYLEOPTIONS);
            this.jFontStyle.setEditable(false);
            this.jFontStyle.setWheelEnabled(true);
            this.jFontStyle.setKeepOrder(true);
        }
        return this.jFontStyle;
    }

    private WheelComboBox getFontSize() {
        if (this.jTextFontSize == null) {
            this.jTextFontSize = new WheelComboBox();
            this.jTextFontSize.setItems(FONTSIZEOPTIONS);
            this.jTextFontSize.setEditable(false);
            this.jTextFontSize.setWheelEnabled(true);
            this.jTextFontSize.setKeepOrder(true);
        }
        return this.jTextFontSize;
    }

    private WheelComboBox getHeaderFontSize() {
        if (this.jHeaderFontSize == null) {
            this.jHeaderFontSize = new WheelComboBox();
            this.jHeaderFontSize.setItems(FONTSIZEOPTIONS);
            this.jHeaderFontSize.setEditable(false);
            this.jHeaderFontSize.setWheelEnabled(true);
            this.jHeaderFontSize.setKeepOrder(true);
        }
        return this.jHeaderFontSize;
    }

    private WheelComboBox getSubtitleFontSize() {
        if (this.jSubtitleFontSize == null) {
            this.jSubtitleFontSize = new WheelComboBox();
            this.jSubtitleFontSize.setItems(FONTSIZEOPTIONS);
            this.jSubtitleFontSize.setEditable(false);
            this.jSubtitleFontSize.setWheelEnabled(true);
            this.jSubtitleFontSize.setKeepOrder(true);
        }
        return this.jSubtitleFontSize;
    }

    private WheelComboBox getImgAlign() {
        if (this.jImgAlign == null) {
            this.jImgAlign = new WheelComboBox();
            this.jImgAlign.setItems(ALIGNOPTIONS);
            this.jImgAlign.setEditable(false);
            this.jImgAlign.setWheelEnabled(true);
            this.jImgAlign.setKeepOrder(true);
        }
        return this.jImgAlign;
    }

    private WheelComboBox getRowLines() {
        if (this.jRowLines == null) {
            this.jRowLines = new WheelComboBox();
            this.jRowLines.setItems(YESNOOPTIONS);
            this.jRowLines.setEditable(false);
            this.jRowLines.setWheelEnabled(true);
            this.jRowLines.setKeepOrder(true);
        }
        return this.jRowLines;
    }

    private WheelComboBox getTableRows() {
        if (this.jTableRows == null) {
            this.jTableRows = new WheelComboBox();
            this.jTableRows.setItems(ROWOPTIONS);
            this.jTableRows.setEditable(false);
            this.jTableRows.setWheelEnabled(true);
            this.jTableRows.setKeepOrder(true);
        }
        return this.jTableRows;
    }

    private WheelComboBox getOrder() {
        if (this.jOrder == null) {
            this.jOrder = new WheelComboBox();
            this.jOrder.setItems(ORDEROPTIONS);
            this.jOrder.setEditable(false);
            this.jOrder.setWheelEnabled(true);
            this.jOrder.setKeepOrder(true);
        }
        return this.jOrder;
    }

    private WheelComboBox getImgBorderWidth() {
        if (this.jImgBorderWidth == null) {
            this.jImgBorderWidth = new WheelComboBox();
            this.jImgBorderWidth.setItems(BORDEROPTIONS);
            this.jImgBorderWidth.setEditable(false);
            this.jImgBorderWidth.setWheelEnabled(true);
            this.jImgBorderWidth.setKeepOrder(true);
        }
        return this.jImgBorderWidth;
    }

    private static WheelSelectionPanel getFields() {
        ProgPreferences pref = ProgPreferences.singleton();
        LinkedList<String> fieldNames = new LinkedList<String>();
        LinkedList<String> temp = new LinkedList<String>();
        temp.addAll(pref.dispFields());
        temp.add("notes");
        temp.add("date");
        temp.add(" ");
        for (String name : temp) {
            MString work = new MString(name);
            work.capFirstChar();
            fieldNames.add(work.toString());
        }
        Collections.reverse(fieldNames);
        String[] wheelOptions = fieldNames.toArray(new String[0]);
        WheelSelectionPanel panel = new WheelSelectionPanel(5, 5, wheelOptions);
        return panel;
    }

    private WheelComboBox getBackImg() {
        if (this.jBackImg == null) {
            this.jBackImg = new WheelComboBox();
            this.jBackImg.setEditable(false);
            this.jBackImg.setWheelEnabled(true);
            this.jBackImg.setKeepOrder(true);
            LinkedList<String> imgs = new LinkedList<String>();
            imgs.add(NONE);
            String path = String.valueOf(Database.singleton().parms().bpmPath().path()) + "bgnds";
            File dir = new File(path);
            String[] names = dir.list();
            int i = 0;
            while (i < names.length) {
                String name = names[i].toLowerCase();
                if (name.endsWith(".jpg") || name.endsWith(".gif")) {
                    imgs.add(names[i]);
                }
                ++i;
            }
            this.jBackImg.setItems(imgs.toArray(new String[0]));
        }
        return this.jBackImg;
    }
}

