/*
 * Decompiled with CFR 0.152.
 */
package oroma.website;

import files.ApacheFtpServer;
import files.FtpServer;
import java.util.Date;
import mlib.MAppMsg;
import oroma.db.Database;
import oroma.db.Website;
import oroma.db.WebsiteDef;
import oroma.gui.BpmMsgs;
import oroma.gui.Main;
import oroma.website.WebDefDialog;
import swing.StatusBox;
import utilt.Utility;

public class WebMgr
extends Thread {
    private Website iSite = null;
    private boolean iBuild = true;
    private static boolean BuildActive = false;
    private static boolean UploadActive = false;

    public static boolean buildActive() {
        return BuildActive;
    }

    public static boolean uploadActive() {
        return UploadActive;
    }

    public static ApacheFtpServer connectToServer(Website site) throws Exception {
        ApacheFtpServer server = new ApacheFtpServer(Main.singleton().logger());
        server.setHoldCount(FtpServer.defaultHoldCount());
        WebsiteDef def = site.def();
        FtpServer.Parms parms = new FtpServer.Parms(def.ftpHost(), def.ftpUserid(), def.ftpPassword(), "");
        server.setParms(parms);
        try {
            server.connect();
        }
        catch (Exception xcp) {
            MAppMsg msg = BpmMsgs.get("unable_connect_server");
            String text = Utility.xcpMsg(xcp);
            StatusBox.singleton().queueShowMsg(msg.format(text), msg.isError());
        }
        return server;
    }

    public static void halt() {
        if (BuildActive) {
            BuildActive = false;
            UploadActive = false;
        } else if (UploadActive) {
            BuildActive = false;
            UploadActive = false;
        }
    }

    public WebMgr(Website site, boolean build) {
        this.iSite = site;
        this.iBuild = build;
        BuildActive = false;
        UploadActive = false;
    }

    @Override
    public void run() {
        Date lastBuild = this.iSite.lastBuild();
        Date lastUpload = this.iSite.lastUpload();
        Date curDate = new Date();
        try {
            if (this.iBuild) {
                if (this.doBuild(curDate)) {
                    lastBuild = curDate;
                }
            } else if (lastUpload == null || lastBuild.after(lastUpload)) {
                if (this.doUpload(curDate)) {
                    lastUpload = curDate;
                }
            } else {
                MAppMsg msg = BpmMsgs.get("website_uptodate");
                String text = msg.format(this.iSite.def().albumName());
                StatusBox.singleton().queueShowMsg(text, false);
            }
            WebDefDialog.putDates(lastBuild, lastUpload);
        }
        catch (Exception xcp) {
            String msg = Utility.xcpMsg(xcp);
            StatusBox.singleton().queueShowMsg(msg, true);
        }
        WebDefDialog.enableBuild(true);
        WebDefDialog.enableUpload(this.iSite.lastBuild() != null);
        WebDefDialog.enableCancel(true);
        WebDefDialog.enableDelete(true);
        WebDefDialog.enableInput(true);
    }

    private boolean doBuild(Date curDate) {
        boolean result = false;
        BuildActive = true;
        try {
            this.iSite.build(curDate, Main.singleton().logger());
            Database.singleton().webDb().put(this.iSite);
            WebDefDialog.enableUpload(true);
            WebDefDialog.enableDelete(true);
            result = true;
        }
        catch (Exception xcp) {
            String text = Utility.xcpMsg(xcp);
            StatusBox.singleton().queueShowMsg(text, true);
        }
        BuildActive = false;
        return result;
    }

    private boolean doUpload(Date curDate) {
        boolean result;
        block14: {
            result = false;
            UploadActive = true;
            Database db = Database.singleton();
            ApacheFtpServer server = null;
            try {
                try {
                    server = WebMgr.connectToServer(this.iSite);
                    String hostDir = "";
                    if (this.iSite.def().ftpDir().length() > 0) {
                        hostDir = String.valueOf(hostDir) + this.iSite.def().ftpDir();
                        try {
                            ((FtpServer)server).mkdir(hostDir);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        hostDir = String.valueOf(hostDir) + "/";
                    }
                    this.iSite.upload(server, hostDir, curDate);
                    this.iSite.setLastUpload(curDate);
                    WebDefDialog.enableUpload(true);
                    WebDefDialog.enableDelete(true);
                    result = true;
                }
                catch (Exception xcp) {
                    StatusBox.singleton().queueShowMsg(Utility.xcpMsg(xcp), true);
                    WebDefDialog.enableUpload(this.iSite.lastBuild() != null);
                    try {
                        db.webDb().put(this.iSite);
                        ((FtpServer)server).disconnect();
                    }
                    catch (Exception exception) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    db.webDb().put(this.iSite);
                    ((FtpServer)server).disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                db.webDb().put(this.iSite);
                ((FtpServer)server).disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        UploadActive = false;
        return result;
    }
}

