/*
 * Decompiled with CFR 0.152.
 */
package oroma.prefgui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oroma.db.ProgPreferences;
import oroma.prefgui.ColorsTabPanel;
import oroma.prefgui.DisplayTabPanel;
import oroma.prefgui.OtherTabPanel;
import swing.StdScrollPane;
import swing.SwingProgram;

public class PrefPanel
extends JPanel {
    private JTabbedPane jPane = new JTabbedPane();
    private ColorsTabPanel jColorsPanel = null;
    private DisplayTabPanel jDisplayPanel = null;
    private OtherTabPanel jOtherPanel = null;
    private static final int DISPLAYTAB = 0;
    private static final int COLORSTAB = 1;
    private static final int OTHERTAB = 2;

    public PrefPanel() {
        this.setBackground(ProgPreferences.singleton().dialogColor());
        this.setLayout(new BorderLayout());
        this.setBackground(ProgPreferences.singleton().dialogColor());
        this.jPane.addTab(" Display ", null, new StdScrollPane(this.getDisplayPanel()), null);
        this.jPane.setBackgroundAt(0, SwingProgram.TAB0COLOR);
        this.jPane.addTab(" Colors ", null, new StdScrollPane(this.getColorsPanel()), null);
        this.jPane.setBackgroundAt(1, SwingProgram.TAB3COLOR);
        this.jPane.addTab(" Other ", null, new StdScrollPane(this.getOtherPanel()), null);
        this.jPane.setBackgroundAt(2, SwingProgram.TAB1COLOR);
        this.selectTab(0);
        this.jPane.addChangeListener(new TabHandler());
        Font font = ProgPreferences.singleton().menuFont();
        this.jPane.setFont(font.deriveFont(1));
        this.add((Component)this.jPane, "Center");
    }

    public void showPrefs() {
        this.jDisplayPanel.showPrefs();
        this.jOtherPanel.showPrefs();
    }

    public void savePrefs() {
        this.jDisplayPanel.savePrefs();
        this.jOtherPanel.savePrefs();
    }

    public Component obtainFocusComp() {
        return this.getDisplayPanel().obtainFocusComp();
    }

    private void selectTab(int tab) {
        this.jPane.setForegroundAt(0, SwingProgram.TABFADECOLOR);
        this.jPane.setForegroundAt(1, SwingProgram.TABFADECOLOR);
        this.jPane.setForegroundAt(2, SwingProgram.TABFADECOLOR);
        this.jPane.setForegroundAt(tab, SwingProgram.TABFORECOLOR);
    }

    private ColorsTabPanel getColorsPanel() {
        if (this.jColorsPanel == null) {
            this.jColorsPanel = new ColorsTabPanel();
        }
        return this.jColorsPanel;
    }

    private DisplayTabPanel getDisplayPanel() {
        if (this.jDisplayPanel == null) {
            this.jDisplayPanel = new DisplayTabPanel();
        }
        return this.jDisplayPanel;
    }

    private OtherTabPanel getOtherPanel() {
        if (this.jOtherPanel == null) {
            this.jOtherPanel = new OtherTabPanel();
        }
        return this.jOtherPanel;
    }

    private class TabHandler
    implements ChangeListener {
        private TabHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            int tab = PrefPanel.this.jPane.getSelectedIndex();
            PrefPanel.this.selectTab(tab);
        }
    }
}

