/*
 * Decompiled with CFR 0.152.
 */
package oroma.prefgui;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;
import oroma.db.ProgPreferences;
import swing.SwingProgram;
import swing.WheelComboBox;

public class DisplayFields
extends JPanel {
    private WheelComboBox jFontSize = null;
    private WheelComboBox jZoomStep = null;
    private WheelComboBox jMarkerSize = null;
    private WheelComboBox jBoldFonts = null;
    private WheelComboBox jImageMargin = null;
    private WheelComboBox jSlideInterval = null;
    private WheelComboBox jSlideSize = null;
    private WheelComboBox jLookAndFeel = null;
    private WheelComboBox jThumbSize = null;
    private WheelComboBox jAlbumThumbSize = null;
    private WheelComboBox jAlbumBarLayout = null;
    private static final String[] FONTOPTIONS = new String[]{"10", "12", "14", "16", "18", "20", "22", "24"};
    private static final String[] YESNOOPTIONS = new String[]{"Yes", "No"};
    private static final String[] BARLAYOUTOPTIONS = new String[]{"Grid", "Flow"};
    private static final String[] ZOOMSTEPOPTIONS = new String[]{"5", "10", "25", "50", "75", "90"};
    private static final String[] MARKERSIZEOPTIONS = new String[]{"4", "8", "12", "16", "20"};
    private static final String[] MARGINOPTIONS = new String[]{"0", "5", "10", "25", "50", "75", "100"};
    private static final String[] INTERVALOPTIONS = new String[]{"1", "2", "3", "5", "7", "10", "15", "25", "60"};
    private static final String[] SLIDESIZEOPTIONS = new String[]{"50%", "60%", "70%", "80%", "95%"};
    private static final String[] THUMBOPTIONS = new String[]{"36", "48", "64", "96", "128", "196", "256"};

    public DisplayFields() {
        this.setLayout(new GridLayout(0, 1));
        this.setBackground(ProgPreferences.singleton().dialogColor());
        this.add(this.getFontSize());
        this.add(this.getBoldFonts());
        this.add(this.getAlbumBarLayout());
        this.add(this.getZoomStep());
        this.add(this.getImageMargin());
        this.add(this.getMarkerSize());
        this.add(this.getSlideInterval());
        this.add(this.getSlideSize());
        this.add(this.getThumbSize());
        this.add(this.getAlbumThumbSize());
        this.add(this.getLookAndFeel());
    }

    public Component obtainFocusComp() {
        return this.jFontSize;
    }

    public void showPrefs() {
        String size;
        ProgPreferences pref = ProgPreferences.singleton();
        this.getFontSize().setEnabled(true);
        int fontSize = pref.menuFont().getSize();
        int minDiff = Integer.MAX_VALUE;
        String best = "";
        String[] stringArray = FONTOPTIONS;
        int n = FONTOPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            size = stringArray[n2];
            int diff = Math.abs(Integer.parseInt(size) - fontSize);
            if (diff < minDiff) {
                minDiff = diff;
                best = size;
            }
            ++n2;
        }
        if (best.length() == 0) {
            best = FONTOPTIONS[0];
        }
        this.getFontSize().setSelectedItem(best);
        this.getAlbumBarLayout().setEnabled(true);
        if (pref.albumBarLayout().equals("Grid")) {
            this.getAlbumBarLayout().setSelectedItem("Grid");
        } else {
            this.getAlbumBarLayout().setSelectedItem("Flow");
        }
        this.getZoomStep().setEnabled(true);
        size = Integer.toString(pref.zoomStepSize());
        this.getZoomStep().setSelectedItem(size);
        this.getImageMargin().setEnabled(true);
        size = Integer.toString(pref.imageMargin());
        this.getImageMargin().setSelectedItem(size);
        this.getMarkerSize().setEnabled(true);
        this.getMarkerSize().setSelectedItem(Integer.toString(pref.tagMarkerSize()));
        this.getBoldFonts().setEnabled(true);
        if (pref.useBoldFonts()) {
            this.getBoldFonts().setSelectedItem("Yes");
        } else {
            this.getBoldFonts().setSelectedItem("No");
        }
        this.getSlideInterval().setEnabled(true);
        size = Integer.toString(pref.slideInterval());
        this.getSlideInterval().setSelectedItem(size);
        this.getSlideSize().setEnabled(true);
        size = String.valueOf(Integer.toString(pref.slideSizePc())) + "%";
        this.getSlideSize().setSelectedItem(size);
        this.getLookAndFeel().setEnabled(true);
        String option = pref.lookAndFeel();
        this.getLookAndFeel().setSelectedItem(option);
        this.getThumbSize().setEnabled(true);
        this.getThumbSize().setSelectedItem(Integer.toString(pref.thumbnailSize()));
        this.getAlbumThumbSize().setEnabled(true);
        this.getAlbumThumbSize().setSelectedItem(Integer.toString(pref.albumThumbnailSize()));
    }

    public void savePrefs() {
        ProgPreferences pref = ProgPreferences.singleton();
        String selection = (String)this.getFontSize().getSelectedItem();
        pref.setFontSize(Integer.parseInt(selection));
        selection = (String)this.getAlbumBarLayout().getSelectedItem();
        pref.setAlbumBarLayout(selection);
        selection = (String)this.getZoomStep().getSelectedItem();
        pref.setZoomStepSize(Integer.parseInt(selection));
        selection = (String)this.getMarkerSize().getSelectedItem();
        pref.setTagMarkerSize(Integer.parseInt(selection));
        selection = (String)this.getImageMargin().getSelectedItem();
        pref.setImageMargin(Integer.parseInt(selection));
        selection = (String)this.getBoldFonts().getSelectedItem();
        pref.setUseBoldFonts(selection.equals("Yes"));
        selection = (String)this.getSlideInterval().getSelectedItem();
        pref.setSlideInterval(Integer.parseInt(selection));
        selection = (String)this.getSlideSize().getSelectedItem();
        int index = selection.indexOf(37);
        String percent = selection.substring(0, index);
        pref.setSlideSizePc(Integer.parseInt(percent));
        selection = (String)this.getLookAndFeel().getSelectedItem();
        pref.setLookAndFeel(selection);
        selection = (String)this.getThumbSize().getSelectedItem();
        pref.setThumbnailSize(Integer.parseInt(selection));
        selection = (String)this.getAlbumThumbSize().getSelectedItem();
        pref.setAlbumThumbnailSize(Integer.parseInt(selection));
    }

    private WheelComboBox getBoldFonts() {
        if (this.jBoldFonts == null) {
            this.jBoldFonts = new WheelComboBox();
            this.jBoldFonts.setItems(YESNOOPTIONS);
            this.jBoldFonts.setEditable(false);
            this.jBoldFonts.setWheelEnabled(true);
            this.jBoldFonts.setKeepOrder(true);
        }
        return this.jBoldFonts;
    }

    private WheelComboBox getFontSize() {
        if (this.jFontSize == null) {
            this.jFontSize = new WheelComboBox();
            this.jFontSize.setItems(FONTOPTIONS);
            this.jFontSize.setEditable(false);
            this.jFontSize.setWheelEnabled(true);
            this.jFontSize.setKeepOrder(true);
        }
        return this.jFontSize;
    }

    private WheelComboBox getMarkerSize() {
        if (this.jMarkerSize == null) {
            this.jMarkerSize = new WheelComboBox();
            this.jMarkerSize.setItems(MARKERSIZEOPTIONS);
            this.jMarkerSize.setEditable(false);
            this.jMarkerSize.setWheelEnabled(true);
            this.jMarkerSize.setKeepOrder(true);
        }
        return this.jMarkerSize;
    }

    private WheelComboBox getZoomStep() {
        if (this.jZoomStep == null) {
            this.jZoomStep = new WheelComboBox();
            this.jZoomStep.setItems(ZOOMSTEPOPTIONS);
            this.jZoomStep.setEditable(false);
            this.jZoomStep.setWheelEnabled(true);
            this.jZoomStep.setKeepOrder(true);
        }
        return this.jZoomStep;
    }

    private WheelComboBox getImageMargin() {
        if (this.jImageMargin == null) {
            this.jImageMargin = new WheelComboBox();
            this.jImageMargin.setItems(MARGINOPTIONS);
            this.jImageMargin.setEditable(false);
            this.jImageMargin.setWheelEnabled(true);
            this.jImageMargin.setKeepOrder(true);
        }
        return this.jImageMargin;
    }

    private WheelComboBox getSlideInterval() {
        if (this.jSlideInterval == null) {
            this.jSlideInterval = new WheelComboBox();
            this.jSlideInterval.setItems(INTERVALOPTIONS);
            this.jSlideInterval.setEditable(false);
            this.jSlideInterval.setWheelEnabled(true);
            this.jSlideInterval.setKeepOrder(true);
        }
        return this.jSlideInterval;
    }

    private WheelComboBox getSlideSize() {
        if (this.jSlideSize == null) {
            this.jSlideSize = new WheelComboBox();
            this.jSlideSize.setItems(SLIDESIZEOPTIONS);
            this.jSlideSize.setEditable(false);
            this.jSlideSize.setWheelEnabled(true);
            this.jSlideSize.setKeepOrder(true);
        }
        return this.jSlideSize;
    }

    private WheelComboBox getLookAndFeel() {
        if (this.jLookAndFeel == null) {
            this.jLookAndFeel = new WheelComboBox();
            this.jLookAndFeel.setItems(SwingProgram.LFOPTIONS);
            this.jLookAndFeel.setEditable(false);
            this.jLookAndFeel.setWheelEnabled(true);
            this.jLookAndFeel.setKeepOrder(true);
        }
        return this.jLookAndFeel;
    }

    private WheelComboBox getAlbumThumbSize() {
        if (this.jAlbumThumbSize == null) {
            this.jAlbumThumbSize = new WheelComboBox();
            this.jAlbumThumbSize.setItems(THUMBOPTIONS);
            this.jAlbumThumbSize.setEditable(false);
            this.jAlbumThumbSize.setWheelEnabled(true);
            this.jAlbumThumbSize.setKeepOrder(true);
        }
        return this.jAlbumThumbSize;
    }

    private WheelComboBox getThumbSize() {
        if (this.jThumbSize == null) {
            this.jThumbSize = new WheelComboBox();
            this.jThumbSize.setItems(THUMBOPTIONS);
            this.jThumbSize.setEditable(false);
            this.jThumbSize.setWheelEnabled(true);
            this.jThumbSize.setKeepOrder(true);
        }
        return this.jThumbSize;
    }

    private WheelComboBox getAlbumBarLayout() {
        if (this.jAlbumBarLayout == null) {
            this.jAlbumBarLayout = new WheelComboBox();
            this.jAlbumBarLayout.setItems(BARLAYOUTOPTIONS);
            this.jAlbumBarLayout.setEditable(false);
            this.jAlbumBarLayout.setWheelEnabled(true);
            this.jAlbumBarLayout.setKeepOrder(true);
        }
        return this.jAlbumBarLayout;
    }
}

