/*
 * Decompiled with CFR 0.152.
 */
package oroma.prefgui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import oroma.db.ProgPreferences;
import oroma.gui.Main;
import swing.ColorButton;

public class ColorsTabPanel
extends JPanel {
    private ColorButton jEntryBackButton = null;
    private ColorButton jEntryForeButton = null;
    private ColorButton jSelButton = null;
    private ColorButton jMarkerButton = null;
    private ColorButton jTagBackButton = null;
    private ColorButton jPanelBackButton = null;
    private ColorButton jPanelForeButton = null;
    private ColorButton jHeaderBackButton = null;
    private ColorButton jDialogButton = null;
    private ColorButton jErrorMsgButton = null;

    public ColorsTabPanel() {
        this.setLayout(new GridLayout(0, 1));
        this.add(this.getSelButton());
        this.add(this.getPanelBackButton());
        this.add(this.getPanelForeButton());
        this.add(this.getHeaderBackButton());
        this.add(this.getDialogButton());
        this.add(this.getMarkerButton());
        this.add(this.getTagBackButton());
        this.add(this.getEntryBackButton());
        this.add(this.getEntryForeButton());
        this.add(this.getErrorMsgButton());
        ActionHandler handler = new ActionHandler();
        this.getEntryBackButton().addActionListener(handler);
        this.getEntryForeButton().addActionListener(handler);
        this.getSelButton().addActionListener(handler);
        this.getMarkerButton().addActionListener(handler);
        this.getTagBackButton().addActionListener(handler);
        this.getPanelBackButton().addActionListener(handler);
        this.getPanelForeButton().addActionListener(handler);
        this.getHeaderBackButton().addActionListener(handler);
        this.getDialogButton().addActionListener(handler);
        this.getErrorMsgButton().addActionListener(handler);
        this.getEntryBackButton().setEnabled(true);
        this.getEntryForeButton().setEnabled(true);
        this.getSelButton().setEnabled(true);
        this.getMarkerButton().setEnabled(true);
        this.getTagBackButton().setEnabled(true);
        this.getPanelBackButton().setEnabled(true);
        this.getPanelForeButton().setEnabled(true);
        this.getHeaderBackButton().setEnabled(true);
        this.getDialogButton().setEnabled(true);
        this.getErrorMsgButton().setEnabled(true);
    }

    private ColorButton getEntryBackButton() {
        if (this.jEntryBackButton == null) {
            this.jEntryBackButton = new ColorButton("Entry background color");
            this.jEntryBackButton.setShowBorder(true);
        }
        return this.jEntryBackButton;
    }

    private ColorButton getEntryForeButton() {
        if (this.jEntryForeButton == null) {
            this.jEntryForeButton = new ColorButton("Entry foreground color");
            this.jEntryForeButton.setShowBorder(true);
        }
        return this.jEntryForeButton;
    }

    private ColorButton getMarkerButton() {
        if (this.jMarkerButton == null) {
            this.jMarkerButton = new ColorButton("Tag marker color");
            this.jMarkerButton.setShowBorder(true);
        }
        return this.jMarkerButton;
    }

    private ColorButton getSelButton() {
        if (this.jSelButton == null) {
            this.jSelButton = new ColorButton("Selection foreground color");
            this.jSelButton.setShowBorder(true);
        }
        return this.jSelButton;
    }

    private ColorButton getTagBackButton() {
        if (this.jTagBackButton == null) {
            this.jTagBackButton = new ColorButton("Tag background color");
            this.jTagBackButton.setShowBorder(true);
        }
        return this.jTagBackButton;
    }

    private ColorButton getPanelBackButton() {
        if (this.jPanelBackButton == null) {
            this.jPanelBackButton = new ColorButton("Panel background color");
            this.jPanelBackButton.setShowBorder(true);
        }
        return this.jPanelBackButton;
    }

    private ColorButton getPanelForeButton() {
        if (this.jPanelForeButton == null) {
            this.jPanelForeButton = new ColorButton("Panel foreground color");
            this.jPanelForeButton.setShowBorder(true);
        }
        return this.jPanelForeButton;
    }

    private ColorButton getHeaderBackButton() {
        if (this.jHeaderBackButton == null) {
            this.jHeaderBackButton = new ColorButton("Header background color");
            this.jHeaderBackButton.setShowBorder(true);
        }
        return this.jHeaderBackButton;
    }

    private ColorButton getErrorMsgButton() {
        if (this.jErrorMsgButton == null) {
            this.jErrorMsgButton = new ColorButton("Error message color");
            this.jErrorMsgButton.setShowBorder(true);
        }
        return this.jErrorMsgButton;
    }

    private ColorButton getDialogButton() {
        if (this.jDialogButton == null) {
            this.jDialogButton = new ColorButton("Dialog background color");
            this.jDialogButton.setShowBorder(true);
        }
        return this.jDialogButton;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ProgPreferences pref = ProgPreferences.singleton();
            if (event.getSource() == ColorsTabPanel.this.getEntryBackButton()) {
                this.doEntryBack(pref);
            } else if (event.getSource() == ColorsTabPanel.this.getEntryForeButton()) {
                this.doEntryFore(pref);
            } else if (event.getSource() == ColorsTabPanel.this.getSelButton()) {
                this.doSelection(pref);
            } else if (event.getSource() == ColorsTabPanel.this.getPanelBackButton()) {
                this.doPanelBack(pref);
            } else if (event.getSource() == ColorsTabPanel.this.getPanelForeButton()) {
                this.doPanelFore(pref);
            } else if (event.getSource() == ColorsTabPanel.this.getMarkerButton()) {
                this.doMarker(pref);
            } else if (event.getSource() == ColorsTabPanel.this.getHeaderBackButton()) {
                this.doHeaderBack(pref);
            } else if (event.getSource() == ColorsTabPanel.this.getDialogButton()) {
                this.doDialogBack(pref);
            } else if (event.getSource() == ColorsTabPanel.this.getErrorMsgButton()) {
                this.doErrorMsg(pref);
            } else {
                this.doTagBack(pref);
            }
        }

        private void doHeaderBack(ProgPreferences pref) {
            Color back = JColorChooser.showDialog(Main.singleton(), "Header background color", pref.headerBackColor());
            if (back != null) {
                pref.setHeaderBackColor(back);
            }
        }

        private void doTagBack(ProgPreferences pref) {
            Color back = JColorChooser.showDialog(Main.singleton(), "Tag background color", pref.tagBackColor());
            if (back != null) {
                pref.setTagBackColor(back);
            }
        }

        private void doEntryBack(ProgPreferences pref) {
            Color back = JColorChooser.showDialog(Main.singleton(), "Entry background color", pref.entryBackColor());
            if (back != null) {
                pref.setEntryBackColor(back);
            }
        }

        private void doEntryFore(ProgPreferences pref) {
            Color fore = JColorChooser.showDialog(Main.singleton(), "Entry foreground color", pref.entryForeColor());
            if (fore != null) {
                pref.setEntryForeColor(fore);
            }
        }

        private void doPanelBack(ProgPreferences pref) {
            Color color = JColorChooser.showDialog(Main.singleton(), "Panel background color", pref.panelBackColor());
            if (color != null) {
                pref.setPanelBackColor(color);
            }
        }

        private void doPanelFore(ProgPreferences pref) {
            Color color = JColorChooser.showDialog(Main.singleton(), "Panel foreground color", pref.panelForeColor());
            if (color != null) {
                pref.setPanelForeColor(color);
            }
        }

        private void doDialogBack(ProgPreferences pref) {
            Color back = JColorChooser.showDialog(Main.singleton(), "Dialog background color", pref.headerBackColor());
            if (back != null) {
                pref.setDialogColor(back);
            }
        }

        private void doErrorMsg(ProgPreferences pref) {
            Color msg = JColorChooser.showDialog(Main.singleton(), "Error message color", pref.errorMsgColor());
            if (msg != null) {
                pref.setErrorMsgColor(msg);
            }
        }

        private void doSelection(ProgPreferences pref) {
            Color sel = JColorChooser.showDialog(Main.singleton(), "Selection foreground color", pref.selectionColor());
            if (sel != null) {
                pref.setSelectionColor(sel);
            }
        }

        private void doMarker(ProgPreferences pref) {
            Color marker = JColorChooser.showDialog(Main.singleton(), "Tag marker color", pref.tagMarkerColor());
            if (marker != null) {
                pref.setTagMarkerColor(marker);
            }
        }
    }
}

