/*
 * Decompiled with CFR 0.152.
 */
package oroma.picinfogui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mlib.MString;
import mswing.WheelComboBoxDb;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import swing.DatePanel;
import swing.EntryField;
import swing.PanelLabel;
import swing.WheelComboBox;

public class InfoPanelTop
extends JPanel {
    private Fields iFields = null;
    private Prompts iPrompts = null;
    private TreeMap<String, WheelComboBox> iComboBoxes = new TreeMap();
    private static boolean FieldsAdded = false;
    private static InfoPanelTop Singleton = null;
    private static Color CustomBack = new Color(240, 240, 240);

    public static InfoPanelTop singleton() {
        if (Singleton == null) {
            Singleton = new InfoPanelTop();
        }
        return Singleton;
    }

    private InfoPanelTop() {
        this.setBackground(ProgPreferences.singleton().dialogColor());
        this.setLayout(new BorderLayout());
        this.iPrompts = new Prompts();
        this.iFields = new Fields();
        this.add((Component)this.iPrompts, "West");
        this.add((Component)this.iFields, "Center");
    }

    public void clear() {
        this.put(new PicInfo());
    }

    public void fill(PicInfo info) {
        this.iFields.fill(info);
    }

    public void put(PicInfo picInfo) {
        this.iFields.put(picInfo);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.iFields.setEnabled(enabled);
    }

    public String testIfValid() {
        return this.iFields.testIfValid();
    }

    public void updateComboBoxes(Collection<PicInfo> infos) {
        Set<Map.Entry<String, WheelComboBox>> mappings = this.iComboBoxes.entrySet();
        for (Map.Entry<String, WheelComboBox> entry : mappings) {
            WheelComboBox box = entry.getValue();
            box.clear();
        }
        for (PicInfo info : infos) {
            mappings = this.iComboBoxes.entrySet();
            for (Map.Entry<String, WheelComboBox> entry : mappings) {
                PicInfo.ComboField field = info.comboField(entry.getKey());
                if (field == null) continue;
                WheelComboBox box = entry.getValue();
                MString value = field.mValue();
                if (value.equals("")) continue;
                box.addItem(value.toString());
            }
        }
    }

    private class Fields
    extends JPanel {
        private EntryField iNotesField = new EntryField();
        private EntryField iLinkField = new EntryField();
        private DatePanel iDatePanel = new DatePanel(true, false);

        public Fields() {
            this.setLayout(new GridLayout(0, 1));
            ProgPreferences pref = ProgPreferences.singleton();
            for (String fieldName : pref.dispFields()) {
                WheelComboBox box = new WheelComboBox();
                WheelComboBoxDb db = Database.singleton().comboDb(fieldName);
                box.setDb(db, true);
                this.add(box);
                InfoPanelTop.this.iComboBoxes.put(fieldName, box);
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            ProgPreferences pref = ProgPreferences.singleton();
            for (WheelComboBox box : InfoPanelTop.this.iComboBoxes.values()) {
                box.setEnabled(enabled);
                box.setEditable(enabled);
            }
            this.iNotesField.setEnabled(enabled);
            if (enabled) {
                this.iNotesField.setBackground(pref.entryBackColor());
            } else {
                this.iNotesField.setBackground(CustomBack);
            }
            this.iLinkField.setEnabled(enabled);
            if (enabled) {
                this.iLinkField.setBackground(pref.entryBackColor());
            } else {
                this.iLinkField.setBackground(CustomBack);
            }
            this.iDatePanel.setEnabled(enabled);
        }

        public String testIfValid() {
            return this.iDatePanel.testIfValid();
        }

        private void fill(PicInfo info) {
            Set mappings = InfoPanelTop.this.iComboBoxes.entrySet();
            for (Map.Entry entry : mappings) {
                PicInfo.ComboField field = info.comboField((String)entry.getKey());
                if (field == null) continue;
                String value = ((String)((WheelComboBox)entry.getValue()).getSelectedItem()).trim();
                field.setValue(value);
            }
            info.setNotes(this.iNotesField.getText());
            info.setLink(this.iLinkField.getText());
            info.setYear(this.iDatePanel.obtainYear());
            info.setUncer(this.iDatePanel.obtainUncer());
            info.setMonth(this.iDatePanel.obtainMonth());
            info.setDay(this.iDatePanel.obtainDay());
            info.setHour(this.iDatePanel.obtainHour());
        }

        private void put(PicInfo picInfo) {
            if (!FieldsAdded) {
                InfoPanelTop.this.iPrompts.add(new PanelLabel("Date", ':'));
                InfoPanelTop.this.iPrompts.add(new PanelLabel("Notes", ':'));
                InfoPanelTop.this.iPrompts.add(new PanelLabel("Link", ':'));
                InfoPanelTop.this.iFields.add(this.iDatePanel);
                JScrollPane spane = new JScrollPane(this.iNotesField);
                spane.setHorizontalScrollBarPolicy(30);
                InfoPanelTop.this.iFields.add(spane);
                InfoPanelTop.this.iFields.add(this.iLinkField);
                FieldsAdded = true;
            }
            Set mappings = InfoPanelTop.this.iComboBoxes.entrySet();
            for (Map.Entry entry : mappings) {
                PicInfo.ComboField field = picInfo.comboField((String)entry.getKey());
                if (field == null) continue;
                WheelComboBox box = (WheelComboBox)entry.getValue();
                box.removeItem("");
                box.setSelectedItem("");
                String value = field.value().toString();
                if (value == "") {
                    value = " ";
                }
                box.setSelectedItem(field.value().toString());
            }
            this.iNotesField.setText(picInfo.notes());
            this.iLinkField.setText(picInfo.link());
            this.iDatePanel.clear();
            this.iDatePanel.putYear(picInfo.year());
            this.iDatePanel.putUncer(picInfo.uncer());
            this.iDatePanel.putMonth(picInfo.month());
            this.iDatePanel.putDay(picInfo.day());
            this.iDatePanel.putHour(picInfo.hour());
        }
    }

    private class Prompts
    extends JPanel {
        public Prompts() {
            this.setLayout(new GridLayout(0, 1));
            ProgPreferences pref = ProgPreferences.singleton();
            for (String fieldName : pref.dispFields()) {
                MString work = new MString(fieldName);
                work.capFirstChar();
                this.add(new PanelLabel(work.toString(), ':'));
            }
        }
    }
}

