/*
 * Decompiled with CFR 0.152.
 */
package oroma.gui;

import help.HelpWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import oroma.albumgui.AlbumBar;
import oroma.albumgui.AlbumPanel;
import oroma.albumsgui.AlbumsBar;
import oroma.albumsgui.AlbumsPanel;
import oroma.db.Database;

public class MainPanel
extends JPanel {
    private int iDividerPos = 0;
    private JSplitPane jSplitPane = null;
    private boolean iAlbumsDisplayed = true;
    private static MainPanel Singleton = null;

    public static MainPanel singleton() {
        if (Singleton == null) {
            Singleton = new MainPanel();
        }
        return Singleton;
    }

    private MainPanel() {
        this.setLayout(new GridLayout());
        this.add(this.getJSplitPane1());
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        AlbumPanel.singleton().addListener(new AlbumHandler());
        this.iDividerPos = screen.height / 4;
        this.getJSplitPane1().setDividerLocation(this.iDividerPos);
        Singleton = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showAlbumPanel(boolean show) {
        this.iAlbumsDisplayed = show;
        Database database = Database.singleton();
        synchronized (database) {
            this.removeAll();
            if (this.iAlbumsDisplayed) {
                AlbumBar.singleton().enableHelp(false);
                this.jSplitPane = null;
                this.add((Component)this.getJSplitPane1(), "Center");
                if (this.iDividerPos > 0) {
                    this.getJSplitPane1().setDividerLocation(this.iDividerPos);
                }
                AlbumsBar.singleton().fill(true);
                AlbumsPanel.singleton().setup();
            } else {
                this.iDividerPos = this.getJSplitPane1().getDividerLocation();
                AlbumBar.singleton().enableHelp(true);
                this.add((Component)AlbumPanel.singleton(), "Center");
                AlbumsBar.singleton().fill(false);
                AlbumsPanel.singleton().setup();
            }
            MainPanel.enableHelp();
            this.validate();
        }
    }

    public static void enableHelp() {
        boolean enable;
        boolean bl = enable = !HelpWindow.isDisplayed();
        if (MainPanel.Singleton.iAlbumsDisplayed) {
            AlbumsBar.singleton().enableHelp(enable);
            AlbumBar.singleton().enableHelp(false);
        } else {
            AlbumsBar.singleton().enableHelp(false);
            AlbumBar.singleton().enableHelp(enable);
        }
    }

    private JSplitPane getJSplitPane1() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane(0);
            this.getJSplitPane1().add((Component)AlbumsPanel.singleton(), "top");
            this.getJSplitPane1().add((Component)AlbumPanel.singleton(), "bottom");
        }
        return this.jSplitPane;
    }

    private class AlbumHandler
    implements AlbumPanel.Listener {
        private AlbumHandler() {
        }

        @Override
        public void showAlbums(AlbumPanel.Event event) {
            MainPanel.this.iAlbumsDisplayed = !MainPanel.this.iAlbumsDisplayed;
            MainPanel.this.showAlbumPanel(MainPanel.this.iAlbumsDisplayed);
        }
    }
}

