/*
 * Decompiled with CFR 0.152.
 */
package oroma.db;

import files.FileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.TreeMap;
import mlib.MAppMsg;
import oroma.db.Website;
import oroma.gui.BpmMsgs;
import oroma.website.WebImg;
import utilt.Utility;

public class WebDb {
    private File iDir = null;
    private TreeMap<String, Website> iSites = new TreeMap();
    private static final String SITEFILENAME = "site";

    public void create(FileInfo dir) throws Exception {
        if (!dir.isDir()) {
            Utility.throwError("Not a folder: " + dir.path());
        } else if (!dir.exists()) {
            Utility.throwError("Folder not found: " + dir.path());
        } else {
            this.iDir = new File(dir.path());
            this.iDir.mkdir();
        }
    }

    public void open(FileInfo dir) throws Exception {
        if (!dir.isDir()) {
            Utility.throwError("Not a folder: " + dir.path());
        } else if (!dir.exists()) {
            Utility.throwError("Folder not found: " + dir.path());
        } else {
            this.iDir = new File(dir.path());
            try {
                File[] dirs = this.iDir.listFiles();
                int i = 0;
                while (i < dirs.length) {
                    File siteFile = new File(String.valueOf(dirs[i].getAbsolutePath()) + '/' + SITEFILENAME + ".dat");
                    if (siteFile.exists()) {
                        ObjectInputStream in = new ObjectInputStream(new FileInputStream(siteFile));
                        Website asite = (Website)in.readObject();
                        in.close();
                        String name = asite.def().albumName();
                        this.iSites.put(name, asite);
                    }
                    ++i;
                }
            }
            catch (Exception xcp) {
                MAppMsg msg = BpmMsgs.get("unable_read_website");
                Utility.throwError(msg.format(Utility.xcpMsg(xcp)));
            }
        }
    }

    public String path() {
        return this.iDir.getAbsolutePath();
    }

    public synchronized void put(Website site) throws Exception {
        int albumNum = site.def().albumNum();
        File siteDir = new File(String.valueOf(this.iDir.getAbsolutePath()) + '/' + albumNum);
        siteDir.mkdir();
        File siteFile = new File(String.valueOf(siteDir.getAbsolutePath()) + '/' + SITEFILENAME + ".dat");
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(siteFile));
        out.writeObject(site);
        out.close();
        this.iSites.put(site.def().albumName(), site);
    }

    public synchronized Website find(String albumName) {
        return this.iSites.get(albumName);
    }

    public synchronized void clear(String albumName) throws Exception {
        Website site = this.find(albumName);
        if (site != null) {
            site.clear();
            this.put(site);
        }
    }

    public synchronized boolean delete(String albumName) throws Exception {
        Website site = this.find(albumName);
        if (site != null) {
            site.clear();
            int albumNum = site.def().albumNum();
            File siteDir = new File(String.valueOf(this.iDir.getAbsolutePath()) + '/' + albumNum);
            Utility.deleteDir(siteDir.getAbsolutePath());
            this.iSites.remove(albumName);
        }
        return site != null;
    }

    public synchronized boolean rename(String curAlbumName, String newAlbumName) throws Exception {
        Website site = this.find(curAlbumName);
        if (site != null) {
            site.def().setAlbumName(newAlbumName);
            File siteDir = new File(String.valueOf(this.iDir.getAbsolutePath()) + '/' + site.def().albumNum());
            File siteFile = new File(String.valueOf(siteDir.getAbsolutePath()) + '/' + SITEFILENAME + ".dat");
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(siteFile));
            out.writeObject(site);
            out.close();
            this.iSites.remove(curAlbumName);
            this.iSites.put(site.def().albumName(), site);
        }
        return site != null;
    }

    public synchronized void clear() throws Exception {
        File[] dirs = this.iDir.listFiles();
        int i = 0;
        while (i < dirs.length) {
            File[] files = dirs[i].listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    file.delete();
                    ++n2;
                }
            }
            dirs[i].delete();
            ++i;
        }
        this.iSites.clear();
    }

    public synchronized void write() throws Exception {
        for (Website site : this.iSites.values()) {
            this.put(site);
        }
    }

    public synchronized Collection<WebImg> webImgs() throws Exception {
        LinkedList<WebImg> imgs = new LinkedList<WebImg>();
        for (Website site : this.iSites.values()) {
            imgs.addAll(site.webImgs());
        }
        return imgs;
    }

    public synchronized Collection<Website> websites() throws Exception {
        return this.iSites.values();
    }
}

