/*
 * Decompiled with CFR 0.152.
 */
package oroma.db;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import mlib.MAppMsg;
import mlib.MString;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.ProgInstallation;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.db.Website;
import oroma.gui.BpmMsgs;
import oroma.gui.Main;
import oroma.website.WebImg;
import utilt.BinnedDb;
import utilt.Utility;

public class StructureUpdates {
    private static final String FILMFORMATUPDATE = "film format";
    private static final String WHEELPANELS = "wheel panels";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFilmFormatField() throws Exception {
        ProgInstallation install = ProgInstallation.singleton();
        if (!install.updates().contains(FILMFORMATUPDATE)) {
            Database db;
            MAppMsg appMsg = BpmMsgs.get("struct-update");
            Main.singleton().logger().writeln(appMsg.format(FILMFORMATUPDATE, "started"));
            Database database = db = Database.singleton();
            synchronized (database) {
                LinkedList<PicInfo> infos = new LinkedList<PicInfo>();
                Collection<BinnedDb.Binnable> allPics = db.infosDb().retrieveAll();
                for (BinnedDb.Binnable object : allPics) {
                    PicInfo info = (PicInfo)object;
                    infos.add(info);
                }
                StructureUpdates.addPicInfosFilmFormatField(infos);
                infos.clear();
                Collection<BinnedDb.Binnable> allQueries = db.albumsDb().retrieveAll();
                for (BinnedDb.Binnable object : allQueries) {
                    Query query = (Query)object;
                    infos.add(query.picInfo());
                }
                StructureUpdates.addPicInfosFilmFormatField(infos);
                infos.clear();
                Collection<WebImg> webImgs = db.webDb().webImgs();
                for (WebImg img : webImgs) {
                    infos.add(img.picInfo());
                }
                StructureUpdates.addPicInfosFilmFormatField(infos);
                db.infosDb().save(true);
                db.albumsDb().save(true);
                db.webDb().write();
                StructureUpdates.updateInstall(FILMFORMATUPDATE);
            }
        }
    }

    private static int addPicInfosFilmFormatField(Collection<PicInfo> picInfos) throws Exception {
        int count = 0;
        for (PicInfo info : picInfos) {
            PicInfo.ComboField field = info.comboField(FILMFORMATUPDATE);
            if (field != null) continue;
            field = new PicInfo.ComboField(FILMFORMATUPDATE, 12);
            info.addField(field);
            field.setValue("");
            info.resetFieldNames();
            PicInfo.ComboField[] comboFieldArray = PicInfo.comboFieldsByPos();
            int n = comboFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                PicInfo.ComboField aField = comboFieldArray[n2];
                field = info.comboField(aField.name());
                field.setPos(aField.pos());
                ++n2;
            }
            ++count;
        }
        return count;
    }

    private static void updateInstall(String updateName) throws Exception {
        ProgInstallation install = ProgInstallation.singleton();
        install.updates().add(updateName);
        install.write(".bpm", "ief17qtz.ovl");
        MAppMsg appMsg = BpmMsgs.get("struct-update");
        Main.singleton().logger().writeln(appMsg.format(FILMFORMATUPDATE, "completed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeToWheelPanels() throws Exception {
        Database db;
        ProgInstallation install = ProgInstallation.singleton();
        Database database = db = Database.singleton();
        synchronized (database) {
            if (!install.updates().contains(WHEELPANELS)) {
                MAppMsg appMsg = BpmMsgs.get("struct-update");
                Main.singleton().logger().writeln(appMsg.format(WHEELPANELS, "started"));
                Collection<Website> websites = db.webDb().websites();
                LinkedList<String> fieldNames = new LinkedList<String>();
                fieldNames.addAll(ProgPreferences.singleton().dispFields());
                fieldNames.remove("developer");
                fieldNames.add("date");
                fieldNames.add("notes");
                for (Website site : websites) {
                    MString fields = new MString();
                    String annot = site.def().annot();
                    int i = 0;
                    while (i < annot.length()) {
                        String fieldName = null;
                        Iterator iter = fieldNames.iterator();
                        while (iter.hasNext() && fieldName == null) {
                            String name = (String)iter.next();
                            if ((name = Utility.capFirstChar(name)).charAt(0) != annot.charAt(i)) continue;
                            fieldName = Utility.capFirstChar(name);
                            fields.concat(String.valueOf(fieldName) + ',');
                        }
                        ++i;
                    }
                    fields.trimTail(',');
                    site.def().setAnnot(fields.toString());
                }
                db.webDb().write();
                StructureUpdates.updateInstall(WHEELPANELS);
            }
        }
    }

    private StructureUpdates() {
    }
}

