/*
 * Decompiled with CFR 0.152.
 */
package oroma.db;

import files.FileInfo;
import files.Filesystem;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.JProgressBar;
import mlib.MAppMsg;
import mlib.MLogging;
import mlib.MString;
import mlib.MWildcard;
import mswing.ThumbnailImage;
import oroma.albumgui.Thumbnail;
import oroma.albumsgui.AlbumsPanel;
import oroma.albumsgui.DbInfoLabel;
import oroma.db.Database;
import oroma.db.ExifTags;
import oroma.db.PersonGroup;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import oroma.gui.BpmMsgs;
import swing.DatePanel;
import swing.StatusBox;
import utilt.BinnedDb;
import utilt.DoneCounter;
import utilt.ImageIOUtil;
import utilt.Utility;

public class Query
implements Comparable<Query>,
Serializable,
Cloneable,
BinnedDb.Binnable {
    private Integer iObjNum = -1;
    private String iName = "";
    private String iDesc = "";
    private String iExif = "";
    private String iCategory = "*";
    private PicInfo iPicInfo = new PicInfo();
    private PersonGroup iPerson = new PersonGroup();
    private String iOrdering = "By date";
    private String iAspect = "Any";
    private transient ThumbnailImage iThumbnail = null;
    private transient String iExifTagName = null;
    private transient MWildcard iExifTagValue = null;
    private transient boolean iNegateExif = false;
    private transient String iPrevName = "";
    private transient MWildcard[] iTokensToMatch = new MWildcard[PicInfo.COMBOBOXFLDS.length];
    public static final String BYDATE = "By date";
    public static final String BYREGION = "By region";
    public static final String BYNUMPIXELS = "By pixels";
    public static final String BYID = "By id";
    public static final String BYGROUP = "By group";
    public static final String BYPICNUM = "By number";
    public static final String PORTRAIT = "Portrait";
    public static final String LANDSCAPE = "Landscape";
    public static final String SQUARE = "Square";
    public static final String ANYASPECT = "Any";
    public static final String ALLCATEGORYNAME = "*";
    private static final String ANYNOTBLANK = "$";
    private static final char ALLPREFIX = '[';
    private static final char ALLSUFFIX = ']';
    private static final String EXIFIMAGEWIDTH = "Image Width";
    private static final String PHOTOIDPREFIX = "--";
    private static final double ASPECTTOLERANCE = 0.05;
    private static final String QUERYFILENAME = "query.dat";
    private static final char NOWHITESPACE = '_';
    static final long serialVersionUID = 3789858407513089146L;

    public Query() {
        this.iThumbnail = Thumbnail.DefaultThumbnail;
    }

    public Query(Integer objNum) {
        this.iObjNum = objNum;
    }

    @Override
    public void setId(Integer num) {
        this.iObjNum = num;
    }

    @Override
    public Integer id() {
        return this.iObjNum;
    }

    public String aspect() {
        return this.iAspect;
    }

    public void setAspect(String aspect) {
        this.iAspect = aspect;
    }

    public String ordering() {
        return this.iOrdering;
    }

    public void setOrdering(String order) {
        this.iOrdering = order;
    }

    public void resetMatching() {
        int i = 0;
        while (i < this.iTokensToMatch.length) {
            this.iTokensToMatch[i] = null;
            ++i;
        }
    }

    public ThumbnailImage thumb() {
        return this.iThumbnail;
    }

    public void setupThumb(PicInfo firstPhotoInfo) {
        if (firstPhotoInfo == null) {
            this.iThumbnail = Thumbnail.DefaultThumbnail;
        } else {
            try {
                boolean build = this.thumbBuildNeeded(firstPhotoInfo);
                if (build) {
                    BufferedImage image = ImageIOUtil.load(firstPhotoInfo.picPathname());
                    if (image == null) {
                        this.iThumbnail = Thumbnail.DefaultThumbnail;
                        MAppMsg msg = BpmMsgs.get("unable_read_photo");
                        StatusBox.singleton().queueShowMsg(msg.format(firstPhotoInfo.picPathname()), true);
                    } else {
                        this.iThumbnail = new ThumbnailImage();
                        this.iThumbnail.setImagePath(firstPhotoInfo.picPathname());
                        ProgPreferences pref = ProgPreferences.singleton();
                        int thumbSize = pref.albumThumbnailSize();
                        BinnedDb.Path path = Database.singleton().albumsDb().filePath(this.iObjNum, ".jpg");
                        this.iThumbnail.setup(image, thumbSize);
                        this.iThumbnail.write(path.path());
                        Database.singleton().putQuery(this, false);
                        Database.singleton().setSaveNeeded();
                        MAppMsg msg = BpmMsgs.get("built_album_thumbnail");
                        String text = msg.format(this.iName);
                        StatusBox.singleton().queueShowMsg(text, false);
                        this.iPicInfo.setId(firstPhotoInfo.id());
                    }
                }
            }
            catch (Exception xcp) {
                this.iThumbnail = Thumbnail.DefaultThumbnail;
                this.iPicInfo.setId(-1);
                MAppMsg msg = BpmMsgs.get("unable_build_albumthumb");
                String text = msg.format(this.iName);
                StatusBox.singleton().queueShowMsg(text, true);
            }
        }
    }

    public void assign(Query query) {
        this.iObjNum = query.iObjNum;
        this.iName = query.iName;
        this.iDesc = query.iDesc;
        this.iExif = query.iExif;
        this.iCategory = query.iCategory;
        this.iPerson = (PersonGroup)query.iPerson.clone();
        this.iPicInfo.assignFromQuery(query.picInfo());
        this.resetMatching();
    }

    public Collection<PicInfo> buildPicInfos(Collection<String> picPaths) {
        LinkedList<PicInfo> picInfos = new LinkedList<PicInfo>();
        Iterator<String> iter = picPaths.iterator();
        while (iter.hasNext()) {
            PicInfo info = new PicInfo(Database.singleton().infosDb().nextId());
            info.setPicPathname(iter.next());
            info.assignFromQuery(this.iPicInfo);
            info.assignFromBpmExifTag();
            info.setupForAdd();
            picInfos.add(info);
        }
        return picInfos;
    }

    public Object clone() {
        Query clone = null;
        try {
            clone = (Query)super.clone();
            clone.iPicInfo = (PicInfo)this.iPicInfo.clone();
            clone.iPerson = (PersonGroup)this.iPerson.clone();
            clone.iTokensToMatch = new MWildcard[PicInfo.COMBOBOXFLDS.length];
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    @Override
    public int compareTo(Query query) {
        int result = 0;
        if (query != this) {
            result = -1;
            if (query != null) {
                result = this.name().compareToIgnoreCase(query.name());
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        return this.compareTo((Query)obj) == 0;
    }

    public int hashCode() {
        return this.name().toLowerCase().hashCode();
    }

    @Override
    public String name() {
        return this.iName;
    }

    public void setName(String newName) {
        this.iName = newName;
    }

    public PersonGroup personGroup() {
        return this.iPerson;
    }

    public PicInfo picInfo() {
        return this.iPicInfo;
    }

    public String prevName() {
        return this.iPrevName;
    }

    public void setPrevName(String prevName) {
        this.iPrevName = prevName;
    }

    public String category() {
        return this.iCategory;
    }

    public void setCategory(String category) {
        this.iCategory = category;
    }

    public void setPerson(PersonGroup newPerson) {
        this.iPerson = newPerson;
    }

    public String desc() {
        return this.iDesc;
    }

    public void setDesc(String desc) {
        this.iDesc = desc;
    }

    public String exif() {
        return this.iExif;
    }

    public void setExif(String exif) {
        this.iExif = exif;
        this.iExifTagName = null;
    }

    public String toString() {
        return this.iName;
    }

    public void clear() {
        this.iPicInfo.clear();
        this.resetMatching();
        this.setCategory("");
        this.iThumbnail = Thumbnail.DefaultThumbnail;
        this.iPicInfo.setId(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int backup(FileInfo parentDir, JProgressBar bar, MLogging logger) throws Exception {
        int count = 0;
        Filesystem.Local fs = (Filesystem.Local)parentDir.fileSys();
        MString queryDirName = new MString(this.iName).toLowerCase();
        queryDirName = queryDirName.replace(' ', '_');
        FileInfo.Local queryDirInfo = new FileInfo.Local((Filesystem)fs, queryDirName.toString());
        BinnedDb toBinnedDb = null;
        Database database = Database.singleton();
        synchronized (database) {
            if (!((FileInfo)queryDirInfo).exists()) {
                parentDir.fileSys().mkdir(queryDirInfo);
                toBinnedDb = new BinnedDb(queryDirInfo, 11);
            } else {
                toBinnedDb = BinnedDb.open(queryDirInfo, null);
                toBinnedDb.clear();
            }
            String queryFilePath = String.valueOf(((FileInfo)queryDirInfo).path()) + QUERYFILENAME;
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(queryFilePath));
            out.writeObject(this);
            out.close();
            if (bar != null) {
                bar.setValue(0);
            }
            boolean more = true;
            TreeSet<PicInfo> pics = Database.singleton().selectPicInfos(this);
            DoneCounter counter = new DoneCounter(pics.size());
            Iterator iter = pics.iterator();
            while (more && iter.hasNext()) {
                if (Thread.interrupted()) {
                    more = false;
                    continue;
                }
                PicInfo info = (PicInfo)((PicInfo)iter.next()).clone();
                String source = info.picPathname();
                File file = new File(info.picPathname());
                if (!ImageIOUtil.isValidImage(file.getName())) continue;
                info.setId(toBinnedDb.nextId());
                FileInfo.Local fileInfo = new FileInfo.Local(file);
                BinnedDb.Path path = toBinnedDb.filePath(info.id(), fileInfo.extension());
                File from = new File(source);
                File to = new File(path.path());
                Utility.copyFile(from, to);
                info.setOrigPath(source);
                ++count;
                logger.writeln("Backup: " + from.getPath(), false);
                toBinnedDb.put(info, false);
                counter.add(1);
                if (bar == null) continue;
                bar.setValue(counter.percent());
            }
            toBinnedDb.save(true);
        }
        logger.writeln("Backed up " + count + " pictures for album " + this.iName, false);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query restore(FileInfo backupInfo, JProgressBar bar, MLogging logger) throws Exception {
        Database db;
        Query query = null;
        int count = 0;
        Database database = db = Database.singleton();
        synchronized (database) {
            String queryName = backupInfo.name().toLowerCase();
            queryName = queryName.replace('_', ' ');
            File queryFile = new File(String.valueOf(backupInfo.path()) + QUERYFILENAME);
            if (!queryFile.exists()) {
                MAppMsg msg = BpmMsgs.get("album_not_found");
                StatusBox.singleton().queueShowMsg(msg.format(this.name()), false);
            } else {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(queryFile));
                query = (Query)in.readObject();
                in.close();
                if (!query.name().equalsIgnoreCase(queryName)) {
                    MAppMsg msg = BpmMsgs.get("album_not_found");
                    StatusBox.singleton().queueShowMsg(msg.format(queryName), false);
                } else {
                    TreeSet<PicInfo> pics = db.selectPicInfos(query);
                    db.deletePics(pics, true);
                    MAppMsg msg = BpmMsgs.get("deleted_album_photos");
                    logger.writeln(msg.format(queryName));
                    BinnedDb backupDb = BinnedDb.open(backupInfo, null);
                    logger.writeln("Opened " + backupDb.toString(), false);
                    DoneCounter counter = new DoneCounter(backupDb.numObjs());
                    BinnedDb toDb = Database.singleton().infosDb();
                    boolean more = true;
                    Iterator<BinnedDb.Binnable> infos = backupDb.retrieveAll().iterator();
                    while (more && infos.hasNext()) {
                        if (Thread.interrupted()) {
                            more = false;
                            continue;
                        }
                        File destPath = null;
                        try {
                            PicInfo picInfo = (PicInfo)infos.next();
                            int index = picInfo.origPath().lastIndexOf(46);
                            String ext = picInfo.origPath().substring(index);
                            String sourceFileName = picInfo.id() + ext;
                            String sourcePath = String.valueOf(backupDb.binPath(backupDb.bin(picInfo.id()))) + sourceFileName;
                            picInfo.setId(toDb.nextId());
                            destPath = new File(picInfo.origPath());
                            if (destPath.exists()) {
                                Utility.copyFile(new File(sourcePath), destPath);
                            } else {
                                String destFileName = picInfo.id() + ext;
                                destPath = new File(String.valueOf(toDb.binPath(toDb.bin(picInfo.id()))) + destFileName);
                                Utility.copyFile(new File(sourcePath), destPath);
                                picInfo.setPicPathname(destPath.getAbsolutePath());
                            }
                            picInfo.setThumbId(toDb.nextId());
                            picInfo.resetThumb();
                            picInfo.setup();
                            db.putPic(picInfo, false);
                            ++count;
                            counter.add(1);
                            if (bar == null) continue;
                            bar.setValue(counter.percent());
                        }
                        catch (Exception xcp) {
                            msg = BpmMsgs.get("unable_restore_photo");
                            StatusBox.singleton().queueShowMsg(msg.format(destPath.getName()), false);
                        }
                    }
                    if (count > 0) {
                        db.deleteQuery(query.name(), false);
                        db.setSaveNeeded();
                        query.iThumbnail = Thumbnail.DefaultThumbnail;
                        query.setId(db.albumsDb().nextId());
                        db.putQuery(query, false);
                        db.save();
                    }
                    AlbumsPanel.singleton().showAlbums(true);
                    DbInfoLabel.singleton().show();
                    logger.writeln("Restored " + count + " pictures for album " + this.iName, false);
                }
            }
        }
        return query;
    }

    public void initThumb(MLogging logger) throws Exception {
        ThumbnailImage thumb = new ThumbnailImage();
        if (this.iPicInfo.id() != null) {
            try {
                BinnedDb.Path binPath = Database.singleton().albumsDb().filePath(this.id(), ".jpg");
                boolean read = thumb.read(binPath.path());
                if (read) {
                    this.iThumbnail = thumb;
                } else if (logger != null) {
                    this.iThumbnail = Thumbnail.DefaultThumbnail;
                    logger.writeln("Unable to read thumbnail: " + binPath.toString(), true);
                }
            }
            catch (Exception xcp) {
                this.iThumbnail = Thumbnail.DefaultThumbnail;
                MAppMsg msg = BpmMsgs.get("unable_read_albumthumb");
                StatusBox.singleton().showMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
            }
        }
    }

    public boolean matches(PicInfo picInfo) {
        boolean match = false;
        if (this.iName.equalsIgnoreCase("hidden")) {
            match = picInfo.isHidden();
        } else if (!picInfo.isHidden()) {
            match = this.matchesCombos(picInfo);
            if (match) {
                match = this.matchesAspect(picInfo);
            }
            if (match) {
                match = this.matchesDate(picInfo);
            }
            if (match && this.iExif.length() > 0) {
                match = this.matchesExif(picInfo);
            }
        }
        return match;
    }

    private boolean matchesCombos(PicInfo picInfo) {
        MString value;
        PicInfo.ComboField[] infoFields = picInfo.comboFields();
        PicInfo.ComboField[] queryFields = this.iPicInfo.comboFields();
        boolean matches = this.matchesField(PicInfo.MOSTUSEDFIELDNUM, queryFields[PicInfo.MOSTUSEDFIELDNUM].compareValue(), infoFields[PicInfo.MOSTUSEDFIELDNUM].compareValue());
        if (matches) {
            int i = 0;
            while (matches && i < infoFields.length) {
                boolean match = this.matchesField(i, queryFields[i].compareValue(), infoFields[i].compareValue());
                matches &= match;
                ++i;
            }
            if (matches && this.personGroup().getName() != null && this.personGroup().getName().length() > 0) {
                MString work = new MString(this.personGroup().getName());
                work.replace(',', '|');
                MWildcard perWildcard = new MWildcard(work);
                matches = false;
                LinkedList<PersonGroup> persons = picInfo.persons();
                Iterator iter = persons.iterator();
                while (!matches && iter.hasNext()) {
                    PersonGroup person = (PersonGroup)iter.next();
                    matches = perWildcard.matchesAny(person.getName());
                }
            }
        }
        if (!matches && (value = queryFields[PicInfo.IDFIELDNUM].compareValue()).startsWith(PHOTOIDPREFIX)) {
            value.remove(PHOTOIDPREFIX, 1, 0);
            try {
                int id = Integer.parseInt(value.toString());
                matches = id == picInfo.id();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return matches;
    }

    private boolean matchesField(int fieldNum, MString query, MString pic) {
        boolean matches;
        int queryLen = query.length();
        boolean bl = matches = queryLen == 0;
        if (!matches) {
            int picLen = pic.length();
            boolean bl2 = matches = matches && picLen == 0;
            if (!matches) {
                boolean negate = query.startsWith('!');
                if (negate) {
                    query.trimHead('!');
                }
                if (query.equalsIgnoreCase(ANYNOTBLANK)) {
                    boolean bl3 = matches = picLen > 0;
                    if (negate) {
                        matches = !matches;
                    }
                } else {
                    MString work;
                    boolean matchAll = query.startsWith('[') && query.endsWith(']');
                    MWildcard wild = this.iTokensToMatch[fieldNum];
                    if (wild == null) {
                        wild = new MWildcard();
                        work = (MString)query.clone();
                        work.replace(',', '|');
                        if (matchAll) {
                            work.trimHead('[');
                            work.trimTail(']');
                        }
                        this.iTokensToMatch[fieldNum] = wild = new MWildcard(work);
                    }
                    work = (MString)pic.clone();
                    matches = matchAll ? this.iTokensToMatch[fieldNum].matchesAll(work.toString()) : this.iTokensToMatch[fieldNum].matchesAny(work.toString());
                    if (negate) {
                        matches = !matches;
                    }
                }
            }
        }
        return matches;
    }

    private boolean matchesDate(PicInfo picInfo) {
        boolean match = true;
        if (this.iPicInfo.year() != -1) {
            boolean bl = match = picInfo.year() != -1;
            if (match) {
                int picUncer = 0;
                if (picInfo.uncer() != -1) {
                    picUncer = picInfo.uncer();
                }
                int picMinYear = picInfo.year() - picUncer;
                int picMaxYear = picInfo.year() + picUncer;
                int queryUncer = 0;
                if (this.iPicInfo.uncer() != -1) {
                    queryUncer = this.iPicInfo.uncer();
                }
                int queryMinYear = this.iPicInfo.year() - queryUncer;
                int queryMaxYear = this.iPicInfo.year() + queryUncer;
                boolean bl2 = match = queryMaxYear >= picMinYear && queryMinYear <= picMaxYear;
                if (match && this.iPicInfo.month() != -1) {
                    boolean bl3 = match = picInfo.month() != -1 && DatePanel.monthsMatch(picInfo.month(), this.iPicInfo.month());
                    if (match && this.iPicInfo.day() != -1) {
                        match = picInfo.day() != -1 && this.iPicInfo.day() == picInfo.day();
                    }
                }
            }
        }
        return match;
    }

    private boolean matchesExif(PicInfo picInfo) {
        boolean match;
        ExifTags tags = picInfo.exifTags();
        boolean bl = match = tags.count() == 0;
        if (!match) {
            ExifTags.Pair tag;
            if (this.iExifTagName == null) {
                StringTokenizer tken = new StringTokenizer(this.iExif, "=");
                this.iExifTagName = tken.nextToken();
                boolean bl2 = this.iNegateExif = this.iExifTagName.charAt(0) == '!';
                if (this.iNegateExif) {
                    this.iExifTagName = this.iExifTagName.substring(1);
                }
                MString work = new MString(tken.nextToken());
                work.replace(',', '|');
                this.iExifTagValue = new MWildcard(work);
            }
            if ((tag = tags.getTag(this.iExifTagName)) != null) {
                String imgValue = tag.getValue();
                if (this.iExifTagName.equals(EXIFIMAGEWIDTH) || this.iExifTagName.equals(EXIFIMAGEWIDTH)) {
                    int exifValue = Integer.parseInt(this.iExifTagValue.toString());
                    int index = imgValue.indexOf(" ");
                    int picValue = Integer.parseInt(imgValue = imgValue.substring(0, index));
                    match = picValue >= exifValue;
                } else {
                    match = this.iExifTagValue.matchesAll(imgValue);
                }
            }
            if (this.iNegateExif) {
                match = !match;
            }
        }
        return match;
    }

    private boolean matchesAspect(PicInfo picInfo) {
        boolean matches = this.iAspect.equals(ANYASPECT);
        if (!matches) {
            boolean isSquare;
            double aspect = picInfo.getFileInfo().aspectRatio();
            boolean bl = isSquare = aspect >= 0.95 && aspect <= 1.05;
            matches = this.iAspect.equals(SQUARE) ? isSquare : (this.iAspect.equals(PORTRAIT) ? !isSquare && aspect < 1.0 : !isSquare && aspect > 1.0);
        }
        return matches;
    }

    private boolean thumbBuildNeeded(PicInfo firstPhotoInfo) throws Exception {
        boolean build;
        boolean bl = build = this.iThumbnail == null || this.iThumbnail == Thumbnail.DefaultThumbnail || !firstPhotoInfo.id().equals(this.iPicInfo.id());
        if (!build) {
            BinnedDb.Path path = Database.singleton().albumsDb().filePath(this.id(), ".jpg");
            File thumbFile = new File(path.path());
            File picFile = new File(firstPhotoInfo.picPathname());
            boolean bl2 = build = picFile.lastModified() > thumbFile.lastModified() + 5000L;
            if (!build) {
                ProgPreferences curPref = ProgPreferences.singleton();
                int thumbSize = curPref.albumThumbnailSize();
                build = thumbSize != this.iThumbnail.iconSize();
            }
        }
        return build;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.iTokensToMatch = new MWildcard[PicInfo.COMBOBOXFLDS.length];
        if (this.iExif == null) {
            this.iExif = "";
        }
        if (this.iAspect == null) {
            this.iAspect = ANYASPECT;
        }
        if (this.iOrdering.equalsIgnoreCase("by date")) {
            this.iOrdering = BYDATE;
        }
        this.iPrevName = "";
    }

    public static class BinnedCategoryComparer
    implements BinnedDb.Comparer {
        @Override
        public boolean matches(BinnedDb.Binnable obj1, BinnedDb.Binnable obj2) {
            Query query1 = (Query)obj1;
            Query query2 = (Query)obj2;
            boolean matches = query1.category().equals(Query.ALLCATEGORYNAME);
            return matches |= query1.category().equalsIgnoreCase(query2.category());
        }
    }

    public static class BinnedNameComparer
    implements BinnedDb.Comparer {
        @Override
        public boolean matches(BinnedDb.Binnable obj1, BinnedDb.Binnable obj2) {
            Query query1 = (Query)obj1;
            Query query2 = (Query)obj2;
            return query1.name().equalsIgnoreCase(query2.name());
        }
    }

    public static class NameComparator
    implements Comparator<Query> {
        @Override
        public int compare(Query query1, Query query2) {
            int result = -1;
            result = query1.name().compareToIgnoreCase(query2.name());
            return result;
        }
    }
}

