/*
 * Decompiled with CFR 0.152.
 */
package oroma.db;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import minstall.Installation;
import mlib.MAppMsg;
import mswing.Preferences;
import oroma.db.ProgInstallation;
import oroma.gui.BpmMsgs;
import oroma.prefgui.OtherFields;
import utilt.Utility;

public class ProgPreferences
extends Preferences {
    private Color iTagMarkerColor = Color.red;
    private Color iTagBackColor = Color.lightGray;
    private int iTagMarkerSize = 8;
    private int iThumbnailSize = 96;
    private int iAlbumThumbnailSize = 64;
    private String iEditorProg = "";
    private String iAddPicExt = "All";
    private String iLastCat = "*";
    private int iSlideInterval = 10;
    private int iSlideSizePc = 70;
    private int iZoomStepSize = 25;
    private int iLargeAlbumThreshold = 1000;
    private String iWebJpegQual = OtherFields.JPEGOPTIONS[3];
    private String iOtherJpegQual = OtherFields.JPEGOPTIONS[2];
    private int iImageMargin = 5;
    private int iPrintInfoSizePc = 35;
    private boolean iBuiltSampleAlbum = false;
    private String iExtractRename = "No";
    private String iAlbumBarLayout = "Grid";
    private int iExtractMaxSize = 1500;
    private String iWriteExif = "";
    private String iResetFields = "";
    private transient LinkedList<String> iDispFields = new LinkedList();
    public static final int NOIMAGESIZELIMIT = -1;
    public static final String ALL = "all";
    public static final String GRIDLAYOUT = "Grid";
    public static final String FLOWLAYOUT = "Flow";
    private static HashMap<String, Color> ThumbColors = new HashMap();
    private static ProgPreferences Singleton = new ProgPreferences();
    static final long serialVersionUID = 6304382179060138597L;

    static {
        ThumbColors.put(".jpg", Color.white);
        ThumbColors.put(".JPG", Color.white);
        ThumbColors.put(".jpeg", Color.white);
        ThumbColors.put(".JPEG", Color.white);
        ThumbColors.put(".gif", Color.yellow);
        ThumbColors.put(".GIF", Color.yellow);
        ThumbColors.put(".png", Color.orange);
        ThumbColors.put(".PNG", Color.orange);
    }

    public static ProgPreferences singleton() {
        return Singleton;
    }

    public static ProgPreferences read(Installation install) throws Exception {
        ObjectInputStream in = null;
        try {
            try {
                String installDir = install.dir();
                String pathName = String.valueOf(installDir) + File.separator + "pref" + ".dat";
                in = new ObjectInputStream(new FileInputStream(pathName));
                Singleton = (ProgPreferences)in.readObject();
            }
            catch (Exception xcp) {
                MAppMsg msg = BpmMsgs.get("unable_read_prefs");
                System.out.println(msg.format(Utility.xcpMsg(xcp)));
                throw xcp;
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return Singleton;
    }

    public ProgPreferences() {
        this.setPanelBackColor(new Color(204, 204, 204));
        this.iThumbnailSize = this.menuFont().getSize() < 20 ? 64 : 96;
    }

    public void assign(ProgPreferences pref) {
        super.assign(pref);
        this.iTagMarkerColor = pref.iTagMarkerColor;
        this.iTagBackColor = pref.iTagBackColor;
        this.iTagMarkerSize = pref.iTagMarkerSize;
        this.iThumbnailSize = pref.iThumbnailSize;
        this.iAlbumThumbnailSize = pref.iAlbumThumbnailSize;
        this.iEditorProg = pref.iEditorProg;
        this.iAddPicExt = pref.iAddPicExt;
        this.iLastCat = pref.iLastCat;
        this.iSlideInterval = pref.iSlideInterval;
        this.iSlideSizePc = pref.iSlideSizePc;
        this.iZoomStepSize = pref.iZoomStepSize;
        this.iImageMargin = pref.iImageMargin;
        this.iPrintInfoSizePc = pref.iPrintInfoSizePc;
        this.iBuiltSampleAlbum = pref.iBuiltSampleAlbum;
        this.iWebJpegQual = pref.iWebJpegQual;
        this.iOtherJpegQual = pref.iOtherJpegQual;
        this.iLargeAlbumThreshold = pref.iLargeAlbumThreshold;
        this.iWriteExif = pref.iWriteExif;
    }

    public Color tagMarkerColor() {
        return this.iTagMarkerColor;
    }

    public int tagMarkerSize() {
        return this.iTagMarkerSize;
    }

    public int thumbnailSize() {
        return this.iThumbnailSize;
    }

    public int zoomStepSize() {
        return this.iZoomStepSize;
    }

    public String lastCat() {
        return this.iLastCat;
    }

    public void setLastCat(String lastCat) {
        this.iLastCat = lastCat;
    }

    public void setTagMarkerColor(Color color) {
        this.iTagMarkerColor = color;
    }

    public void setTagMarkerSize(int size) {
        this.iTagMarkerSize = size;
    }

    public void setThumbnailSize(int size) {
        this.iThumbnailSize = size;
    }

    public void setZoomStepSize(int size) {
        this.iZoomStepSize = size;
    }

    public Color tagBackColor() {
        return this.iTagBackColor;
    }

    public void setTagBackColor(Color color) {
        this.iTagBackColor = color;
    }

    public int imageMargin() {
        return this.iImageMargin;
    }

    public void setImageMargin(int margin) {
        this.iImageMargin = margin;
    }

    public String editorProg() {
        return this.iEditorProg;
    }

    public void setEditorProg(String prog) {
        this.iEditorProg = prog;
    }

    public int slideInterval() {
        return this.iSlideInterval;
    }

    public void setSlideInterval(int interval) {
        this.iSlideInterval = interval;
    }

    public boolean isBuiltSampleAlbum() {
        return this.iBuiltSampleAlbum;
    }

    public void setBuiltSampleAlbum(boolean built) {
        this.iBuiltSampleAlbum = built;
    }

    public int slideSizePc() {
        return this.iSlideSizePc;
    }

    public void setSlideSizePc(int sizePc) {
        this.iSlideSizePc = sizePc;
    }

    public int albumThumbnailSize() {
        return this.iAlbumThumbnailSize;
    }

    public void setAlbumThumbnailSize(int size) {
        this.iAlbumThumbnailSize = size;
    }

    public String addPicExt() {
        return this.iAddPicExt;
    }

    public void setAddPicExt(String ext) {
        this.iAddPicExt = ext;
    }

    public int printInfoSizePc() {
        return this.iPrintInfoSizePc;
    }

    public void setPrintInfoSizePc(int pc) {
        this.iPrintInfoSizePc = pc;
    }

    public String webJpegQual() {
        return this.iWebJpegQual;
    }

    public void setWebJpegQual(String qual) {
        this.iWebJpegQual = qual;
    }

    public String otherJpegQual() {
        return this.iOtherJpegQual;
    }

    public void setOtherJpegQual(String qual) {
        this.iOtherJpegQual = qual;
    }

    public int largeAlbumThreshold() {
        return this.iLargeAlbumThreshold;
    }

    public void setLargeAlbumThreshold(int threshold) {
        this.iLargeAlbumThreshold = threshold;
    }

    public String extractRename() {
        return this.iExtractRename;
    }

    public void setExtractRename(String rename) {
        this.iExtractRename = rename;
    }

    public int extractMaxSize() {
        return this.iExtractMaxSize;
    }

    public void setExtractMaxSize(int maxSize) {
        this.iExtractMaxSize = maxSize;
    }

    public LinkedList<String> dispFields() {
        return this.iDispFields;
    }

    public String albumBarLayout() {
        return this.iAlbumBarLayout;
    }

    public void setAlbumBarLayout(String layout) {
        this.iAlbumBarLayout = layout;
    }

    public String writeExif() {
        return this.iWriteExif;
    }

    public void setWriteExif(String writeExif) {
        this.iWriteExif = writeExif;
    }

    public String resetFields() {
        return this.iResetFields;
    }

    public void setResetFields(String resetFields) {
        this.iResetFields = resetFields;
    }

    public void write(ProgInstallation install, boolean create) throws IOException {
        String pathName = String.valueOf(install.dir()) + "pref" + ".dat";
        File file = new File(pathName);
        if (file.exists() || create) {
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(new FileOutputStream(file));
                out.writeObject(Singleton);
                out.close();
            }
            catch (IOException xcp) {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException xcp1) {
                    throw xcp;
                }
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.iDispFields == null) {
            this.iDispFields = new LinkedList();
        }
    }
}

