/*
 * Decompiled with CFR 0.152.
 */
package oroma.db;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.Serializable;

public class ImageFileInfo
implements Serializable,
Cloneable {
    private int iSizeKb = -1;
    private short iNumRows = (short)-1;
    private short iNumCols = (short)-1;
    private short iNumComps = (short)-1;
    private short iBitsPerPixel = (short)-1;
    private boolean iIsJpeg = false;
    private static final byte SOIMARKER = -40;
    private static final byte SOFMARKER = -64;
    public static final short UNKNOWN = -1;
    static final long serialVersionUID = -1223665778734299750L;

    private static byte findNextMarker(DataInputStream in) throws IOException {
        while (in.readByte() != -1) {
        }
        return in.readByte();
    }

    public Object clone() {
        ImageFileInfo copy = null;
        try {
            copy = (ImageFileInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }

    public short getBitsPerPixel() {
        return this.iBitsPerPixel;
    }

    public short getNumCols() {
        return this.iNumCols;
    }

    public short getNumComps() {
        return this.iNumComps;
    }

    public short getNumRows() {
        return this.iNumRows;
    }

    public int numPixels() {
        int num = this.iNumRows;
        return num *= this.iNumCols;
    }

    public double aspectRatio() {
        return (double)this.getNumCols() / (double)this.getNumRows();
    }

    public int getSizeKB() {
        return this.iSizeKb;
    }

    public boolean isJpeg() {
        return this.iIsJpeg;
    }

    public void readJpegHeader(File file) throws IOException {
        try (FilterInputStream in = null;){
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            byte marker = 0;
            while ((marker = ImageFileInfo.findNextMarker((DataInputStream)in)) != -40) {
            }
            while ((marker = ImageFileInfo.findNextMarker((DataInputStream)in)) != -64) {
                char length = ((DataInputStream)in).readChar();
                int bytesToSkip = length - 2;
                while (bytesToSkip > 0) {
                    ((DataInputStream)in).readByte();
                    --bytesToSkip;
                }
            }
            ((DataInputStream)in).readByte();
            ((DataInputStream)in).readByte();
            this.iBitsPerPixel = ((DataInputStream)in).readByte();
            this.iNumRows = (short)((DataInputStream)in).readChar();
            this.iNumCols = (short)((DataInputStream)in).readChar();
            this.iNumComps = ((DataInputStream)in).readByte();
        }
    }

    public void setIsJpeg(boolean newIsJpeg) {
        this.iIsJpeg = newIsJpeg;
    }

    public void setNumCols(short numCols) {
        this.iNumCols = numCols;
    }

    public void setNumRows(short numRows) {
        this.iNumRows = numRows;
    }

    public void setSizeKB(int newSizeKb) {
        this.iSizeKb = newSizeKb;
    }
}

