/*
 * Decompiled with CFR 0.152.
 */
package oroma.db;

import files.FileInfo;
import files.Filesystem;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import mlib.MAppMsg;
import mlib.MLogger;
import mlib.MLogging;
import mlib.MString;
import mswing.WheelComboBoxDb;
import oroma.db.BpmExifTag;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.db.WebDb;
import oroma.gui.BpmMsgs;
import utilt.BinnedDb;
import utilt.Utility;

public class Database
implements Serializable {
    private BinnedDb iInfosDb = null;
    private BinnedDb iAlbumsDb = null;
    private transient Parms iParms = null;
    private transient boolean iSaveNeeded = false;
    private transient MLogging iLogger = new MLogger.Empty();
    private transient WebDb iWebDb = new WebDb();
    private transient FileInfo iPics = null;
    private transient LinkedList<Listener> iLis = new LinkedList();
    private transient TreeMap<String, WheelComboBoxDb> iComboDbs = new TreeMap();
    public static final String DATAFILEEXT = ".dat";
    public static final String BGNDSDIR = "bgnds";
    public static final String ALBUMSELECTDBNAME = "album";
    public static final String CATEGORYDBNAME = "category";
    public static final String ORPHAN = "Orphan";
    public static final String ORPHANS = "Orphans";
    public static final int ORPHANID = 9999;
    public static final String ARCHIVE = "$";
    private static final int MAXCOMBOITEMS = 50;
    private static final int NUMPICBINS = 15;
    private static final int NUMALBUMBINS = 5;
    private static final String ALBUMSDBDIR = "albumsdb";
    private static final String INFOSDBDIR = "infosdb";
    private static final String WEBSITESDIR = "websites";
    private static final String COMBODBEXT = ".cdb";
    private static final String MSGPREFIX = "Db: ";
    private static final String SELECTIONDBSDIR = "selections";
    private static Database Singleton = null;

    public static Database singleton() {
        return Singleton;
    }

    public static void create(Parms parms, MLogging logger) throws Exception {
        if (!parms.bpmPath().isDir()) {
            Utility.throwError("Not a folder: " + parms.bpmPath().path());
        }
        Singleton = new Database(logger);
        Database.Singleton.iParms = parms;
        Singleton.setupCreate();
        Database.Singleton.iLogger.writeln("Db: Created " + Singleton.toString(), false);
    }

    public static Database open(Parms parms, boolean makeSingleton, MLogging logger) throws Exception {
        if (!parms.bpmPath().isDir()) {
            Utility.throwError("Not a folder: " + parms.bpmPath().path());
        }
        Database db = new Database(logger);
        db.iParms = parms;
        if (makeSingleton) {
            Singleton = db;
        }
        db.doOpen(parms);
        db.iLogger.writeln("Db: Opened " + Singleton.toString(), false);
        return db;
    }

    public static boolean exists(FileInfo.Local dir) throws Exception {
        Filesystem.Local fs = new Filesystem.Local(dir, true);
        FileInfo.Local infosdb = new FileInfo.Local((Filesystem)fs, INFOSDBDIR);
        boolean exists = infosdb.exists();
        FileInfo.Local albumsdb = new FileInfo.Local((Filesystem)fs, ALBUMSDBDIR);
        exists |= albumsdb.exists();
        FileInfo.Local websites = new FileInfo.Local((Filesystem)fs, WEBSITESDIR);
        return exists |= websites.exists();
    }

    public BinnedDb infosDb() {
        return this.iInfosDb;
    }

    public BinnedDb albumsDb() {
        return this.iAlbumsDb;
    }

    public WebDb webDb() {
        return this.iWebDb;
    }

    public Parms parms() {
        return this.iParms;
    }

    public FileInfo picsDir() {
        return this.iPics;
    }

    public FileInfo selectionDbsDir() throws Exception {
        Filesystem.Local fs = new Filesystem.Local(this.iParms.bpmPath(), false);
        FileInfo.Local dir = new FileInfo.Local((Filesystem)fs, SELECTIONDBSDIR);
        return dir;
    }

    public void setSaveNeeded() {
        this.iSaveNeeded = true;
    }

    public WheelComboBoxDb comboDb(String name) {
        return this.iComboDbs.get(name);
    }

    public Collection<String> comboDbNames() {
        return this.iComboDbs.keySet();
    }

    public synchronized void save() throws Exception {
        Collection<BinnedDb.Binnable> infos;
        if (this.iParms != null && this.iParms.picsPath() != null && (infos = this.infosDb().retrieveAll()).size() > 0) {
            for (PicInfo picInfo : infos) {
                String pathName = picInfo.picPathname();
                pathName = pathName.replace(this.iParms.picsPath().path(), this.iParms.origPicRoot());
                picInfo.setPicPathname(pathName);
            }
            this.iLogger.writeln("Db: Restored to photo root " + this.iParms.origPicRoot(), false);
        }
        this.iInfosDb.save(false);
        this.iAlbumsDb.save(false);
        this.saveComboBoxDbs();
        Database.Singleton.iLogger.writeln("Db: Saved " + Singleton.toString(), false);
    }

    public synchronized void close() throws Exception {
        this.iInfosDb.close();
        this.iAlbumsDb.close();
        this.saveComboBoxDbs();
        Database.Singleton.iLogger.writeln("Db: Closed " + Singleton.toString(), false);
    }

    public synchronized int numQueries() {
        return this.iAlbumsDb.numObjs();
    }

    public synchronized int numPics() {
        return this.iInfosDb.numObjs();
    }

    public synchronized Integer nextObjNum() {
        return this.iInfosDb.nextId();
    }

    public synchronized boolean putQuery(Query album, boolean save) throws Exception {
        boolean added = this.iAlbumsDb.put(album, save);
        if (added) {
            this.fireQueryAdded(album.name());
        }
        this.iLogger.writeln("Db: Put query " + album.name(), false);
        return added;
    }

    public synchronized Query query(String name, boolean mustExist) throws Exception {
        Query query = new Query();
        query.setName(name);
        LinkedList<BinnedDb.Binnable> result = this.iAlbumsDb.find(query, new Query.BinnedNameComparer());
        if (result.size() == 0) {
            query = null;
            if (mustExist) {
                MAppMsg msg = BpmMsgs.get("album_not_found");
                Utility.throwError(msg.format(name));
            }
        } else {
            query = (Query)result.getFirst();
        }
        return query;
    }

    public synchronized void deleteQuery(int objNum, boolean save) throws Exception {
        Query query = (Query)this.iAlbumsDb.obj(objNum);
        if (query != null) {
            boolean result = this.iAlbumsDb.remove(objNum, save);
            if (result) {
                this.iLogger.writeln("Db: Deleted query " + query.name(), false);
            } else {
                this.iLogger.writeln("Db: Object id " + objNum + " not found in InfosDb", true);
            }
            this.fireQueryDeleted(query.name());
        } else if (objNum != 9999) {
            MAppMsg msg = BpmMsgs.get("unable_delete_album");
            String text = msg.format(ORPHAN);
            Utility.throwError(text);
        }
    }

    public synchronized void deleteQuery(String name, boolean save) throws Exception {
        Query query = this.query(name, false);
        if (query != null) {
            this.deleteQuery(query.id(), save);
        }
    }

    public synchronized TreeSet<Query> queriesByCat(String catName) {
        Query query = new Query();
        query.setCategory(catName);
        LinkedList<BinnedDb.Binnable> found = this.iAlbumsDb.find(query, new Query.BinnedCategoryComparer());
        TreeSet<Query> queries = new TreeSet<Query>(new Query.NameComparator());
        for (BinnedDb.Binnable binnable : found) {
            queries.add((Query)binnable);
        }
        return queries;
    }

    public synchronized TreeSet<PicInfo> selectPicInfos(Query query) {
        TreeSet<PicInfo> picInfos = null;
        String order = query.ordering();
        picInfos = order.equals("By date") ? new TreeSet<PicInfo>(new PicInfo.DateComparator()) : (order.equals("By region") ? new TreeSet<PicInfo>(new PicInfo.RegionComparator()) : (order.equals("By id") ? new TreeSet<PicInfo>(new PicInfo.IdComparator()) : (order.equals("By group") ? new TreeSet<PicInfo>(new PicInfo.GroupComparator()) : (order.equals("By pixels") ? new TreeSet<PicInfo>(new PicInfo.NumPixComparator()) : new TreeSet<PicInfo>(new PicInfo.PicNumComparator())))));
        Collection<BinnedDb.Binnable> infos = this.iInfosDb.retrieveAll();
        for (BinnedDb.Binnable obj : infos) {
            PicInfo info = (PicInfo)obj;
            if (!query.matches(info)) continue;
            picInfos.add(info);
        }
        return picInfos;
    }

    public synchronized TreeMap<String, PicInfo> picInfosByPathname() {
        Collection<BinnedDb.Binnable> infos = this.iInfosDb.retrieveAll();
        TreeMap<String, PicInfo> byPath = new TreeMap<String, PicInfo>();
        for (BinnedDb.Binnable obj : infos) {
            PicInfo info = (PicInfo)obj;
            byPath.put(info.picPathname(), info);
        }
        return byPath;
    }

    public synchronized void putPic(PicInfo picInfo, boolean save) throws Exception {
        picInfo.setUpdateDate(new GregorianCalendar());
        this.iInfosDb.put(picInfo, save);
        this.firePicAdded(picInfo);
        this.iSaveNeeded = true;
        this.iLogger.writeln("Db: Put photo " + picInfo.picPathname(), false);
        ProgPreferences pref = ProgPreferences.singleton();
        String writeExif = pref.writeExif();
        if (writeExif.equals("Yes")) {
            try {
                BpmExifTag tag = new BpmExifTag(picInfo, false);
                tag.write(this.iLogger);
                MAppMsg msg = BpmMsgs.get("wrote_exif");
                this.iLogger.writeln(MSGPREFIX + msg.format(picInfo.picPathname()), true);
            }
            catch (Exception xcp) {
                MAppMsg msg = BpmMsgs.get("unable_write_exif");
                this.iLogger.writeln(MSGPREFIX + msg.format(picInfo.picPathname()), true);
            }
        } else {
            picInfo.setNeedsExifUpdate();
        }
    }

    public synchronized void deletePic(PicInfo info, boolean save) throws Exception {
        this.iInfosDb.remove(info, save);
        if (info.thumbObjNum() != -1) {
            BinnedDb.Path path = this.iInfosDb.filePath(info.thumbObjNum(), ".jpg");
            File file = new File(path.path());
            file.delete();
        }
        this.firePicDeleted(info);
        this.iSaveNeeded = !save;
        this.iLogger.writeln("Db: Deleted photo " + info.picPathname(), false);
    }

    public synchronized void deletePics(Collection<PicInfo> picInfos, boolean save) throws Exception {
        for (PicInfo info : picInfos) {
            this.deletePic(info, false);
        }
        if (save) {
            this.iInfosDb.save(false);
        }
    }

    public synchronized Collection<PicInfo> findOrphanPics() {
        TreeMap<Integer, PicInfo> orphans = new TreeMap<Integer, PicInfo>();
        Collection<PicInfo> allPics = this.picInfosByPathname().values();
        for (PicInfo info : allPics) {
            MString topic = info.comboField("topic").compareValue();
            if (topic != null && topic.equals(ORPHAN)) {
                info.comboField("topic").clear();
            }
            if (info.isHidden()) continue;
            orphans.put(info.id(), info);
        }
        TreeSet<Query> queries = this.queriesByCat("*");
        for (Query query : queries) {
            for (PicInfo picInfo : this.selectPicInfos(query)) {
                orphans.remove(picInfo.id());
            }
        }
        this.iLogger.writeln("Db: Found " + orphans.size() + " orphans", false);
        return orphans.values();
    }

    public synchronized void checkCategories(Collection<String> catNames) {
        TreeSet<Query> queries = this.queriesByCat("*");
        for (Query query : queries) {
            if (catNames.contains(query.category())) continue;
            query.setCategory("*");
        }
    }

    public synchronized void addListener(Listener lis) {
        boolean exists = lis == null;
        Iterator iter = this.iLis.iterator();
        while (!exists && iter.hasNext()) {
            boolean bl = exists = iter.next() == lis;
        }
        if (!exists) {
            this.iLis.add(lis);
        }
    }

    public synchronized void shutdown() {
        try {
            try {
                this.iLogger.writeln("Db: Shutting down...", false);
                this.saveComboBoxDbs();
                if (this.iSaveNeeded) {
                    this.save();
                }
            }
            catch (Exception xcp) {
                this.iLogger.writeln(MSGPREFIX + xcp.toString(), true);
                try {
                    this.iLogger.writeln("Db: Shutdown", false);
                }
                catch (Exception xcp2) {
                    this.iLogger.writeln(MSGPREFIX + xcp2.toString(), true);
                }
            }
        }
        finally {
            try {
                this.iLogger.writeln("Db: Shutdown", false);
            }
            catch (Exception xcp) {
                this.iLogger.writeln(MSGPREFIX + xcp.toString(), true);
            }
        }
    }

    public synchronized void clear() throws Exception {
        this.iInfosDb.clear();
        this.iAlbumsDb.clear();
    }

    public String toString() {
        String str = String.valueOf(this.iParms.bpmPath().path()) + ", " + this.iInfosDb.numObjs() + " photos, " + this.iAlbumsDb.numObjs() + " albums";
        return str;
    }

    private Database() {
    }

    private Database(MLogging logger) {
        this.iLogger = logger;
    }

    private void setupCreate() throws Exception {
        Filesystem.Local fs = new Filesystem.Local(this.iParms.bpmPath(), true);
        FileInfo.Local dir = new FileInfo.Local((Filesystem)fs, INFOSDBDIR);
        if (dir.exists()) {
            Utility.deleteDir(dir.path());
        }
        fs.mkdir(dir);
        this.iInfosDb = new BinnedDb(dir, 15);
        this.iInfosDb.save(true);
        dir = new FileInfo.Local((Filesystem)fs, ALBUMSDBDIR);
        if (dir.exists()) {
            Utility.deleteDir(dir.path());
        }
        fs.mkdir(dir);
        this.iAlbumsDb = new BinnedDb(dir, 5);
        this.iAlbumsDb.save(true);
        dir = new FileInfo.Local((Filesystem)fs, SELECTIONDBSDIR);
        if (dir.exists()) {
            Utility.deleteDir(dir.path());
        }
        fs.mkdir(dir);
        dir = new FileInfo.Local((Filesystem)fs, WEBSITESDIR);
        if (dir.exists()) {
            Utility.deleteDir(dir.path());
        }
        fs.mkdir(dir);
        this.readComboBoxDbs();
    }

    private void doOpen(Parms parms) throws Exception {
        this.iParms = parms;
        Filesystem.Local fs = new Filesystem.Local(this.iParms.bpmPath(), false);
        FileInfo.Local dir = new FileInfo.Local((Filesystem)fs, INFOSDBDIR);
        this.iInfosDb = BinnedDb.open(dir, this.iLogger);
        dir = new FileInfo.Local((Filesystem)fs, ALBUMSDBDIR);
        this.iAlbumsDb = BinnedDb.open(dir, this.iLogger);
        Collection<BinnedDb.Binnable> allPics = this.iInfosDb.retrieveAll();
        Collection<BinnedDb.Binnable> allQueries = this.iAlbumsDb.retrieveAll();
        for (BinnedDb.Binnable binnable : allQueries) {
            Query query = (Query)binnable;
            query.initThumb(this.iLogger);
        }
        this.readComboBoxDbs();
        dir = new FileInfo.Local((Filesystem)fs, WEBSITESDIR);
        this.iWebDb.open(dir);
        if (parms.picsPath() != null) {
            MString toReplace = new MString();
            if (allPics.size() > 0) {
                for (PicInfo picInfo : allPics) {
                    MString pathName = new MString(picInfo.origPath());
                    if (toReplace.length() == 0) {
                        MString temp = (MString)pathName.clone();
                        LinkedList<MString> tokens = temp.tokenize("/\\", false);
                        Iterator iter1 = tokens.iterator();
                        toReplace.concat((MString)iter1.next());
                        toReplace.concat('/');
                        toReplace.concat((MString)iter1.next());
                    }
                    parms.setOrigPicRoot(String.valueOf(toReplace.toString()) + '/');
                    String picsPath = parms.picsPath().pathNoTerm();
                    picsPath = picsPath.replace('\\', '/');
                    pathName.replace(toReplace.toString(), picsPath);
                    picInfo.setPicPathname(pathName.toString());
                }
                this.iLogger.writeln("Db: Changed to external " + parms.bpmPath().path(), false);
            }
        }
    }

    private void readComboBoxDb(String name) throws Exception {
        String pathName = name.replace(' ', '-');
        String path = String.valueOf(this.selectionDbsDir().path()) + pathName + COMBODBEXT;
        WheelComboBoxDb db = null;
        try {
            db = WheelComboBoxDb.read(path);
        }
        catch (Exception xcp) {
            db = new WheelComboBoxDb(path, 50);
            db.setPath(path);
            this.iLogger.writeln("Db: Recreated empty ComboBoxDb " + name, false);
        }
        this.iComboDbs.put(name, db);
    }

    private void readComboBoxDbs() throws Exception {
        String[] stringArray = PicInfo.COMBOBOXFLDS;
        int n = PicInfo.COMBOBOXFLDS.length;
        int n2 = 0;
        while (n2 < n) {
            String fldName = stringArray[n2];
            this.readComboBoxDb(fldName);
            ++n2;
        }
        this.readComboBoxDb("persons");
        this.readComboBoxDb(ALBUMSELECTDBNAME);
        this.readComboBoxDb(CATEGORYDBNAME);
    }

    private void saveComboBoxDbs() throws Exception {
        Collection<WheelComboBoxDb> dbs = this.iComboDbs.values();
        for (WheelComboBoxDb db : dbs) {
            db.save();
        }
    }

    private void fireQueryAdded(String name) {
        Event event = new Event(this);
        event.setParm(name);
        for (Listener lis : this.iLis) {
            lis.queryAdded(event);
        }
    }

    private void fireQueryDeleted(String name) {
        Event event = new Event(this);
        event.setParm(name);
        for (Listener lis : this.iLis) {
            lis.queryDeleted(event);
        }
    }

    private void firePicDeleted(PicInfo info) {
        Event event = new Event(this);
        event.setParm(info.picPathname());
        for (Listener lis : this.iLis) {
            lis.picDeleted(event);
        }
    }

    private void firePicAdded(PicInfo info) {
        Event event = new Event(this);
        event.setParm(info.picPathname());
        for (Listener lis : this.iLis) {
            lis.picAdded(event);
        }
    }

    private static class AlbumComparator
    implements Comparator<String>,
    Serializable {
        static final long serialVersionUID = -5214407800339398553L;

        private AlbumComparator() {
        }

        @Override
        public int compare(String obj1, String obj2) {
            int result = -1;
            result = obj1.compareToIgnoreCase(obj2);
            return result;
        }
    }

    public static class Event
    extends EventObject {
        private String iParm = "";

        public Event(Object source) {
            super(source);
        }

        public String getParm() {
            return this.iParm;
        }

        public void setParm(String parm) {
            this.iParm = parm;
        }
    }

    public static interface Listener
    extends EventListener {
        public void queryAdded(Event var1);

        public void queryDeleted(Event var1);

        public void picAdded(Event var1);

        public void picDeleted(Event var1);
    }

    public static class Parms {
        private FileInfo.Local iBpmPath = null;
        private FileInfo.Local iPicsPath = null;
        private String iOrigPicRoot = null;

        public Parms(FileInfo.Local bpmPath, FileInfo.Local picsPath) throws Exception {
            this.iBpmPath = bpmPath;
            this.iPicsPath = picsPath;
        }

        public FileInfo.Local bpmPath() {
            return this.iBpmPath;
        }

        public FileInfo.Local picsPath() {
            return this.iPicsPath;
        }

        public String origPicRoot() {
            return this.iOrigPicRoot;
        }

        public void setOrigPicRoot(String root) {
            this.iOrigPicRoot = root;
        }

        public String toString() {
            String str = this.iBpmPath.path();
            if (this.iPicsPath != null) {
                str = String.valueOf(str) + ", " + this.iPicsPath.path();
            }
            return str;
        }
    }
}

