/*
 * Decompiled with CFR 0.152.
 */
package oroma.db;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import mlib.MLogging;
import mlib.MString;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import oroma.db.ExifTags;
import oroma.db.PersonGroup;
import oroma.db.PicInfo;
import oroma.db.PicTag;
import utilt.Utility;

public class BpmExifTag {
    private PicInfo iInfo = null;
    private MString iTag = new MString();
    private static final String SEP = " ";
    public static final String TEMPJPG = "temp.jpg";

    public BpmExifTag(PicInfo info, boolean includePicPath) {
        this.iInfo = info;
        this.iTag.concat(String.valueOf(Long.toString(this.iInfo.id().intValue())) + SEP);
        this.iTag.concat("<picture> ");
        if (includePicPath) {
            this.addText("imagepath", info.picPathname());
        }
        PicInfo.ComboField[] fields = info.comboFields();
        int i = 0;
        while (i < PicInfo.COMBOBOXFLDS.length) {
            String xml = fields[i].asXML();
            if (xml != null) {
                this.iTag.concat(String.valueOf(xml) + SEP);
            }
            ++i;
        }
        this.addInt("year", this.iInfo.year());
        this.addInt("month", this.iInfo.month());
        this.addInt("day", this.iInfo.day());
        this.addInt("uncer", this.iInfo.uncer());
        this.addText("notes", this.iInfo.notes());
        MString text = new MString();
        for (PersonGroup pg : this.iInfo.persons()) {
            String name = pg.getName();
            if (name.length() <= 0) continue;
            text.concat(String.valueOf(name) + "," + SEP);
        }
        this.addText("persons", text.toString());
        if (this.iInfo.tags().size() > 0) {
            text.clear();
            for (PicTag tag : this.iInfo.tags()) {
                text.concat(String.valueOf(tag.getText()) + "," + SEP);
            }
            this.addText("tags", text.toString());
        }
        this.iTag.concat("</picture>");
        ExifTags.Pair pair = new ExifTags.Pair("Unknown tag (0x84e0)", this.iTag.toString());
        this.iInfo.exifTags().addTag(pair);
    }

    public BpmExifTag(PicInfo info, ExifTags.Pair existing) {
        this.iInfo = info;
        String tag = existing.getValue();
        int index = tag.indexOf("<");
        tag = tag.substring(index);
        tag = String.valueOf(Long.toString(info.id().intValue())) + SEP + tag;
        this.iTag = new MString(tag);
    }

    public MString getElement(String name) throws Exception {
        MString element = new MString();
        int index = this.iTag.indexOf(String.valueOf(name) + ">");
        if (index < 0) {
            element = null;
        } else {
            index += name.length() + 1;
            while (index < this.iTag.length()) {
                char next = this.iTag.charAt(index);
                if (next == '<') {
                    index = this.iTag.length();
                } else {
                    element.concat(next);
                }
                ++index;
            }
            element.trimWhitespace();
        }
        return element;
    }

    public boolean write(MLogging logger) throws Exception {
        File file = new File(this.iInfo.picPathname());
        boolean write = this.iInfo.exifTags().count() > 0;
        boolean fsaowi = this.iInfo.comboField("topic").compareValue().equalsIgnoreCase("FSA-OWI");
        if (write &= !fsaowi) {
            write = false;
            ImageMetadata metadata = Imaging.getMetadata((File)file);
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            if (jpegMetadata == null) {
                Utility.throwError("Unable to write exif: " + this.iInfo.picPathname(), null, logger);
            } else {
                TiffImageMetadata exif = jpegMetadata.getExif();
                if (exif != null) {
                    TiffOutputSet outputSet = exif.getOutputSet();
                    if (outputSet == null) {
                        outputSet = new TiffOutputSet();
                    }
                    TiffOutputDirectory exifDirectory = outputSet.getRootDirectory();
                    exifDirectory.removeField((TagInfo)ExifTagConstants.EXIF_TAG_SITE);
                    exifDirectory.add(ExifTagConstants.EXIF_TAG_SITE, new String[]{this.iTag.toString()});
                    ExifRewriter writer = new ExifRewriter();
                    FileOutputStream out = new FileOutputStream(TEMPJPG);
                    writer.updateExifMetadataLossless(file, (OutputStream)out, outputSet);
                    out.close();
                    Utility.copyFile(TEMPJPG, this.iInfo.picPathname());
                    write = true;
                }
            }
        }
        return write;
    }

    private void addText(String name, String value) {
        if (value != null) {
            MString str = new MString(value);
            str.removeWhitespace();
            if (str.length() > 0) {
                String ele = "<" + name + "> " + value + " </" + name + ">" + SEP;
                this.iTag.concat(ele);
            }
        }
    }

    private void addInt(String name, int value) {
        String str = "";
        if (value != -1) {
            str = Integer.toString(value);
        }
        this.addText(name, str);
    }
}

