/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumsgui;

import dialog.DialogEvent;
import files.FileInfo;
import files.Filesystem;
import java.awt.Frame;
import mlib.MAppMsg;
import oroma.albumsgui.QueryThreadDialog;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import oroma.gui.Main;
import swing.StatusBox;
import utilt.Utility;

public class RestoreDialog
extends QueryThreadDialog {
    private static volatile Restorer TheRestore = null;

    public static boolean inProgress() {
        return TheRestore != null;
    }

    public RestoreDialog(Frame owner, Query query, String dirPath) {
        super(owner, query, dirPath);
        TheRestore = new Restorer();
        TheRestore.setName("Restorer");
        TheRestore.start();
    }

    @Override
    public void cancel(DialogEvent event) {
        if (TheRestore != null) {
            TheRestore.interrupt();
        }
        this.dispose();
    }

    private class Restorer
    extends Thread {
        private Restorer() {
        }

        @Override
        public void run() {
            try {
                MAppMsg msg = BpmMsgs.get("restoring_album");
                StatusBox.singleton().queueShowMsg(msg.format(RestoreDialog.this.query().name()), false);
                Filesystem.Local fs = new Filesystem.Local(RestoreDialog.this.dirPath(), true);
                FileInfo.Local backupDir = new FileInfo.Local((Filesystem)fs, "");
                Query query = RestoreDialog.this.query().restore(backupDir, RestoreDialog.this.progressBar(), Main.singleton().logger());
                msg = BpmMsgs.get("restored_album");
                StatusBox.singleton().queueShowMsg(msg.format(query.name()), false);
                Main.singleton().showAlbum(query);
            }
            catch (Exception xcp) {
                MAppMsg msg = BpmMsgs.get("unable_restore_album");
                StatusBox.singleton().queueShowMsg(msg.format(Utility.xcpMsg(xcp)), true);
            }
            TheRestore = null;
            if (RestoreDialog.singleton() != null) {
                RestoreDialog.singleton().enableAcceptButton(true);
                RestoreDialog.singleton().enableCancelButton(false);
                RestoreDialog.singleton().dispose();
            }
        }
    }
}

