/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumsgui;

import dialog.CenteredDialog;
import dialog.DialogEvent;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import mlib.MAppMsg;
import oroma.albumgui.AlbumBar;
import oroma.albumgui.PictureAnnotation;
import oroma.albumgui.PicturePanel;
import oroma.albumsgui.AlbumsBar;
import oroma.albumsgui.DbInfoLabel;
import oroma.db.ProgInstallation;
import oroma.db.ProgPreferences;
import oroma.gui.BpmMsgs;
import oroma.picinfogui.PicInfoPanel;
import oroma.prefgui.PrefPanel;
import swing.StatusBox;
import utilt.Utility;

public class PrefDialog
extends CenteredDialog {
    private PrefPanel iPrefPanel = new PrefPanel();
    private ProgPreferences iPref = null;

    public static float horzFrac() {
        return 0.5f;
    }

    public static float vertFrac() {
        float frac = 0.55f;
        if (Utility.widescreen()) {
            frac = 0.6f;
        }
        return frac;
    }

    private static void setupColors() {
        ProgPreferences pref = ProgPreferences.singleton();
        PictureAnnotation.singleton().putForeground(pref.panelForeColor());
        PictureAnnotation.singleton().putBackground(pref.headerBackColor());
        AlbumBar.singleton().setBackground(pref.headerBackColor());
        AlbumBar.singleton().setForeground(pref.panelForeColor());
        AlbumsBar.singleton().setBackground(pref.headerBackColor());
        AlbumsBar.singleton().setForeground(pref.panelForeColor());
        DbInfoLabel.singleton().setForeground(pref.panelForeColor());
        DbInfoLabel.singleton().setBackground(pref.headerBackColor());
        PicInfoPanel.singleton().setBackground(pref.panelBackColor());
    }

    private static void setupFonts() {
        ProgPreferences pref = ProgPreferences.singleton();
        DbInfoLabel.singleton().setFont(pref.menuFont());
        PictureAnnotation.singleton().putFont(pref.menuFont());
    }

    public PrefDialog(Frame owner) {
        super(owner);
        this.setModal(true);
        this.addClientPanel(this.iPrefPanel);
        this.iPref = (ProgPreferences)ProgPreferences.singleton().clone();
        this.addCustomButton(" Reset defaults ", 'R', null, null);
        this.addWindowListener(new WindowHandler());
        this.iPrefPanel.showPrefs();
    }

    @Override
    public void accept(DialogEvent event) {
        ProgInstallation install = ProgInstallation.singleton();
        this.dispose();
        PrefDialog.setupColors();
        PrefDialog.setupFonts();
        this.iPrefPanel.savePrefs();
        try {
            ProgPreferences.singleton().write(install, true);
            MAppMsg msg = BpmMsgs.get("saved_prefs");
            StatusBox.singleton().showMsg(msg.format(), false);
        }
        catch (IOException xcp) {
            MAppMsg msg = BpmMsgs.get("unable_save_prefs");
            StatusBox.singleton().showMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
        }
        PicturePanel.singleton().repaint();
    }

    @Override
    public void cancel(DialogEvent event) {
        ProgPreferences.singleton().assign(this.iPref);
        this.dispose();
        MAppMsg msg = BpmMsgs.get("edit_cancelled");
        StatusBox.singleton().showMsg(msg.format(), msg.isError());
    }

    @Override
    public void custom(int button, DialogEvent event) {
        ProgPreferences.singleton().assign(new ProgPreferences());
        this.iPrefPanel.showPrefs();
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosed(WindowEvent event) {
            AlbumsBar.singleton().enablePreferences(true);
            PicturePanel.singleton().requestFocus();
        }
    }
}

