/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumsgui;

import clp.Clp;
import dialog.DialogEvent;
import java.awt.Frame;
import mlib.MAppMsg;
import oroma.albumsgui.AlbumsPanel;
import oroma.albumsgui.QueryThreadDialog;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import oroma.gui.Main;
import swing.StatusBox;
import utilt.Utility;

public class ExtractDialog
extends QueryThreadDialog {
    private static volatile Extracter TheExtract = null;

    public static boolean inProgress() {
        return TheExtract != null;
    }

    public ExtractDialog(Frame owner, Query query, String dirPath) {
        super(owner, query, dirPath);
        TheExtract = new Extracter();
        TheExtract.setName("Extracter");
        TheExtract.start();
    }

    @Override
    public void cancel(DialogEvent event) {
        if (TheExtract != null) {
            TheExtract.interrupt();
        }
        this.dispose();
    }

    private class Extracter
    extends Thread {
        private Extracter() {
        }

        @Override
        public void run() {
            Clp clp = Main.singleton().clp();
            try {
                clp.state().removeParm("result");
                String text = "Extracting album " + ExtractDialog.this.query().name() + " to " + ExtractDialog.this.dirPath() + "...";
                StatusBox.singleton().queueShowMsg(text, false);
                Clp.DynamicCmd dcmd = new Clp.DynamicCmd(clp, "extract images");
                dcmd.addArg("extract", null, false);
                dcmd.addArg("album", ExtractDialog.this.query().name(), false);
                dcmd.addArg("folder", ExtractDialog.this.dirPath(), false);
                clp.state().putParm("progressbar", ExtractDialog.this.progressBar());
                dcmd.execute();
                Integer count = (Integer)clp.state().parm("result");
                if (count >= 0) {
                    MAppMsg msg = BpmMsgs.get("extracted_album");
                    text = msg.format(count.toString());
                    StatusBox.singleton().queueShowMsg(text, false);
                    AlbumsPanel.singleton().showAlbums(false);
                } else {
                    StatusBox.singleton().queueShowMsg("Extract stopped", false);
                }
            }
            catch (Exception xcp) {
                MAppMsg msg = BpmMsgs.get("unable_extract_album");
                StatusBox.singleton().queueShowMsg(msg.format(Utility.xcpMsg(xcp)), true);
            }
            TheExtract = null;
            if (ExtractDialog.singleton() != null) {
                ExtractDialog.singleton().enableAcceptButton(true);
                ExtractDialog.singleton().enableCancelButton(false);
                ExtractDialog.singleton().dispose();
            }
        }
    }
}

