/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumsgui;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import oroma.db.Database;
import oroma.db.ProgPreferences;
import swing.ColorPanel;
import swing.PanelLabel;

public class DbInfoLabel
extends ColorPanel {
    private PanelLabel iLabel = new PanelLabel();
    private static DbInfoLabel Singleton = null;

    public static DbInfoLabel singleton() {
        if (Singleton == null) {
            Singleton = new DbInfoLabel();
        }
        return Singleton;
    }

    @Override
    public void show() {
        Displayer thread = new Displayer();
        EventQueue.invokeLater(thread);
    }

    private DbInfoLabel() {
        this.setLayout(new BorderLayout());
        ProgPreferences pref = ProgPreferences.singleton();
        this.setBackground(pref.headerBackColor());
        this.iLabel.setBackground(pref.headerBackColor());
        this.iLabel.setForeground(pref.panelForeColor());
        this.iLabel.setFont(pref.menuFont());
        this.add(this.iLabel);
        this.setToolTipText(" Database size");
    }

    private void show(int numAlbums, int numPics) {
        String text = " " + numAlbums + " albums and " + numPics + " photos  ";
        this.iLabel.setText(text);
    }

    private class Displayer
    extends Thread {
        private Displayer() {
        }

        @Override
        public void run() {
            Database db = Database.singleton();
            Singleton.show(db.numQueries(), db.numPics());
        }
    }
}

