/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumsgui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import mswing.WheelComboBoxDb;
import oroma.albumsgui.AlbumsPanel;
import oroma.db.Database;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.gui.Main;
import swing.SwingProgram;
import swing.WheelComboBox;

public class CategorySelectionBox
extends WheelComboBox {
    private boolean iEnabled = true;
    private ImageIcon iCategoryIcon = null;
    private static CategorySelectionBox Singleton = null;

    public static CategorySelectionBox singleton() {
        if (Singleton == null) {
            Singleton = new CategorySelectionBox();
            Singleton.removeFromList();
        }
        return Singleton;
    }

    private CategorySelectionBox() {
        this.setAcceptEmpty(false);
        this.setRenderer(new Renderer());
        this.iCategoryIcon = Main.singleton().iconMgr().icon("category");
        this.setBorder(SwingProgram.STDBORDER);
        this.setEditable(false);
        WheelComboBoxDb db = Database.singleton().comboDb("category");
        this.setDb(db, false);
        this.removeEmpty();
        this.addActionListener(new ActionHandler());
    }

    @Override
    public void removeAll() {
        super.removeAllItems();
        this.addItem("*");
        this.setSelectedItem("*");
    }

    public void remove(String catName) {
        if (!catName.equals("*")) {
            this.removeItem(catName);
        }
    }

    public void enabled(boolean enabled) {
        this.iEnabled = enabled;
    }

    private void removeEmpty() {
        for (String string : this.items()) {
            TreeSet<Query> queries = Database.singleton().queriesByCat(string);
            if (queries.size() != 0) continue;
            this.removeItem(string);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private String iLastCatDisplayed = "";

        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String cat = (String)CategorySelectionBox.this.getSelectedItem();
            if (CategorySelectionBox.this.iEnabled && cat != null && !this.iLastCatDisplayed.equals(cat)) {
                AlbumsPanel.singleton().showAlbums(true);
                ProgPreferences pref = ProgPreferences.singleton();
                pref.setLastCat(cat);
                this.iLastCatDisplayed = cat;
            }
        }
    }

    private class Renderer
    implements ListCellRenderer<Object> {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = new JLabel((String)value);
            label.setOpaque(true);
            label.setHorizontalTextPosition(4);
            label.setIcon(CategorySelectionBox.this.iCategoryIcon);
            ProgPreferences pref = ProgPreferences.singleton();
            label.setFont(pref.menuFont());
            label.setBackground(pref.panelBackColor());
            label.setForeground(pref.panelForeColor());
            return label;
        }
    }
}

