/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumsgui;

import dialog.DialogEvent;
import files.FileInfo;
import files.Filesystem;
import java.awt.Frame;
import mlib.MAppMsg;
import oroma.albumsgui.AlbumsPanel;
import oroma.albumsgui.QueryThreadDialog;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import oroma.gui.Main;
import swing.StatusBox;
import utilt.Utility;

public class BackupDialog
extends QueryThreadDialog {
    private static volatile Backup TheBackup = null;

    public static boolean inProgress() {
        return TheBackup != null;
    }

    public BackupDialog(Frame owner, Query query, String dirPath) {
        super(owner, query, dirPath);
        TheBackup = new Backup();
        TheBackup.setName("Backup");
        TheBackup.start();
    }

    @Override
    public void cancel(DialogEvent event) {
        if (TheBackup != null) {
            TheBackup.interrupt();
        }
        this.dispose();
    }

    private class Backup
    extends Thread {
        private Backup() {
        }

        @Override
        public void run() {
            try {
                MAppMsg msg = BpmMsgs.get("backingup_album");
                StatusBox.singleton().queueShowMsg(msg.format(BackupDialog.this.query().name()), false);
                Filesystem.Local fs = new Filesystem.Local(BackupDialog.this.dirPath(), true);
                FileInfo.Local parentDir = new FileInfo.Local((Filesystem)fs, "");
                int count = BackupDialog.this.query().backup(parentDir, BackupDialog.this.progressBar(), Main.singleton().logger());
                msg = BpmMsgs.get("backedup_album");
                StatusBox.singleton().queueShowMsg(msg.format(Integer.toString(count)), false);
                if (count >= 0) {
                    AlbumsPanel.singleton().showAlbums(false);
                }
            }
            catch (Exception xcp) {
                MAppMsg msg = BpmMsgs.get("unable_backup_album");
                StatusBox.singleton().queueShowMsg(msg.format(Utility.xcpMsg(xcp)), true);
            }
            TheBackup = null;
            if (BackupDialog.singleton() != null) {
                BackupDialog.singleton().enableAcceptButton(true);
                BackupDialog.singleton().enableCancelButton(false);
                BackupDialog.singleton().dispose();
            }
        }
    }
}

