/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumsgui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import mlib.MAppMsg;
import oroma.albumsgui.AlbumPopupObject;
import oroma.albumsgui.AlbumsBar;
import oroma.albumsgui.CategorySelectionBox;
import oroma.db.Database;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.db.Website;
import oroma.gui.BpmMsgs;
import oroma.gui.CustomPopupPanel;
import oroma.gui.Main;
import swing.StatusBox;

public class AlbumsPanel
extends JPanel {
    private CustomPopupPanel jAlbumsPopupPanel = new AlbumsPopupPanel();
    private static final Color HASWEBSITECOLOR = Color.blue;
    private static AlbumsPanel Singleton = null;

    public static AlbumsPanel singleton() {
        if (Singleton == null) {
            Singleton = new AlbumsPanel();
        }
        return Singleton;
    }

    private static void setupDbButtons() {
        int numPics = Database.singleton().numPics();
        boolean enable = numPics > 0;
        AlbumsBar.singleton().enableOrphans(enable);
        enable &= Database.singleton().numQueries() > 0;
    }

    private AlbumsPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)AlbumsBar.singleton(), "North");
        this.add((Component)this.jAlbumsPopupPanel, "Center");
        ProgPreferences curPref = ProgPreferences.singleton();
        this.jAlbumsPopupPanel.setMenuFont(curPref.menuFont());
        this.jAlbumsPopupPanel.setLabelFont(curPref.menuFont());
        this.jAlbumsPopupPanel.setSelectionColor(curPref.selectionColor());
        Singleton = this;
    }

    public void setup() {
        Database.singleton().addListener(new DbHandler());
        AlbumsPanel.setupDbButtons();
        this.showAlbums(true);
    }

    public void showAlbums(boolean showMsg) {
        if (Main.singleton().isVisible()) {
            int count = 0;
            String catName = (String)CategorySelectionBox.singleton().getSelectedItem();
            if (catName == null) {
                catName = "*";
            }
            this.jAlbumsPopupPanel.removeAll();
            Database db = Database.singleton();
            TreeSet<Query> queries = Database.singleton().queriesByCat(catName);
            for (Query query : queries) {
                AlbumPopupObject obj = new AlbumPopupObject();
                try {
                    obj.putAlbumName(query.name());
                    Website site = db.webDb().find(query.name());
                    if (site != null) {
                        this.jAlbumsPopupPanel.add(obj, true, false, HASWEBSITECOLOR);
                    } else {
                        this.jAlbumsPopupPanel.add(obj, true, false);
                    }
                    ++count;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.jAlbumsPopupPanel.showItems();
            if (showMsg) {
                MAppMsg msg = BpmMsgs.get("albums_found");
                StatusBox.singleton().showMsg(msg.format(Integer.toString(count), catName), msg.isError());
            }
        }
    }

    public synchronized void queueShowAlbums(boolean showMsg) {
        Displayer displayer = new Displayer(showMsg);
        EventQueue.invokeLater(displayer);
    }

    public void selectAlbum(String name) {
        this.jAlbumsPopupPanel.selectItem(name);
    }

    public String firstAlbumName() {
        return this.jAlbumsPopupPanel.firstItemLabel();
    }

    private class AlbumsPopupPanel
    extends CustomPopupPanel {
        @Override
        public void handleMenu(String menuCmd) {
        }

        @Override
        public JPopupMenu panelMenu() {
            return null;
        }
    }

    private class DbHandler
    implements Database.Listener {
        private DbHandler() {
        }

        @Override
        public void queryDeleted(Database.Event event) {
            AlbumsPanel.setupDbButtons();
        }

        @Override
        public void queryAdded(Database.Event event) {
            AlbumsPanel.setupDbButtons();
        }

        @Override
        public void picDeleted(Database.Event event) {
            AlbumsPanel.setupDbButtons();
        }

        @Override
        public void picAdded(Database.Event event) {
            AlbumsPanel.setupDbButtons();
        }
    }

    private class Displayer
    extends Thread {
        private boolean iShowMsg = false;

        Displayer(boolean showMsg) {
            this.iShowMsg = showMsg;
        }

        @Override
        public void run() {
            AlbumsPanel.this.showAlbums(this.iShowMsg);
        }
    }
}

