/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumsgui;

import help.HelpEvent;
import help.HelpListener;
import help.HelpPrefs;
import help.HelpWindow;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import mlib.MAppMsg;
import oroma.albumgui.PicturePanel;
import oroma.albumsgui.AlbumDialog;
import oroma.albumsgui.CategorySelectionBox;
import oroma.albumsgui.DbInfoLabel;
import oroma.albumsgui.OrphanAnalyzer;
import oroma.albumsgui.PrefDialog;
import oroma.db.Database;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import oroma.gui.Main;
import oroma.gui.MainPanel;
import swing.ColorPanel;
import swing.ControlButton;
import swing.StatusBox;
import utilt.Utility;

public class AlbumsBar
extends JPanel {
    private JButton jHelpButton = null;
    private JButton jPreferencesButton = null;
    private JButton jAddAlbumButton = null;
    private JButton jAnalyzeButton = null;
    private CategorySelectionBox jCategoryBox = null;
    private static AlbumsBar Singleton = null;

    public static AlbumsBar singleton() {
        if (Singleton == null) {
            Singleton = new AlbumsBar();
        }
        return Singleton;
    }

    private AlbumsBar() {
        ProgPreferences pref = ProgPreferences.singleton();
        this.setLayout(new GridLayout(0, 3));
        this.setBackground(pref.headerBackColor());
        this.setForeground(SystemColor.controlText);
        StatusBox box = StatusBox.singleton();
        box.setBackground(pref.headerBackColor());
        box.setForeground(pref.panelForeColor());
        box.setFont(pref.menuFont());
        this.fill(true);
    }

    public void fill(boolean showStatus) {
        this.setBackground(ProgPreferences.singleton().headerBackColor());
        this.removeAll();
        ColorPanel left = new ColorPanel();
        left.setLayout(new BoxLayout(left, 0));
        left.add(this.getPreferencesButton());
        left.add(this.getAddAlbumButton());
        left.add(this.getAnalyzeButton());
        left.add(this.getHelpButton());
        left.add(DbInfoLabel.singleton());
        this.add(left);
        this.add(this.getCategorySelectionBox());
        if (showStatus) {
            this.add(StatusBox.singleton());
        }
    }

    public void enableAddAlbum(boolean enable) {
        this.getAddAlbumButton().setEnabled(enable);
    }

    public void enableHelp(boolean enable) {
        this.getHelpButton().setEnabled(enable);
    }

    public void enableOrphans(boolean enable) {
        this.getAnalyzeButton().setEnabled(enable);
    }

    public void enablePreferences(boolean enable) {
        this.getPreferencesButton().setEnabled(enable);
    }

    private JButton getAddAlbumButton() {
        if (this.jAddAlbumButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("plus");
            this.jAddAlbumButton = new ControlButton("Add album", icon, 'a');
            this.jAddAlbumButton.addActionListener(new AddAlbumHandler());
            ProgPreferences pref = ProgPreferences.singleton();
            this.jAddAlbumButton.setBackground(pref.headerBackColor());
        }
        return this.jAddAlbumButton;
    }

    private JButton getHelpButton() {
        if (this.jHelpButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("help");
            this.jHelpButton = new ControlButton("Help", icon, 'h');
            this.jHelpButton.addActionListener(new HelpHandler());
            ProgPreferences pref = ProgPreferences.singleton();
            this.jHelpButton.setBackground(pref.headerBackColor());
        }
        return this.jHelpButton;
    }

    private JButton getAnalyzeButton() {
        if (this.jAnalyzeButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("analyze");
            this.jAnalyzeButton = new ControlButton("Analyze for orphan photos", icon, 'z');
            this.jAnalyzeButton.addActionListener(new AnalyzeHandler());
            ProgPreferences pref = ProgPreferences.singleton();
            this.jAnalyzeButton.setBackground(pref.headerBackColor());
        }
        return this.jAnalyzeButton;
    }

    private JButton getPreferencesButton() {
        if (this.jPreferencesButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("pref");
            this.jPreferencesButton = new ControlButton("Set preferences", icon, 'f');
            this.jPreferencesButton.addActionListener(new PrefHandler());
            ProgPreferences pref = ProgPreferences.singleton();
            this.jPreferencesButton.setBackground(pref.headerBackColor());
        }
        return this.jPreferencesButton;
    }

    private CategorySelectionBox getCategorySelectionBox() {
        if (this.jCategoryBox == null) {
            this.jCategoryBox = CategorySelectionBox.singleton();
            this.jCategoryBox.setToolTipText("Category Selector");
        }
        return this.jCategoryBox;
    }

    private class AddAlbumHandler
    implements ActionListener {
        private AddAlbumHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            AlbumDialog dialog = new AlbumDialog(Main.singleton());
            dialog.setTitle("Add Album");
            dialog.center(AlbumDialog.horzFrac(), AlbumDialog.vertFrac());
            Query query = new Query(Database.singleton().nextObjNum());
            query.setCategory((String)CategorySelectionBox.singleton().getSelectedItem());
            dialog.setQuery(query);
            dialog.setVisible(true);
            AlbumsBar.this.enableAddAlbum(false);
        }
    }

    private class AnalyzeHandler
    implements ActionListener {
        private AnalyzeHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            OrphanAnalyzer analyzer = new OrphanAnalyzer();
            analyzer.setName("Analyzer");
            analyzer.start();
            PicturePanel.singleton().requestFocus();
        }
    }

    private class HelpDialogHandler
    implements HelpListener {
        private HelpDialogHandler() {
        }

        @Override
        public void ioError(HelpEvent event, Exception xcp) {
            MAppMsg msg = BpmMsgs.get("no_help");
            StatusBox.singleton().showMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
        }

        @Override
        public void selected(HelpEvent event) {
        }

        @Override
        public void windowClosing(HelpEvent event) {
            MainPanel.enableHelp();
        }
    }

    private class HelpHandler
    implements ActionListener {
        private HelpHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            StatusBox.singleton().showMsg("Bluemont Photo Manager help", false);
            HelpPrefs prefs = ProgPreferences.singleton().helpPrefs();
            ImageIcon icon = Main.singleton().iconMgr().icon("bpm");
            HelpWindow dialog = HelpWindow.create(Main.TheHelpTree, icon, prefs);
            dialog.addHelpListener(new HelpDialogHandler());
            MainPanel.enableHelp();
            dialog.setVisible(true);
        }
    }

    private class PrefHandler
    implements ActionListener {
        private PrefHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            AlbumsBar.this.enablePreferences(false);
            PrefDialog dialog = new PrefDialog(Main.singleton());
            dialog.setTitle("Preferences");
            dialog.center(PrefDialog.horzFrac(), PrefDialog.vertFrac());
            dialog.setVisible(true);
        }
    }
}

