/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumsgui;

import dialog.ConfirmDialog;
import filedialog.FileChooser;
import filedialog.FileChooserFilter;
import filedialog.FilePopupObject;
import java.awt.Frame;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import mlib.MAppMsg;
import mswing.ThumbnailImage;
import oroma.albumgui.AlbumPanel;
import oroma.albumgui.AlbumSelectionBox;
import oroma.albumgui.ImagePrinter;
import oroma.albumsgui.AlbumDeleteDialog;
import oroma.albumsgui.AlbumDialog;
import oroma.albumsgui.AlbumsBar;
import oroma.albumsgui.BackupDialog;
import oroma.albumsgui.ExtractDialog;
import oroma.albumsgui.QueryThreadDialog;
import oroma.albumsgui.RestoreDialog;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.db.Website;
import oroma.gui.BpmMsgs;
import oroma.gui.Main;
import oroma.picinfogui.PicInfoPanel;
import oroma.slideshow.SlideshowDialog;
import oroma.website.WebDefDialog;
import oroma.website.WebMgr;
import popup.PopupObject;
import popup.PopupPanel;
import swing.StatusBox;

public class AlbumPopupObject
implements PopupObject {
    private Query iQuery = null;
    private static final String COPY = "Copy";
    private static final String DISPLAY = "Display";
    private static final String DELETE = "Delete";
    private static final String EDIT = "Edit";
    private static final String PRINT = "Print";
    private static final String SLIDESHOW = "Slideshow";
    private static final String WEBSITE = "Create website";
    private static final String EXTRACT = "Extract";
    private static final String BACKUP = "Backup";
    private static final String RESTORE = "Restore";
    private static JPopupMenu AlbumMenu = null;
    private static JMenuItem DisplayItem = null;
    private static JMenuItem DeleteItem = null;
    private static JMenuItem EditItem = null;
    private static JMenuItem PrintItem = null;
    private static JMenuItem WebsiteItem = null;
    private static JMenuItem CopyItem = null;
    private static JMenuItem SlideshowItem = null;
    private static JMenuItem ExtractItem = null;
    private static JMenuItem BackupItem = null;
    private static JMenuItem RestoreItem = null;

    public static void setup() {
        if (AlbumMenu == null) {
            AlbumMenu = new JPopupMenu();
            CopyItem = new JMenuItem(COPY);
            CopyItem.setActionCommand(COPY);
            AlbumMenu.add(CopyItem);
            DeleteItem = new JMenuItem(DELETE);
            DeleteItem.setActionCommand(DELETE);
            AlbumMenu.add(DeleteItem);
            DisplayItem = new JMenuItem(DISPLAY);
            DisplayItem.setActionCommand(DISPLAY);
            AlbumMenu.add(DisplayItem);
            EditItem = new JMenuItem(EDIT);
            EditItem.setActionCommand(EDIT);
            AlbumMenu.add(EditItem);
            ExtractItem = new JMenuItem(EXTRACT);
            ExtractItem.setActionCommand(EXTRACT);
            AlbumMenu.add(ExtractItem);
            BackupItem = new JMenuItem(BACKUP);
            BackupItem.setActionCommand(BACKUP);
            AlbumMenu.add(BackupItem);
            RestoreItem = new JMenuItem(RESTORE);
            RestoreItem.setActionCommand(RESTORE);
            AlbumMenu.add(RestoreItem);
            PrintItem = new JMenuItem(PRINT);
            PrintItem.setActionCommand(PRINT);
            AlbumMenu.add(PrintItem);
            SlideshowItem = new JMenuItem(SLIDESHOW);
            SlideshowItem.setActionCommand(SLIDESHOW);
            AlbumMenu.add(SlideshowItem);
            WebsiteItem = new JMenuItem(WEBSITE);
            WebsiteItem.setActionCommand(WEBSITE);
            AlbumMenu.add(WebsiteItem);
        }
    }

    private void handleEdit() {
        boolean noEdit = false;
        AlbumPanel albumPanel = AlbumPanel.singleton();
        if (albumPanel.isAddingPics()) {
            Query curAlbum = AlbumSelectionBox.singleton().getCurAlbum();
            noEdit = this.iQuery.name().equalsIgnoreCase(curAlbum.name());
        }
        if (noEdit) {
            MAppMsg msg = BpmMsgs.get("no_album_edit");
            StatusBox.singleton().showMsg(msg.format(), msg.isError());
        } else {
            AlbumDialog dialog = new AlbumDialog(Main.singleton());
            dialog.setTitle("Edit Album");
            dialog.center(AlbumDialog.horzFrac(), AlbumDialog.vertFrac());
            this.iQuery.setPrevName(this.iQuery.name());
            dialog.setQuery(this.iQuery);
            dialog.setVisible(true);
            AlbumsBar.singleton().enableAddAlbum(false);
        }
    }

    private void handleCopy() {
        AlbumDialog dialog = new AlbumDialog(Main.singleton());
        dialog.setTitle("Copy Album");
        dialog.center(AlbumDialog.horzFrac(), AlbumDialog.vertFrac());
        try {
            try {
                Query query = Database.singleton().query(this.iQuery.name(), true);
                Query copy = (Query)query.clone();
                copy.setId(Database.singleton().nextObjNum());
                copy.setName("");
                copy.setPrevName(copy.name());
                dialog.setQuery(copy);
                dialog.setVisible(true);
            }
            catch (Exception xcp) {
                MAppMsg msg = BpmMsgs.get("album_not_found");
                StatusBox.singleton().showMsg(msg.format(this.iQuery.name()), msg.isError());
                AlbumsBar.singleton().enableAddAlbum(false);
            }
        }
        finally {
            AlbumsBar.singleton().enableAddAlbum(false);
        }
    }

    private void handleDelete(PopupPanel panel) {
        AlbumDeleteDialog dialog = new AlbumDeleteDialog((Frame)Main.singleton(), this.iQuery, panel, this);
        dialog.setTitle("Delete Confirmation");
        dialog.center(AlbumDeleteDialog.horzFrac(), AlbumDeleteDialog.vertFrac());
        dialog.setVisible(true);
    }

    private void handleDisplay() {
        Main.singleton().showAlbum(this.iQuery);
    }

    @Override
    public void handleEvent(PopupPanel panel, boolean doubleClicked, String menuCmd) {
        if (doubleClicked) {
            this.handleDisplay();
        } else if (menuCmd.equals(DELETE)) {
            this.handleDelete(panel);
        } else if (menuCmd.equals(EDIT)) {
            this.handleEdit();
        } else if (menuCmd.equals(COPY)) {
            this.handleCopy();
        } else if (menuCmd.equals(DISPLAY)) {
            this.handleDisplay();
        } else if (menuCmd.equals(PRINT)) {
            this.handlePrint();
        } else if (menuCmd.equals(SLIDESHOW)) {
            this.handleSlideshow();
        } else if (menuCmd.equals(EXTRACT)) {
            this.handleExtract();
        } else if (menuCmd.equals(BACKUP)) {
            this.handleBackup();
        } else if (menuCmd.equals(RESTORE)) {
            this.handleRestore();
        } else {
            this.handleWebsite();
        }
    }

    private void handleExtract() {
        if (!this.handleEmptyAlbum()) {
            ProgPreferences pref = ProgPreferences.singleton();
            FileChooserFilter filter = new FileChooserFilter(null, true, true, "SelectDir");
            FileChooser chooser = new FileChooser(pref, filter, true, true, false, Main.singleton(), false);
            chooser.center(0.7, 0.7);
            chooser.setFont(pref.menuFont());
            chooser.addListener(new ExtractHandler());
            chooser.setTitle("Extract Photo Files");
            chooser.setVisible(true);
        }
    }

    private void handleBackup() {
        if (!this.handleEmptyAlbum()) {
            ProgPreferences pref = ProgPreferences.singleton();
            FileChooserFilter filter = new FileChooserFilter(null, true, true, "SelectDir");
            FileChooser chooser = new FileChooser(pref, filter, true, true, false, Main.singleton(), false);
            chooser.center(0.7, 0.7);
            chooser.setFont(pref.menuFont());
            chooser.addListener(new BackupHandler());
            chooser.setTitle("Backup Album");
            chooser.setVisible(true);
        }
    }

    private void handleRestore() {
        ProgPreferences pref = ProgPreferences.singleton();
        TreeSet<PicInfo> picInfos = Database.singleton().selectPicInfos(this.iQuery);
        boolean proceed = true;
        if (picInfos.size() > 0) {
            MAppMsg msg = BpmMsgs.get("album_restore");
            ImageIcon icon = Main.singleton().iconMgr().icon("confirmation");
            ConfirmDialog dialog = new ConfirmDialog((Frame)Main.singleton(), "Album Restore Confirmation", msg.format(this.iQuery.name()), icon);
            dialog.setFont(pref.menuFont());
            dialog.center(0.5, 0.2);
            proceed = dialog.display();
        }
        if (proceed) {
            FileChooserFilter filter = new FileChooserFilter(null, true, true, "SelectDir");
            FileChooser chooser = new FileChooser(pref, filter, true, true, false, Main.singleton(), false);
            chooser.center(0.7, 0.7);
            chooser.setFont(pref.menuFont());
            chooser.addListener(new RestoreHandler());
            chooser.setTitle("Album Selection");
            chooser.setVisible(true);
        }
    }

    private void handleSlideshow() {
        if (!this.handleEmptyAlbum()) {
            PicInfoPanel.singleton().setPicInfo(new PicInfo());
            PicInfoPanel.singleton().setEnabled(false);
            SlideshowDialog slideshowDialog = new SlideshowDialog(this.iQuery);
        }
    }

    private boolean handleEmptyAlbum() {
        boolean empty;
        TreeSet<PicInfo> pics = Database.singleton().selectPicInfos(this.iQuery);
        boolean bl = empty = pics.size() == 0;
        if (empty) {
            MAppMsg msg = BpmMsgs.get("album_empty");
            StatusBox.singleton().showMsg(msg.format(this.iQuery.name()), msg.isError());
        }
        return empty;
    }

    private void handlePrint() {
        if (!this.handleEmptyAlbum()) {
            TreeSet<PicInfo> pics = Database.singleton().selectPicInfos(this.iQuery);
            ProgPreferences pref = ProgPreferences.singleton();
            ImagePrinter printer = new ImagePrinter(pics, pref.printInfoSizePc());
            printer.setName("BPM Printer");
            printer.start();
        }
    }

    private void handleWebsite() {
        if (!this.handleEmptyAlbum()) {
            WebDefDialog dialog = new WebDefDialog(Main.singleton());
            dialog.setTitle("Create Album Website");
            dialog.center(WebDefDialog.calcHorzFrac(), WebDefDialog.calcVertFrac());
            try {
                Website site = Database.singleton().webDb().find(this.iQuery.name());
                if (site == null) {
                    site = new Website(this.iQuery.name());
                }
                Database.singleton().webDb().put(site);
                dialog.setSite(site);
                dialog.setVisible(true);
            }
            catch (Exception xcp) {
                MAppMsg msg = BpmMsgs.get("album_not_found");
                StatusBox.singleton().showMsg(msg.format(this.iQuery.name()), msg.isError());
            }
        }
    }

    @Override
    public ThumbnailImage thumb() {
        return this.iQuery.thumb();
    }

    @Override
    public String label() {
        return this.iQuery.name();
    }

    @Override
    public String id() {
        return this.iQuery.name();
    }

    @Override
    public int compareTo(PopupObject obj) {
        int result = 0;
        if (obj != this) {
            result = -1;
            if (obj != null && this.getClass() == obj.getClass()) {
                AlbumPopupObject popup = (AlbumPopupObject)obj;
                result = this.id().compareToIgnoreCase(popup.id());
            }
        }
        return result;
    }

    @Override
    public boolean equalTo(Object obj) {
        return this.compareTo((AlbumPopupObject)obj) == 0;
    }

    @Override
    public JPopupMenu menu() {
        boolean inProgress;
        AlbumPanel panel = AlbumPanel.singleton();
        Query curAlbum = AlbumSelectionBox.singleton().getCurAlbum();
        EditItem.setEnabled(true);
        CopyItem.setEnabled(true);
        PrintItem.setEnabled(true);
        DisplayItem.setEnabled(true);
        DeleteItem.setEnabled(true);
        WebsiteItem.setEnabled(true);
        SlideshowItem.setEnabled(true);
        ExtractItem.setEnabled(true);
        BackupItem.setEnabled(true);
        RestoreItem.setEnabled(true);
        boolean isCurAlbum = false;
        if (curAlbum != null) {
            isCurAlbum = this.iQuery.name().equalsIgnoreCase(curAlbum.name());
        }
        if (WebDefDialog.isDisplayed() || WebMgr.buildActive()) {
            WebsiteItem.setEnabled(false);
            DeleteItem.setEnabled(false);
        }
        if (this.iQuery.name().equals("Orphans")) {
            DisplayItem.setEnabled(true);
            DeleteItem.setEnabled(true);
            ExtractItem.setEnabled(true);
            SlideshowItem.setEnabled(true);
            EditItem.setEnabled(false);
            CopyItem.setEnabled(false);
            PrintItem.setEnabled(false);
            WebsiteItem.setEnabled(false);
            BackupItem.setEnabled(false);
            RestoreItem.setEnabled(false);
        }
        boolean bl = inProgress = ExtractDialog.inProgress() || BackupDialog.inProgress() || RestoreDialog.inProgress();
        if (inProgress) {
            ExtractItem.setEnabled(false);
            BackupItem.setEnabled(false);
            RestoreItem.setEnabled(false);
            SlideshowItem.setEnabled(false);
        }
        if (!panel.isSelectionEnabled()) {
            DisplayItem.setEnabled(false);
            if (isCurAlbum) {
                DeleteItem.setEnabled(false);
                if (panel.isAddingPics()) {
                    EditItem.setEnabled(false);
                }
            }
        }
        return AlbumMenu;
    }

    public void putAlbumName(String name) throws Exception {
        this.iQuery = Database.singleton().query(name, true);
    }

    private class BackupHandler
    implements FileChooser.Listener {
        private BackupHandler() {
        }

        @Override
        public void selected(FileChooser.Event event) {
            LinkedList<FilePopupObject> selections = event.selections();
            if (selections.size() > 0) {
                Iterator iter = selections.iterator();
                FilePopupObject selection = (FilePopupObject)iter.next();
                BackupDialog dialog = new BackupDialog((Frame)Main.singleton(), AlbumPopupObject.this.iQuery, selection.getName());
                String title = "Backup Album";
                dialog.setTitle(title);
                dialog.center(QueryThreadDialog.horzFrac(), QueryThreadDialog.vertFrac());
                dialog.setVisible(true);
            }
        }

        @Override
        public void message(FileChooser.Event event) {
            StatusBox.singleton().showMsg(event.msg(), false);
        }
    }

    private class ExtractHandler
    implements FileChooser.Listener {
        private ExtractHandler() {
        }

        @Override
        public void selected(FileChooser.Event event) {
            LinkedList<FilePopupObject> selections = event.selections();
            if (selections.size() > 0) {
                Iterator iter = selections.iterator();
                FilePopupObject selection = (FilePopupObject)iter.next();
                ExtractDialog dialog = new ExtractDialog((Frame)Main.singleton(), AlbumPopupObject.this.iQuery, selection.getName());
                String title = "Extract Album";
                dialog.setTitle(title);
                dialog.center(QueryThreadDialog.horzFrac(), QueryThreadDialog.vertFrac());
                dialog.setVisible(true);
            }
        }

        @Override
        public void message(FileChooser.Event event) {
            StatusBox.singleton().showMsg(event.msg(), false);
        }
    }

    private class RestoreHandler
    implements FileChooser.Listener {
        private RestoreHandler() {
        }

        @Override
        public void selected(FileChooser.Event event) {
            LinkedList<FilePopupObject> selections = event.selections();
            if (selections.size() > 0) {
                Iterator iter = selections.iterator();
                FilePopupObject selection = (FilePopupObject)iter.next();
                RestoreDialog dialog = new RestoreDialog((Frame)Main.singleton(), AlbumPopupObject.this.iQuery, selection.getName());
                String title = "Restore Album";
                dialog.setTitle(title);
                dialog.center(QueryThreadDialog.horzFrac(), QueryThreadDialog.vertFrac());
                dialog.setVisible(true);
            }
        }

        @Override
        public void message(FileChooser.Event event) {
            StatusBox.singleton().showMsg(event.msg(), false);
        }
    }
}

