/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumsgui;

import dialog.CenteredDialog;
import dialog.DialogEvent;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import mlib.MAppMsg;
import oroma.albumgui.AlbumPanel;
import oroma.albumgui.PicturePanel;
import oroma.albumsgui.AlbumsBar;
import oroma.albumsgui.AlbumsPanel;
import oroma.albumsgui.CategorySelectionBox;
import oroma.albumsgui.DbInfoLabel;
import oroma.albumsgui.QueryPanel;
import oroma.db.Database;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.db.WebDb;
import oroma.gui.BpmMsgs;
import swing.DatePanel;
import swing.EntryField;
import swing.StatusBox;
import swing.StdScrollPane;
import utilt.Utility;

public class AlbumDialog
extends CenteredDialog {
    private Query iQuery = null;
    private Query iQuerySave = null;
    private QueryPanel iQueryPanel = new QueryPanel();
    private int iDisplayButton = -1;

    public static float horzFrac() {
        return 0.5f;
    }

    public static float vertFrac() {
        ProgPreferences pref = ProgPreferences.singleton();
        int numFields = pref.dispFields().size() + 2;
        int pixSize = numFields * (pref.menuFont().getSize() + 20) + 150;
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        float vertFrac = (float)pixSize / (float)screen.height;
        if (vertFrac > 0.95f) {
            vertFrac = 0.95f;
        }
        return vertFrac;
    }

    public AlbumDialog(Frame owner) {
        super(owner);
        this.setModal(false);
        this.addClientPanel(new StdScrollPane(this.iQueryPanel));
        this.iDisplayButton = this.addCustomButton(" Display ", 'D', null, null);
        this.enableCustomButton(this.iDisplayButton, false);
        this.setFont(ProgPreferences.singleton().menuFont());
        EntryField.putBackColorAll(ProgPreferences.singleton().entryBackColor());
        DatePanel.putBackColorAll(ProgPreferences.singleton().entryBackColor());
        this.addWindowListener(new WindowHandler());
    }

    @Override
    public void accept(DialogEvent event) {
        String result = this.iQueryPanel.testIfValid();
        if (result != null) {
            StatusBox.singleton().showMsg(result, true);
        } else {
            try {
                boolean isCopy;
                Query query = this.iQueryPanel.query();
                boolean bl = isCopy = query.prevName().length() == 0;
                if (isCopy) {
                    boolean error;
                    Query existing = Database.singleton().query(query.name(), false);
                    boolean bl2 = error = existing != null;
                    if (error) {
                        MAppMsg msg = BpmMsgs.get("duplicate_album");
                        StatusBox.singleton().showMsg(msg.format(query.name()), msg.isError());
                    } else {
                        Database.singleton().putQuery(query, true);
                        this.dispose();
                        AlbumsPanel.singleton().showAlbums(true);
                        DbInfoLabel.singleton().show();
                        CategorySelectionBox.singleton().addItem(query.category());
                        MAppMsg msg = BpmMsgs.get("album_added");
                        StatusBox.singleton().showMsg(msg.format(query.name()), msg.isError());
                    }
                } else {
                    boolean isRename;
                    this.iQuery.assign(query);
                    Database.singleton().putQuery(query, true);
                    boolean bl3 = isRename = query.prevName().length() >= 0 && !query.prevName().equals(query.name());
                    if (isRename) {
                        Database.singleton().deleteQuery(query.prevName(), true);
                        WebDb webDb = Database.singleton().webDb();
                        webDb.rename(query.prevName(), query.name());
                    }
                    CategorySelectionBox.singleton().addItem(query.category());
                    this.dispose();
                    AlbumPanel.singleton().reshowAlbumIfCurrent(this.iQuery);
                    MAppMsg msg = BpmMsgs.get("album_saved");
                    StatusBox.singleton().showMsg(msg.format(query.name()), msg.isError());
                }
            }
            catch (Exception xcp) {
                MAppMsg msg = BpmMsgs.get("unable_save_album");
                StatusBox.singleton().showMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
            }
        }
    }

    @Override
    public void cancel(DialogEvent event) {
        this.dispose();
        MAppMsg msg = BpmMsgs.get("edit_cancelled");
        StatusBox.singleton().showMsg(msg.format(), msg.isError());
        this.iQuery.assign(this.iQuerySave);
        AlbumPanel.singleton().reshowAlbumIfCurrent(this.iQuery);
    }

    public void setQuery(Query query) {
        this.iQuery = query;
        this.iQuerySave = (Query)this.iQuery.clone();
        this.iQueryPanel.putQuery(true, this.iQuery);
        this.setFocusComp(this.iQueryPanel.focusComp());
        if (AlbumPanel.singleton().isCurAlbum(this.iQuery.name())) {
            this.enableCustomButton(this.iDisplayButton, true);
        }
    }

    @Override
    public void custom(int index, DialogEvent event) {
        String msg = this.iQueryPanel.testIfValid();
        if (msg != null) {
            StatusBox.singleton().showMsg(msg, true);
        } else {
            this.iQuery.assign(this.iQueryPanel.query());
            AlbumPanel.singleton().reshowAlbumIfCurrent(this.iQuery);
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosed(WindowEvent event) {
            AlbumsBar.singleton().enableAddAlbum(true);
            PicturePanel.singleton().requestFocus();
        }

        @Override
        public void windowOpened(WindowEvent event) {
            AlbumDialog.this.iQueryPanel.focusComp().requestFocus();
        }
    }
}

