/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumsgui;

import dialog.CenteredDialog;
import dialog.DialogEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import mlib.MAppMsg;
import oroma.albumgui.PicturePanel;
import oroma.albumgui.ThumbnailPanel;
import oroma.albumsgui.AlbumsPanel;
import oroma.albumsgui.DbInfoLabel;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import oroma.gui.Main;
import popup.PopupObject;
import popup.PopupPanel;
import swing.PanelLabel;
import swing.StatusBox;

public class AlbumDeleteDialog
extends CenteredDialog {
    private Panel iPanel = new Panel();
    private Query iQuery = null;
    private PopupObject iPopupObj = null;
    private PopupPanel iPopupPanel = null;

    public static float horzFrac() {
        return 0.45f;
    }

    public static float vertFrac() {
        int pixSize = 2 * ProgPreferences.singleton().menuFont().getSize() + 105;
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        float vertFrac = (float)pixSize / (float)screen.height;
        return vertFrac;
    }

    public AlbumDeleteDialog(Frame owner, Query query, PopupPanel panel, PopupObject obj) {
        super(owner);
        this.setModal(false);
        this.iQuery = query;
        this.iPopupPanel = panel;
        this.iPopupObj = obj;
        this.addClientPanel(this.iPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(DialogEvent event) {
        this.dispose();
        String albumName = this.iQuery.name();
        try {
            try {
                Database db;
                AlbumsPanel.singleton().setCursor(Cursor.getPredefinedCursor(3));
                Database database = db = Database.singleton();
                synchronized (database) {
                    int numPics = 0;
                    if (this.iPanel.deletePics()) {
                        TreeSet<PicInfo> pics = db.selectPicInfos(this.iQuery);
                        db.deletePics(pics, true);
                        ThumbnailPanel.singleton().deletePics(pics);
                        PicturePanel.singleton().clear(pics);
                        numPics = pics.size();
                    }
                    db.deleteQuery(this.iQuery.id(), true);
                    db.webDb().delete(albumName);
                    this.iPopupPanel.remove(this.iPopupObj);
                    this.iPopupPanel.showItems();
                    MAppMsg msg = BpmMsgs.get("deleted_album");
                    StatusBox.singleton().showMsg(msg.format(albumName, Integer.toString(numPics)), msg.isError());
                    DbInfoLabel.singleton().show();
                }
            }
            catch (Exception xcp) {
                MAppMsg msg = BpmMsgs.get("unable_delete_album");
                StatusBox.singleton().queueShowMsg(msg.format(albumName), msg.isError());
                AlbumsPanel.singleton().setCursor(Cursor.getDefaultCursor());
            }
        }
        finally {
            AlbumsPanel.singleton().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void cancel(DialogEvent event) {
        this.dispose();
    }

    @Override
    public void custom(int index, DialogEvent event) {
    }

    private class Panel
    extends JPanel {
        private PanelLabel jLabel = null;
        private JRadioButton jNoButton = new JRadioButton();
        private JRadioButton jYesButton = new JRadioButton();

        public Panel() {
            this.setBackground(ProgPreferences.singleton().dialogColor());
            this.setLayout(new BoxLayout(this, 0));
            this.add(Box.createHorizontalStrut(10));
            ImageIcon icon = Main.singleton().iconMgr().icon("confirmation");
            this.add(new JLabel(icon));
            this.add(Box.createHorizontalStrut(10));
            this.jLabel = new PanelLabel("Delete album photos also?");
            this.add((Component)this.jLabel, null);
            this.add(new PanelLabel("No"));
            this.add(this.jNoButton);
            this.add(new PanelLabel("Yes"));
            this.add(this.jYesButton);
            ButtonGroup group = new ButtonGroup();
            group.add(this.jNoButton);
            group.add(this.jYesButton);
            this.jNoButton.setBackground(this.getBackground());
            this.jYesButton.setBackground(this.getBackground());
            this.jNoButton.setSelected(true);
        }

        public boolean deletePics() {
            return this.jYesButton.isSelected();
        }
    }
}

