/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumgui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPopupMenu;
import oroma.albumgui.PicDisplay;
import oroma.albumgui.Thumbnail;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import oroma.gui.CustomPopupPanel;
import popup.PopupObject;

public class ThumbnailPanel
extends CustomPopupPanel {
    private LinkedList<Thumbnail> iThumbs = new LinkedList();
    private static ThumbnailPanel Singleton = null;

    public static ThumbnailPanel singleton() {
        if (Singleton == null) {
            Singleton = new ThumbnailPanel();
        }
        return Singleton;
    }

    private ThumbnailPanel() {
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        this.setComparator(null);
        this.setLabelFont(ProgPreferences.singleton().menuFont());
        this.setMenuFont(ProgPreferences.singleton().menuFont());
        int prefWidth = (int)((double)screen.width * 0.25 + 0.5);
        this.setPreferredSize(new Dimension(prefWidth, screen.height));
        this.setSelectionColor(ProgPreferences.singleton().selectionColor());
        this.setMinimumSize(new Dimension(screen.width / 10, 50));
        this.enablePopupMenus(true);
        this.enableSelection(true);
        Singleton = this;
    }

    public synchronized void addPic(PicDisplay disp) {
        Thumbnail tnail = new Thumbnail(disp);
        this.iThumbs.add(tnail);
    }

    public synchronized void addPics(LinkedList<PicDisplay> picDisps) {
        for (PicDisplay disp : picDisps) {
            Thumbnail tnail = new Thumbnail(disp);
            this.iThumbs.add(tnail);
        }
        this.showThumbs(false);
    }

    public synchronized Thumbnail firstThumb() {
        Thumbnail tnail = null;
        if (this.iThumbs.size() > 0) {
            tnail = this.iThumbs.getFirst();
        }
        return tnail;
    }

    public synchronized void deletePics(Collection<PicInfo> picInfos) {
        Iterator thumbs = this.iThumbs.iterator();
        while (thumbs.hasNext()) {
            Thumbnail thumb = (Thumbnail)thumbs.next();
            Iterator<PicInfo> infos = picInfos.iterator();
            boolean deleted = false;
            while (!deleted && infos.hasNext()) {
                PicInfo info = infos.next();
                if (thumb.picDisp().info() != info) continue;
                thumbs.remove();
                deleted = true;
            }
        }
        this.showThumbs(false);
    }

    public synchronized int numThumbs() {
        return this.iThumbs.size();
    }

    public synchronized void clear() {
        this.removeAll();
        this.iThumbs.clear();
        this.showItems();
    }

    @Override
    public void handleMenu(String menuCmd) {
    }

    @Override
    public JPopupMenu panelMenu() {
        return null;
    }

    public synchronized int remove(Thumbnail tnail) {
        LinkedList<Thumbnail> work = new LinkedList<Thumbnail>();
        work.addAll(this.iThumbs);
        String path = tnail.picDisp().info().picPathname();
        Iterator iter = work.iterator();
        boolean deleted = false;
        while (!deleted && iter.hasNext()) {
            Thumbnail thumb = (Thumbnail)iter.next();
            String tPath = thumb.picDisp().info().picPathname();
            deleted = path.equals(tPath);
            if (!deleted) continue;
            work.remove(thumb);
        }
        this.iThumbs.clear();
        this.iThumbs.addAll(work);
        this.showThumbs(false);
        return this.iThumbs.size();
    }

    public void showThumbs(boolean setFirst) {
        ShowThumbsThread thread = new ShowThumbsThread(setFirst);
        EventQueue.invokeLater(thread);
    }

    private class ShowThumbsThread
    extends Thread {
        private boolean iSetFirst = true;

        public ShowThumbsThread(boolean setFirst) {
            this.iSetFirst = setFirst;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Database database = Database.singleton();
            synchronized (database) {
                Thumbnail thumb2;
                LinkedList<PopupObject> sels = ThumbnailPanel.this.selections();
                ThumbnailPanel.this.removeAll();
                for (Thumbnail thumb2 : ThumbnailPanel.this.iThumbs) {
                    ThumbnailPanel.this.add(thumb2, true, false);
                }
                ThumbnailPanel.this.showItems();
                if (this.iSetFirst && ThumbnailPanel.this.numItems() > 0) {
                    ThumbnailPanel.this.selectFirstItem();
                } else if (sels.size() > 0 && (thumb2 = (Thumbnail)sels.getFirst()) != null) {
                    ThumbnailPanel.this.selectItem(thumb2.label());
                }
            }
        }
    }
}

