/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumgui;

import dialog.ConfirmDialog;
import filedialog.FileChooser;
import filedialog.FileChooserFilter;
import filedialog.FilePopupObject;
import java.awt.Frame;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import mlib.MAppMsg;
import mswing.ThumbnailImage;
import oroma.albumgui.AlbumBar;
import oroma.albumgui.AlbumPanel;
import oroma.albumgui.AlbumSelectionBox;
import oroma.albumgui.ExifInfoDialog;
import oroma.albumgui.ImagePrinter;
import oroma.albumgui.PicDisplay;
import oroma.albumgui.PicturePanel;
import oroma.albumgui.ThumbInfoDialog;
import oroma.albumgui.ThumbnailPanel;
import oroma.albumsgui.AlbumsPanel;
import oroma.albumsgui.DbInfoLabel;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import oroma.gui.Main;
import popup.PopupObject;
import popup.PopupPanel;
import swing.StatusBox;
import utilt.BinnedDb;
import utilt.Utility;

public class Thumbnail
implements PopupObject {
    private PicDisplay iPicDisp = null;
    public static ThumbnailImage DefaultThumbnail = null;
    private static final String OPEN = "Open";
    private static final String DELETE = "Delete";
    private static final String INFO = "Show Info.";
    private static final String EXIF = "Show EXIF";
    private static final String PRINT = "Print";
    private static final String MOVE = "Move";
    private static final String EDIT = "Edit";
    private static JPopupMenu ThumbMenu = null;
    private static JMenuItem DeleteItem = null;
    private static JMenuItem EditItem = null;
    private static JMenuItem OpenItem = null;
    private static JMenuItem ExifItem = null;
    private static JMenuItem MoveItem = null;
    private static ImageIcon MissingIcon = null;
    private static String MoveDir = null;

    private static void setup() {
        if (ThumbMenu == null) {
            ThumbMenu = new JPopupMenu();
            OpenItem = new JMenuItem(OPEN);
            OpenItem.setActionCommand(OPEN);
            ThumbMenu.add(OpenItem);
            DeleteItem = new JMenuItem(DELETE);
            DeleteItem.setActionCommand(DELETE);
            ThumbMenu.add(DeleteItem);
            JMenuItem item3 = new JMenuItem(INFO);
            item3.setActionCommand(INFO);
            ThumbMenu.add(item3);
            ExifItem = new JMenuItem(EXIF);
            ExifItem.setActionCommand(EXIF);
            ThumbMenu.add(ExifItem);
            JMenuItem item4 = new JMenuItem(PRINT);
            item4.setActionCommand(PRINT);
            ThumbMenu.add(item4);
            MoveItem = new JMenuItem(MOVE);
            MoveItem.setActionCommand(MOVE);
            ThumbMenu.add(MoveItem);
            EditItem = new JMenuItem(EDIT);
            EditItem.setActionCommand(EDIT);
            ThumbMenu.add(EditItem);
            MissingIcon = Main.singleton().iconMgr().icon("missing");
            DefaultThumbnail = new ThumbnailImage(Main.singleton().iconMgr().icon("missing"));
        }
    }

    public Thumbnail(PicDisplay disp) {
        this.iPicDisp = disp;
    }

    @Override
    public void handleEvent(PopupPanel panel, boolean doubleClicked, String menuCmd) {
        if (doubleClicked) {
            this.handleOpen();
        } else if (menuCmd.equals(DELETE)) {
            this.handleDelete();
        } else if (menuCmd.equals(OPEN)) {
            this.handleOpen();
        } else if (menuCmd.equals(INFO)) {
            this.handleInfo();
        } else if (menuCmd.equals(EXIF)) {
            this.handleExif();
        } else if (menuCmd.equals(PRINT)) {
            this.handlePrint();
        } else if (menuCmd.equals(MOVE)) {
            this.handleMove();
        } else {
            this.handleEdit();
        }
    }

    @Override
    public Icon thumb() {
        Icon icon = this.iPicDisp.thumb();
        if (icon == null) {
            icon = MissingIcon;
        }
        return icon;
    }

    @Override
    public String label() {
        String label = this.iPicDisp.info().dateStr();
        if (label.equals("no date")) {
            label = "";
        }
        return label;
    }

    @Override
    public String id() {
        return this.iPicDisp.info().fileName();
    }

    @Override
    public JPopupMenu menu() {
        Thumbnail.setup();
        boolean enable = true;
        DeleteItem.setEnabled(enable);
        ProgPreferences curPref = ProgPreferences.singleton();
        if (EditItem != null) {
            enable = curPref.editorProg().length() > 0;
            EditItem.setEnabled(enable);
        }
        OpenItem.setEnabled(true);
        String path = this.iPicDisp.info().picPathname().toLowerCase();
        if (path.endsWith(".jpg")) {
            ExifItem.setEnabled(true);
        } else {
            ExifItem.setEnabled(false);
        }
        return ThumbMenu;
    }

    public PicDisplay picDisp() {
        return this.iPicDisp;
    }

    public String toString() {
        ThumbnailImage image = this.iPicDisp.thumb();
        String str = this.iPicDisp.info() + ", " + image.getIconWidth() + ", " + image.getIconHeight();
        return str;
    }

    @Override
    public int compareTo(PopupObject obj) {
        int result = 0;
        if (obj != this) {
            result = -1;
            if (obj != null && obj.getClass() == Thumbnail.class) {
                Thumbnail thumb = (Thumbnail)obj;
                result = this.id().compareToIgnoreCase(thumb.id());
            }
        }
        return result;
    }

    @Override
    public boolean equalTo(Object obj) {
        return this.compareTo((Thumbnail)obj) == 0;
    }

    public void handleOpen() {
        if (this.hasImage()) {
            try {
                PicturePanel.singleton().showPic(this.iPicDisp, 1.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void handleDelete() {
        MAppMsg msg = BpmMsgs.get("delete_photo?");
        ProgPreferences pref = ProgPreferences.singleton();
        ImageIcon icon = Main.singleton().iconMgr().icon("confirmation");
        ConfirmDialog dialog = new ConfirmDialog((Frame)Main.singleton(), "Delete Confirmation", msg.format(), icon);
        dialog.setFont(pref.menuFont());
        dialog.center(0.4, 0.15);
        dialog.setResizable(true);
        if (dialog.display()) {
            try {
                Query curAlbum = AlbumSelectionBox.singleton().getCurAlbum();
                Database.singleton().deletePic(this.iPicDisp.info(), true);
                msg = BpmMsgs.get("deleted_photo");
                StatusBox.singleton().showMsg(msg.format(), msg.isError());
                DbInfoLabel.singleton().show();
                AlbumPanel panel = AlbumPanel.singleton();
                panel.clearPic();
                AlbumBar.singleton().enableZoom(false);
                ThumbnailPanel.singleton().remove(this);
                ThumbnailPanel.singleton().clearSelectedItems();
                AlbumBar.singleton().enableNextPrevPic(false);
                TreeSet<PicInfo> infos = Database.singleton().selectPicInfos(curAlbum);
                if (infos.size() == 0) {
                    curAlbum.setupThumb(null);
                } else {
                    Iterator iter = infos.iterator();
                    curAlbum.setupThumb((PicInfo)iter.next());
                }
                AlbumsPanel.singleton().showAlbums(false);
            }
            catch (Exception xcp) {
                msg = BpmMsgs.get("unable_delete_photo");
                StatusBox.singleton().queueShowMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
            }
        }
    }

    private void handleInfo() {
        if (this.hasImage()) {
            ThumbInfoDialog dialog = new ThumbInfoDialog((Frame)Main.singleton(), this.iPicDisp.info());
            dialog.setTitle("Photo Information");
            dialog.center(ThumbInfoDialog.horzFrac(), ThumbInfoDialog.vertFrac());
            dialog.setVisible(true);
        }
    }

    private void handleExif() {
        if (this.hasImage()) {
            try {
                ExifInfoDialog dialog = new ExifInfoDialog((Frame)Main.singleton(), this.iPicDisp.info());
                dialog.setTitle("EXIF Information");
                dialog.center(ExifInfoDialog.horzFrac(), ExifInfoDialog.vertFrac());
                dialog.setVisible(true);
            }
            catch (Exception xcp) {
                MAppMsg msg = BpmMsgs.get("unable_read_exif");
                StatusBox.singleton().showMsg(msg.format("none found"), msg.isError());
            }
        }
    }

    private void handleEdit() {
        if (this.hasImage()) {
            ProgPreferences curPref = ProgPreferences.singleton();
            String progPath = curPref.editorProg();
            if (progPath.trim().length() == 0) {
                MAppMsg msg = BpmMsgs.get("no_editor");
                StatusBox.singleton().showMsg(msg.format(), true);
            } else {
                String pathname = this.iPicDisp.info().picPathname();
                String cmd = String.valueOf(progPath) + " " + pathname;
                try {
                    MAppMsg msg = BpmMsgs.get("started_editor");
                    File file = new File(progPath);
                    StatusBox.singleton().showMsg(msg.format(file.getName()), msg.isError());
                    Runtime.getRuntime().exec(cmd);
                }
                catch (Exception xcp) {
                    MAppMsg msg = BpmMsgs.get("editor_error");
                    StatusBox.singleton().queueShowMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
                }
            }
        }
    }

    private void handlePrint() {
        if (this.hasImage()) {
            LinkedList<PicInfo> picInfos = new LinkedList<PicInfo>();
            picInfos.add(this.iPicDisp.info());
            ProgPreferences pref = ProgPreferences.singleton();
            ImagePrinter printer = new ImagePrinter(picInfos, pref.printInfoSizePc());
            printer.setName("BPM Printer");
            printer.start();
        }
    }

    private void handleMove() {
        if (this.hasImage()) {
            ProgPreferences pref = ProgPreferences.singleton();
            FileChooser chooser = new FileChooser(pref, new FolderFilter(), false, false, false, Main.singleton(), "Folder Selection", true, false);
            chooser.center(0.7, 0.7);
            chooser.setFont(pref.menuFont());
            chooser.addListener(new MoveHandler());
            chooser.setTitle("Select Folder");
            chooser.setMultipleSelect(false);
            if (MoveDir != null) {
                chooser.setCurDir(MoveDir);
            }
            chooser.setVisible(true);
        }
    }

    private boolean hasImage() {
        boolean has;
        boolean bl = has = this.iPicDisp.info().thumbnail() != DefaultThumbnail;
        if (!has) {
            MAppMsg msg = BpmMsgs.get("photo_not_found");
            StatusBox.singleton().queueShowMsg(msg.format(this.iPicDisp.info().fileName()), true);
        }
        return has;
    }

    private static class FolderFilter
    extends FileChooserFilter {
        public FolderFilter() {
            super(null, true, true, "folders");
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    private class MoveHandler
    implements FileChooser.Listener {
        private MoveHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void selected(FileChooser.Event event) {
            if (event.selections().size() > 0) {
                Database database = Database.singleton();
                synchronized (database) {
                    FilePopupObject selection = event.selections().getFirst();
                    PicInfo info = Thumbnail.this.iPicDisp.info();
                    info.assignFromBpmExifTag();
                    File picFile = new File(info.picPathname());
                    File newFile = new File(String.valueOf(selection.getName()) + File.separator + picFile.getName());
                    try {
                        Utility.copyFile(picFile, newFile);
                        picFile.delete();
                        info.setPicPathname(newFile.getAbsolutePath());
                        BinnedDb infosDb = Database.singleton().infosDb();
                        infosDb.put(info, true);
                        MAppMsg msg = BpmMsgs.get("moved_photo");
                        String text = msg.format(picFile.getName());
                        StatusBox.singleton().showMsg(text, false);
                        File file = new File(selection.getName());
                        MoveDir = file.getParentFile().getAbsolutePath();
                    }
                    catch (Exception xcp) {
                        MAppMsg msg = BpmMsgs.get("unable_move_photo");
                        String text = msg.format(Utility.xcpMsg(xcp));
                        StatusBox.singleton().showMsg(text, true);
                    }
                }
            }
        }

        @Override
        public void message(FileChooser.Event event) {
        }
    }
}

