/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumgui;

import dialog.CenteredDialog;
import dialog.DialogEvent;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import mlib.MAppMsg;
import oroma.albumgui.ImagePanel;
import oroma.albumgui.PicturePanel;
import oroma.albumgui.TagPanel;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.PicTag;
import oroma.db.ProgPreferences;
import oroma.gui.BpmMsgs;
import swing.StatusBox;
import utilt.Utility;

public class TagDialog
extends CenteredDialog {
    private TagPanel iTagPanel = null;
    private ImagePanel iImagePanel = null;
    private Point2D iPicPoint = null;

    public static float horzFrac() {
        return 0.5f;
    }

    public static float vertFrac() {
        int pixSize = 4 * ProgPreferences.singleton().menuFont().getSize() + 50;
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        float vertFrac = (float)pixSize / (float)screen.height;
        return vertFrac;
    }

    public TagDialog(Frame owner, TagPanel tagPanel, ImagePanel imagePanel, Point2D picPoint) {
        super(owner);
        this.iTagPanel = tagPanel;
        this.iImagePanel = imagePanel;
        this.iPicPoint = picPoint;
        this.setModal(false);
        this.addClientPanel(tagPanel);
        this.setFont(ProgPreferences.singleton().menuFont());
        this.setFocusComp(tagPanel.obtainFocusComp());
    }

    @Override
    public void accept(DialogEvent event) {
        if (this.iTagPanel.obtainText().length() == 0) {
            MAppMsg msg = BpmMsgs.get("tag_empty");
            StatusBox.singleton().showMsg(msg.format(), msg.isError());
        } else {
            PicTag tag = new PicTag(this.iTagPanel.obtainText(), (int)this.iPicPoint.getX(), (int)this.iPicPoint.getY());
            PicInfo info = PicturePanel.singleton().picDisplay().info();
            info.tags().add(tag);
            try {
                Database.singleton().putPic(info, true);
                MAppMsg msg = BpmMsgs.get("tag_added");
                StatusBox.singleton().showMsg(msg.format(), msg.isError());
            }
            catch (Exception xcp) {
                MAppMsg msg = BpmMsgs.get("unable_add_tag");
                StatusBox.singleton().showMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
            }
            this.dispose();
            this.iImagePanel.repaint();
        }
    }

    @Override
    public void cancel(DialogEvent event) {
        this.dispose();
        MAppMsg msg = BpmMsgs.get("edit_cancelled");
        StatusBox.singleton().showMsg(msg.format(), msg.isError());
    }

    @Override
    public void custom(int index, DialogEvent event) {
    }
}

