/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumgui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import mlib.MAppMsg;
import oroma.albumgui.AlbumBar;
import oroma.albumgui.AlbumPanel;
import oroma.albumgui.ImagePanel;
import oroma.albumgui.PicDisplay;
import oroma.albumgui.PicInfoSummary;
import oroma.albumgui.PictureAnnotation;
import oroma.albumgui.ThumbnailPanel;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import oroma.gui.BpmMsgs;
import oroma.picinfogui.PicInfoPanel;
import swing.ColorPanel;
import swing.DatePanel;
import swing.NestedSplitPanel;
import swing.StatusBox;
import swing.WheelComboBox;

public class PicturePanel
extends ColorPanel {
    private PicDisplay iPicDisp = null;
    private Image iImage = null;
    private JPanel iViewPanel = new ColorPanel();
    private ImagePanel iImagePanel = null;
    private JScrollBar iHorzBar = new JScrollBar(0);
    private JScrollBar iVertBar = new JScrollBar(1);
    private ScrollHandler iHandler = new ScrollHandler();
    private boolean iAddedHorzBar = false;
    private boolean iAddedVertBar = false;
    private boolean iHasHorzBar = false;
    private boolean iHasVertBar = false;
    private boolean iIgnoreBarAdjust = false;
    private double iZoom = 1.0;
    private double iImageFitScale = 0.0;
    private double iScale = 0.0;
    private double iImageX = 0.0;
    private double iImageY = 0.0;
    private double iCenteredImageX = 0.0;
    private double iCenteredImageY = 0.0;
    private double iPicWidth = 0.0;
    private double iPicHeight = 0.0;
    private double iImageWidth = 0.0;
    private double iImageHeight = 0.0;
    private double iViewPanelWidth = 0.0;
    private double iViewPanelHeight = 0.0;
    private double iZoomCenterXFrac = 0.0;
    private double iZoomCenterYFrac = 0.0;
    private double iMaxZoomCenterXFrac = 0.0;
    private double iMinZoomCenterXFrac = 0.0;
    private double iMaxZoomCenterYFrac = 0.0;
    private double iMinZoomCenterYFrac = 0.0;
    private double iImageXMin = 0.0;
    private double iImageXMax = 0.0;
    private double iImageYMin = 0.0;
    private double iImageYMax = 0.0;
    private boolean iTagsEnabled = false;
    private boolean iShowTags = false;
    private static final int SCROLLRANGE = 10000;
    private static final double ROUND = 0.5;
    private static final double MINZOOM = 0.05;
    private static final double MAXZOOM = 10.0;
    private static final double ZOOMADJUST = 0.002;
    private static PicturePanel Singleton = null;

    public static PicturePanel singleton() {
        if (Singleton == null) {
            Singleton = new PicturePanel();
        }
        return Singleton;
    }

    public boolean alignScrollers(boolean horz, double factor) {
        boolean scroll = false;
        if (horz && this.iHasHorzBar) {
            double orig = this.iZoomCenterXFrac;
            this.iZoomCenterXFrac += factor / this.iPicWidth;
            if (this.iZoomCenterXFrac < this.iMinZoomCenterXFrac) {
                this.iZoomCenterXFrac = this.iMinZoomCenterXFrac;
            } else if (this.iZoomCenterXFrac > this.iMaxZoomCenterXFrac) {
                this.iZoomCenterXFrac = this.iMaxZoomCenterXFrac;
            }
            this.calcFOV();
            this.posHorzScroller();
            scroll = Math.abs(orig - this.iZoomCenterXFrac) > 0.001;
        } else if (!horz && this.iHasVertBar) {
            double orig = this.iZoomCenterYFrac;
            this.iZoomCenterYFrac -= factor / this.iPicHeight;
            if (this.iZoomCenterYFrac < this.iMinZoomCenterYFrac) {
                this.iZoomCenterYFrac = this.iMinZoomCenterYFrac;
            } else if (this.iZoomCenterYFrac > this.iMaxZoomCenterYFrac) {
                this.iZoomCenterYFrac = this.iMaxZoomCenterYFrac;
            }
            this.calcFOV();
            this.posVertScroller();
            scroll = Math.abs(orig - this.iZoomCenterYFrac) > 0.001;
        }
        return scroll;
    }

    public double calcFitScale() {
        double factor;
        double fitScale = 1.0;
        int margin = ProgPreferences.singleton().imageMargin();
        this.iImageWidth = this.iImage.getWidth(null);
        double imageWidth = this.iImageWidth + (double)margin;
        this.iImageHeight = this.iImage.getHeight(null);
        double imageHeight = this.iImageHeight + (double)margin;
        this.iViewPanelWidth = this.iViewPanel.getSize().width;
        this.iViewPanelHeight = this.iViewPanel.getSize().height;
        if (imageHeight > this.iViewPanelHeight) {
            factor = this.iViewPanelHeight / imageHeight;
            imageWidth *= factor;
            fitScale *= factor;
        }
        if (imageWidth > this.iViewPanelWidth) {
            factor = this.iViewPanelWidth / imageWidth;
            fitScale *= factor;
        }
        return fitScale;
    }

    public void zoomIn(double factor) {
        double newZoom = this.iZoom * (1.0 + (double)ProgPreferences.singleton().zoomStepSize() * 0.01 * factor);
        if (newZoom < 10.0) {
            this.iZoom = newZoom;
            this.zoom();
            AlbumBar.singleton().enableZoomOut(true);
        } else {
            AlbumBar.singleton().enableZoomIn(false);
        }
    }

    public void zoomOut(double factor) {
        double newZoom = this.iZoom * (1.0 - (double)ProgPreferences.singleton().zoomStepSize() * 0.01 * factor);
        if (newZoom > 0.05) {
            this.iZoom = newZoom;
            this.zoom();
            AlbumBar.singleton().enableZoomIn(true);
        } else {
            AlbumBar.singleton().enableZoomOut(false);
        }
    }

    public void resize() {
        this.iZoom = 1.0;
        if (this.iPicDisp != null && this.iPicDisp.info().hasThumbnail()) {
            this.zoom();
        }
        AlbumBar.singleton().enableTags(true);
        AlbumBar.singleton().enableZoom(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.iPicDisp != null && this.iPicDisp.info().hasThumbnail()) {
            this.setupImageSizePos();
            this.iImagePanel.draw(this.iScale, this.iZoom, this.iImageX, this.iImageY, this.iPicWidth, this.iPicHeight);
        }
    }

    public void clear() {
        PicInfoPanel.singleton().setPicInfo(new PicInfo());
        PicInfoPanel.singleton().setEnabled(false);
        this.iPicDisp = null;
        this.iViewPanel.remove(this.iHorzBar);
        this.iViewPanel.remove(this.iVertBar);
        this.validate();
        this.iImagePanel.clear();
        this.repaint();
        PictureAnnotation.singleton().clear();
        PicInfoSummary.singleton().clear();
        PictureAnnotation.singleton().putIndicatorOn(false);
    }

    public PicDisplay picDisplay() {
        return this.iPicDisp;
    }

    public void setPicDisplay(PicDisplay picDisp) {
        this.iPicDisp = picDisp;
    }

    public void clear(Collection<PicInfo> picInfos) {
        if (this.iPicDisp != null) {
            Iterator<PicInfo> infos = picInfos.iterator();
            boolean cleared = false;
            while (!cleared && infos.hasNext()) {
                PicInfo info = infos.next();
                if (this.iPicDisp.info() != info) continue;
                this.clear();
                cleared = true;
            }
            this.iPicDisp = null;
        }
    }

    public void enableTags(boolean enable) {
        this.iTagsEnabled = enable;
        this.setTagFlag();
        this.iImagePanel.repaint();
    }

    public void showPic(PicDisplay disp, double zoom) throws Exception {
        if (this.iPicDisp != null) {
            this.iPicDisp.clean();
        }
        this.iPicDisp = disp;
        try {
            this.iImage = disp.image();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.iImage == null) {
            MAppMsg msg = BpmMsgs.get("photo_not_found");
            StatusBox.singleton().showMsg(msg.format(disp.info().picPathname()), true);
            this.clear();
        } else {
            String devPath = this.iPicDisp.info().picPathname();
            File file = new File(devPath);
            if (!file.exists()) {
                MAppMsg msg = BpmMsgs.get("photo_not_found");
                StatusBox.singleton().showMsg(msg.format(file.getName()), true);
                this.clear();
            } else {
                this.iZoom = zoom;
                PicDisplayer displayer = new PicDisplayer(devPath);
                displayer.run();
            }
        }
    }

    private PicturePanel() {
        this.setLayout(new BorderLayout());
        this.setBackground(ProgPreferences.singleton().panelBackColor());
        ColorPanel bottom = new ColorPanel();
        bottom.setLayout(new BorderLayout());
        bottom.add((Component)PicInfoSummary.singleton(), "North");
        bottom.add((Component)PictureAnnotation.singleton(), "South");
        this.add((Component)bottom, "South");
        this.iImagePanel = new ImagePanel();
        this.iImagePanel.setPicPanel(this);
        this.iViewPanel.setLayout(new BorderLayout());
        this.iViewPanel.add((Component)this.iImagePanel, "Center");
        this.add((Component)this.iViewPanel, "Center");
        this.iHorzBar.setMaximum(10000);
        this.iVertBar.setMaximum(10000);
        this.iHorzBar.setUnitIncrement(200);
        this.iVertBar.setUnitIncrement(200);
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        this.setMinimumSize(new Dimension((int)((double)screen.width * 0.1), 10));
        this.addComponentListener(new SizeListener());
        Singleton = this;
    }

    private double calcScrollX() {
        int horzVisible = this.iHorzBar.getVisibleAmount();
        double scrollX = (double)this.iHorzBar.getValue() / (double)(10000 - horzVisible);
        double scrollImageX = this.iImageXMax - scrollX * (this.iImageXMax - this.iImageXMin);
        return scrollImageX;
    }

    private double calcScrollY() {
        int vertVisible = this.iVertBar.getVisibleAmount();
        double scrollY = (double)this.iVertBar.getValue() / (double)(10000 - vertVisible);
        double scrollImageY = this.iImageYMax - scrollY * (this.iImageYMax - this.iImageYMin);
        return scrollImageY;
    }

    private void calcScaling() {
        this.iHorzBar.removeAdjustmentListener(this.iHandler);
        this.iVertBar.removeAdjustmentListener(this.iHandler);
        this.iImageFitScale = this.calcFitScale();
        this.iScale = this.iImageFitScale * this.iZoom;
        this.iPicWidth = this.iImageWidth * this.iScale;
        this.iPicHeight = this.iImageHeight * this.iScale;
        this.addScrollers();
        this.iImageFitScale = this.calcFitScale();
        this.iScale = this.iImageFitScale * this.iZoom;
        this.iPicWidth = this.iImageWidth * this.iScale;
        this.iPicHeight = this.iImageHeight * this.iScale;
        this.addScrollers();
    }

    private void addScrollers() {
        this.iAddedHorzBar = false;
        this.iAddedVertBar = false;
        this.iViewPanel.removeAll();
        this.iViewPanel.add((Component)this.iImagePanel, "Center");
        if (this.iPicWidth - this.iViewPanelWidth > 1.0) {
            this.iViewPanel.add((Component)this.iHorzBar, "South");
            if (this.iZoom <= 1.0) {
                this.iZoomCenterXFrac = 0.5;
            }
            this.iAddedHorzBar = true;
            this.iHasHorzBar = true;
        } else {
            this.iHasHorzBar = false;
            this.iZoomCenterXFrac = 0.5;
        }
        if (this.iPicHeight - this.iViewPanelHeight > 1.0) {
            this.iViewPanel.add((Component)this.iVertBar, "East");
            if (this.iZoom <= 1.0) {
                this.iZoomCenterYFrac = 0.5;
            }
            this.iAddedVertBar = true;
            this.iHasVertBar = true;
        } else {
            this.iHasVertBar = false;
            this.iZoomCenterYFrac = 0.5;
        }
        if (this.iAddedHorzBar || this.iAddedVertBar) {
            this.iViewPanel.validate();
        }
    }

    private void setupImageSizePos() {
        this.calcScaling();
        this.calcFOV();
        if (this.iZoom > 1.0) {
            this.setupScrollers();
            this.posHorzScroller();
            this.posVertScroller();
        }
    }

    private void calcFOV() {
        this.iCenteredImageX = 0.5 * (this.iViewPanelWidth - this.iPicWidth);
        this.iCenteredImageY = 0.5 * (this.iViewPanelHeight - this.iPicHeight);
        if (this.iZoom <= 1.0) {
            this.iZoomCenterXFrac = 0.5;
            this.iZoomCenterYFrac = 0.5;
            this.iImageX = this.iCenteredImageX;
            this.iImageY = this.iCenteredImageY;
        } else {
            double offsetX = this.iPicWidth * (this.iZoomCenterXFrac - 0.5);
            this.iImageX = this.iCenteredImageX - offsetX;
            this.iMaxZoomCenterXFrac = (this.iPicWidth - 0.5 * this.iViewPanelWidth) / this.iPicWidth;
            this.iMaxZoomCenterXFrac *= 1.002;
            offsetX = this.iPicWidth * (this.iMaxZoomCenterXFrac - 0.5);
            this.iImageXMin = this.iCenteredImageX - offsetX;
            this.iMinZoomCenterXFrac = 0.5 * this.iViewPanelWidth / this.iPicWidth;
            this.iMinZoomCenterXFrac *= 0.998;
            offsetX = this.iPicWidth * (this.iMinZoomCenterXFrac - 0.5);
            this.iImageXMax = this.iCenteredImageX - offsetX;
            double offsetY = this.iPicHeight * (this.iZoomCenterYFrac - 0.5);
            this.iImageY = this.iCenteredImageY - offsetY;
            this.iMaxZoomCenterYFrac = (this.iPicHeight - 0.5 * this.iViewPanelHeight) / this.iPicHeight;
            this.iMaxZoomCenterYFrac *= 1.002;
            offsetY = this.iPicHeight * (this.iMaxZoomCenterYFrac - 0.5);
            this.iImageYMin = this.iCenteredImageY - offsetY;
            this.iMinZoomCenterYFrac = 0.5 * this.iViewPanelHeight / this.iPicHeight;
            this.iMinZoomCenterYFrac *= 0.998;
            offsetY = this.iPicHeight * (this.iMinZoomCenterYFrac - 0.5);
            this.iImageYMax = this.iCenteredImageY - offsetY;
            this.shiftZoomInCenter();
        }
    }

    private void shiftZoomInCenter() {
        if (this.iMinZoomCenterXFrac < this.iMaxZoomCenterXFrac && this.iZoomCenterXFrac < this.iMinZoomCenterXFrac) {
            this.iZoomCenterXFrac = this.iMinZoomCenterXFrac;
            this.calcFOV();
        } else if (this.iMinZoomCenterXFrac < this.iMaxZoomCenterXFrac && this.iZoomCenterXFrac > this.iMaxZoomCenterXFrac) {
            this.iZoomCenterXFrac = this.iMaxZoomCenterXFrac;
            this.calcFOV();
        } else if (this.iMinZoomCenterYFrac < this.iMaxZoomCenterYFrac && this.iZoomCenterYFrac < this.iMinZoomCenterYFrac) {
            this.iZoomCenterYFrac = this.iMinZoomCenterYFrac;
            this.calcFOV();
        } else if (this.iMinZoomCenterYFrac < this.iMaxZoomCenterYFrac && this.iZoomCenterYFrac > this.iMaxZoomCenterYFrac) {
            this.iZoomCenterYFrac = this.iMaxZoomCenterYFrac;
            this.calcFOV();
        }
    }

    private void setupScrollers() {
        if (this.iAddedVertBar) {
            this.posVertScroller();
            this.iVertBar.addAdjustmentListener(this.iHandler);
            this.iAddedVertBar = false;
        }
        if (this.iAddedHorzBar) {
            this.posHorzScroller();
            this.iHorzBar.addAdjustmentListener(this.iHandler);
            this.iAddedHorzBar = false;
        }
    }

    private void posHorzScroller() {
        this.iIgnoreBarAdjust = true;
        this.iHorzBar.setValue(0);
        int horzVisible = (int)(this.iViewPanelWidth / this.iPicWidth * 10000.0 + 0.5);
        if (horzVisible > 10000) {
            horzVisible = 10000;
        }
        this.iHorzBar.setVisibleAmount(horzVisible);
        double centerFactor = (this.iZoomCenterXFrac - this.iMinZoomCenterXFrac) / (this.iMaxZoomCenterXFrac - this.iMinZoomCenterXFrac);
        int barValue = (int)(centerFactor * (double)(10000 - horzVisible));
        this.iHorzBar.setValue(barValue);
        this.iIgnoreBarAdjust = false;
    }

    private void posVertScroller() {
        this.iIgnoreBarAdjust = true;
        this.iVertBar.setValue(0);
        int vertVisible = (int)(this.iViewPanelHeight / this.iPicHeight * 10000.0 + 0.5);
        if (vertVisible > 10000) {
            vertVisible = 10000;
        }
        this.iVertBar.setVisibleAmount(vertVisible);
        double centerFactor = (this.iZoomCenterYFrac - this.iMinZoomCenterYFrac) / (this.iMaxZoomCenterYFrac - this.iMinZoomCenterYFrac);
        int barValue = (int)(centerFactor * (double)(10000 - vertVisible));
        this.iVertBar.setValue(barValue);
        this.iIgnoreBarAdjust = false;
    }

    private void zoom() {
        this.setupImageSizePos();
        int zoom = (int)(this.iZoom * 100.0 + 0.5);
        int scale = (int)(this.iScale * 100.0 + 0.5);
        PictureAnnotation.singleton().putZoom(zoom, scale);
        this.setTagFlag();
        this.iImagePanel.draw(this.iScale, this.iZoom, this.iImageX, this.iImageY, this.iPicWidth, this.iPicHeight);
    }

    private void setTagFlag() {
        int zoom = (int)(this.iZoom * 100.0 + 1.0E-4);
        this.iShowTags = this.iTagsEnabled && zoom == 100;
        AlbumBar.singleton().permitTags(this.iShowTags);
        this.iImagePanel.setShowTags(this.iShowTags);
    }

    private class PicDisplayer {
        private String iPicPath = null;

        public PicDisplayer(String picPath) {
            this.iPicPath = picPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Database database = Database.singleton();
            synchronized (database) {
                try {
                    PictureAnnotation.singleton().putIndicatorOn(true);
                    DatePanel.putBackColorAll(ProgPreferences.singleton().entryBackColor());
                    WheelComboBox.putBackColorAll(ProgPreferences.singleton().entryBackColor());
                    PicInfoPanel picInfoPanel = PicInfoPanel.singleton();
                    ThumbnailPanel thumbPanel = ThumbnailPanel.singleton();
                    PicInfo picInfo = PicturePanel.this.iPicDisp.info();
                    PictureAnnotation annot = PictureAnnotation.singleton();
                    annot.put(picInfo);
                    annot.putNumTags(picInfo.tags().size());
                    PicInfoSummary.singleton().put(picInfo);
                    picInfoPanel.setPicInfo(picInfo);
                    PicturePanel.this.setupImageSizePos();
                    PicturePanel.this.iImagePanel.draw(PicturePanel.this.iScale, PicturePanel.this.iZoom, PicturePanel.this.iImageX, PicturePanel.this.iImageY, PicturePanel.this.iPicWidth, PicturePanel.this.iPicHeight);
                    PicturePanel.this.iImagePanel.requestFocus();
                    MAppMsg msg = BpmMsgs.get("displayed_photo");
                    StatusBox.singleton().showMsg(msg.format(PicturePanel.this.iPicDisp.picNum(), thumbPanel.numThumbs()), msg.isError());
                    int scale = (int)(PicturePanel.this.iScale * 100.0 + 0.5);
                    annot.putZoom((int)(PicturePanel.this.iZoom * 100.0 + 0.5), scale);
                    AlbumBar.singleton().enableAddPics(true);
                    AlbumPanel.singleton().enablePics(true);
                    NestedSplitPanel panel = NestedSplitPanel.singleton();
                    if (panel.getShowedLeft()) {
                        thumbPanel.requestFocus();
                    }
                    PictureAnnotation.singleton().putIndicatorOn(false);
                }
                catch (Exception xcp) {
                    PicturePanel.this.clear();
                    MAppMsg msg = BpmMsgs.get("unable_display_photo");
                    StatusBox.singleton().queueShowMsg(msg.format(this.iPicPath), msg.isError());
                }
            }
        }
    }

    private class ScrollHandler
    implements AdjustmentListener {
        private ScrollHandler() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            if (!PicturePanel.this.iIgnoreBarAdjust) {
                if (PicturePanel.this.iHasHorzBar) {
                    PicturePanel.this.iImageX = PicturePanel.this.calcScrollX();
                    PicturePanel.this.iZoomCenterXFrac = (PicturePanel.this.iCenteredImageX - PicturePanel.this.iImageX) / PicturePanel.this.iPicWidth + 0.5;
                }
                if (PicturePanel.this.iHasVertBar) {
                    PicturePanel.this.iImageY = PicturePanel.this.calcScrollY();
                    PicturePanel.this.iZoomCenterYFrac = (PicturePanel.this.iCenteredImageY - PicturePanel.this.iImageY) / PicturePanel.this.iPicHeight + 0.5;
                }
                PicturePanel.this.iImagePanel.draw(PicturePanel.this.iImageFitScale * PicturePanel.this.iZoom, PicturePanel.this.iZoom, PicturePanel.this.iImageX, PicturePanel.this.iImageY, PicturePanel.this.iPicWidth, PicturePanel.this.iPicHeight);
            }
        }
    }

    public class SizeListener
    extends ComponentAdapter {
        @Override
        public void componentResized(ComponentEvent event) {
            if (PicturePanel.this.iPicDisp != null) {
                PicInfoSummary.singleton().put(PicturePanel.this.iPicDisp.info());
            }
        }
    }
}

