/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumgui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import oroma.albumgui.PicInfoSummary;
import oroma.db.ImageFileInfo;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import swing.ColorPanel;
import swing.Indicator;

public class PictureAnnotation
extends JPanel {
    private Indicator iIndicator = new Indicator();
    private Annotations iAnnots = null;
    private JLabel iFileName = new JLabel(" ");
    private JLabel iFileSize = new JLabel(" ");
    private JLabel iImageSize = new JLabel(" ");
    private JLabel iZoomFactor = new JLabel(" ");
    private JLabel iNumTags = new JLabel(" ");
    public static final String EMPTY = " ";
    private static final DecimalFormat FORMAT = new DecimalFormat("0.0");
    private static PictureAnnotation Singleton = new PictureAnnotation();

    public static PictureAnnotation singleton() {
        return Singleton;
    }

    private PictureAnnotation() {
        this.setLayout(new BorderLayout());
        this.iAnnots = new Annotations();
        this.enableInfoSummary(true);
        this.iFileName.setOpaque(true);
        this.iImageSize.setOpaque(true);
        this.iFileSize.setOpaque(true);
        this.iZoomFactor.setOpaque(true);
        this.iNumTags.setOpaque(true);
        ProgPreferences pref = ProgPreferences.singleton();
        this.putBackground(pref.panelBackColor());
        this.putForeground(pref.panelForeColor());
        this.putFont(pref.menuFont());
        Singleton = this;
    }

    public void clear() {
        this.iIndicator.putOn(false);
        this.iFileName.setText(EMPTY);
        this.iImageSize.setText(EMPTY);
        this.iFileSize.setText(EMPTY);
        this.iZoomFactor.setText(EMPTY);
        this.iNumTags.setText(EMPTY);
    }

    public void put(PicInfo picInfo) {
        ImageFileInfo fileInfo = picInfo.getFileInfo();
        this.iFileName.setText(picInfo.fileName());
        String size = String.valueOf(FORMAT.format(picInfo.resMp())) + " Mp ";
        this.iImageSize.setText(size);
        size = String.valueOf(fileInfo.getSizeKB()) + " KB";
        this.iFileSize.setText(size);
    }

    public void putIndicatorOn(boolean on) {
        this.iIndicator.putOn(on);
    }

    public void putZoom(int percent, int scale) {
        String size = percent + "(" + scale + ")%";
        this.iZoomFactor.setText(size);
    }

    public void putNumTags(int num) {
        String text = " tags";
        if (num == 1) {
            text = " tag";
        }
        this.iNumTags.setText(String.valueOf(num) + text);
    }

    private void enableInfoSummary(boolean enable) {
        this.removeAll();
        if (enable) {
            ColorPanel bottom = new ColorPanel();
            bottom.setLayout(new BorderLayout());
            bottom.add((Component)this.iIndicator, "West");
            bottom.add((Component)this.iAnnots, "Center");
            this.add((Component)bottom, "Center");
        } else {
            this.add((Component)this.iIndicator, "West");
            this.add((Component)this.iAnnots, "Center");
        }
        this.validate();
        this.repaint();
    }

    public void putForeground(Color color) {
        super.setForeground(color);
        this.iFileName.setForeground(color);
        this.iFileSize.setForeground(color);
        this.iImageSize.setForeground(color);
        this.iZoomFactor.setForeground(color);
        this.iNumTags.setForeground(color);
        PicInfoSummary.singleton().setForeground(color);
    }

    public void putBackground(Color color) {
        super.setBackground(color);
        this.iFileName.setBackground(color);
        this.iFileSize.setBackground(color);
        this.iImageSize.setBackground(color);
        this.iZoomFactor.setBackground(color);
        this.iNumTags.setBackground(color);
        PicInfoSummary.singleton().setBackground(color);
    }

    public void putFont(Font font) {
        this.iFileName.setFont(font);
        this.iFileSize.setFont(font);
        this.iImageSize.setFont(font);
        this.iZoomFactor.setFont(font);
        this.iNumTags.setFont(font);
        PicInfoSummary.singleton().setFont(font);
    }

    private class Annotations
    extends JPanel {
        Annotations() {
            Border border = BorderFactory.createEtchedBorder();
            PictureAnnotation.this.iFileName.setBorder(border);
            PictureAnnotation.this.iFileName.setToolTipText("File name");
            PictureAnnotation.this.iImageSize.setBorder(border);
            PictureAnnotation.this.iImageSize.setToolTipText("Photo size Mp");
            PictureAnnotation.this.iFileSize.setBorder(border);
            PictureAnnotation.this.iFileSize.setToolTipText("File size KB");
            PictureAnnotation.this.iZoomFactor.setBorder(border);
            PictureAnnotation.this.iZoomFactor.setToolTipText("View zoom factor");
            PictureAnnotation.this.iNumTags.setBorder(border);
            PictureAnnotation.this.iNumTags.setToolTipText("Photo tag count");
            PictureAnnotation.this.iFileName.setHorizontalAlignment(0);
            PictureAnnotation.this.iImageSize.setHorizontalAlignment(0);
            PictureAnnotation.this.iFileSize.setHorizontalAlignment(0);
            PictureAnnotation.this.iZoomFactor.setHorizontalAlignment(0);
            PictureAnnotation.this.iNumTags.setHorizontalAlignment(0);
            this.setLayout(new GridLayout(1, 0));
            this.add(PictureAnnotation.this.iFileName);
            this.add(PictureAnnotation.this.iFileSize);
            this.add(PictureAnnotation.this.iImageSize);
            this.add(PictureAnnotation.this.iZoomFactor);
            this.add(PictureAnnotation.this.iNumTags);
        }
    }
}

