/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumgui;

import dialog.ConfirmDialog;
import filedialog.FileChooser;
import filedialog.FilePopupObject;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import misc.BackThreadGroup;
import mlib.MAppMsg;
import oroma.albumgui.AlbumBar;
import oroma.albumgui.AlbumDisplayer;
import oroma.albumgui.AlbumPanel;
import oroma.albumgui.ImageChooserFilter;
import oroma.albumgui.PicDisplay;
import oroma.albumgui.ThumbnailPanel;
import oroma.albumgui.ThumbsPanel;
import oroma.albumsgui.DbInfoLabel;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import oroma.gui.Main;
import swing.StatusBox;
import utilt.ImageIOUtil;
import utilt.Utility;

public class PictureAdder {
    private Query iCurAlbum = null;
    private FileChooser.Event iEvent = null;
    private Collection<PicInfo> iPicInfos = null;
    private static AdderThread AdderThread = null;

    public static void halt() {
        if (AdderThread != null) {
            AdderThread.iHalt = true;
            try {
                while (!AdderThread.iDone) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            AdderThread = null;
        }
    }

    public PictureAdder(Query curAlbum, FileChooser.Event event) {
        this.iCurAlbum = curAlbum;
        this.iEvent = event;
    }

    public PictureAdder(Query curAlbum, Collection<PicInfo> picInfos) {
        this.iCurAlbum = curAlbum;
        this.iEvent = null;
        this.iPicInfos = picInfos;
    }

    private Collection<PicInfo> confirmAdd() {
        LinkedList<PicInfo> picInfos = new LinkedList<PicInfo>();
        if (this.obtainPicsToAdd(picInfos)) {
            ProgPreferences pref = ProgPreferences.singleton();
            MAppMsg msg = BpmMsgs.get("add_photos");
            ImageIcon icon = Main.singleton().iconMgr().icon("confirmation");
            ConfirmDialog dialog = new ConfirmDialog((Frame)Main.singleton(), "Add Confirmation", msg.format(Integer.toString(picInfos.size()), this.iCurAlbum.name()), icon);
            dialog.setFont(pref.menuFont());
            dialog.center(0.4, 0.15);
            dialog.setResizable(true);
            if (!dialog.display()) {
                picInfos.clear();
            }
        }
        return picInfos;
    }

    public boolean obtainPicsToAdd(LinkedList<PicInfo> picInfos) {
        boolean result = false;
        LinkedList<String> newFiles = null;
        newFiles = this.iEvent.selections().size() > 1 ? this.obtainMultipleFiles() : this.obtainFileOrDir();
        if (newFiles.size() > 0) {
            Collection<PicInfo> infos = this.iCurAlbum.buildPicInfos(newFiles);
            picInfos.addAll(infos);
            result = true;
        }
        return result;
    }

    private LinkedList<String> obtainMultipleFiles() {
        LinkedList<String> result = new LinkedList<String>();
        for (FilePopupObject file : this.iEvent.selections()) {
            if (file.getType() != 1) continue;
            result.add(file.getName());
        }
        return result;
    }

    private LinkedList<String> obtainFileOrDir() {
        LinkedList<String> result = new LinkedList<String>();
        FilePopupObject file = this.iEvent.selections().getFirst();
        if (file.getType() == 1) {
            result.add(file.getName());
        } else {
            File dir = new File(file.getName());
            File[] files = dir.listFiles();
            if (files == null) {
                MAppMsg msg = BpmMsgs.get("empty_folder");
                StatusBox.singleton().showMsg(msg.format(), msg.isError());
            } else {
                ProgPreferences pref = ProgPreferences.singleton();
                String[] picExts = ImageIOUtil.IMAGEEXTS;
                if (!pref.addPicExt().equals("All")) {
                    picExts = new String[]{"." + pref.addPicExt().toLowerCase()};
                }
                ImageChooserFilter filter = new ImageChooserFilter(picExts, false, true, "new image files");
                int i = 0;
                while (i < files.length) {
                    if (filter.accept(files[i])) {
                        result.add(files[i].getAbsolutePath());
                    }
                    ++i;
                }
                if (result.size() == 0) {
                    MAppMsg msg = BpmMsgs.get("no_new_photos");
                    StatusBox.singleton().showMsg(msg.format(), msg.isError());
                }
            }
        }
        return result;
    }

    public void process() {
        AlbumBar.singleton().enableAddPics(false);
        AlbumPanel.singleton().enableAlbumSelection(false);
        AlbumPanel.singleton().enableEdit(false);
        if (this.iEvent != null) {
            this.iPicInfos = this.confirmAdd();
        }
        if (this.iPicInfos.size() > 0) {
            MAppMsg msg = BpmMsgs.get("adding_photos");
            StatusBox.singleton().showMsg(msg.format(this.iPicInfos.size()), false);
            AdderThread adder = new AdderThread();
            adder.setName("PictureAdder");
            adder.start();
        } else {
            AlbumPanel.singleton().enableAlbumSelection(true);
            AlbumBar.singleton().enableAddPics(true);
        }
    }

    private class AdderThread
    extends Thread {
        private boolean iHalt;
        private boolean iDone;

        AdderThread() {
            super((ThreadGroup)BackThreadGroup.group(), "PictureAdder");
            this.iHalt = false;
            this.iDone = false;
            AdderThread = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Database database = Database.singleton();
            synchronized (database) {
                AlbumPanel.singleton().setAddingPics(true);
                AlbumBar.singleton().enableAddPics(false);
                ThumbnailPanel thumbPanel = ThumbnailPanel.singleton();
                ThumbsPanel thumbsPanel = ThumbsPanel.singleton();
                thumbPanel.enablePopupMenus(false);
                thumbsPanel.putPercentDone(0);
                thumbsPanel.putIndicatorOn(true);
                thumbPanel.setCursor(Cursor.getPredefinedCursor(3));
                int numPics = PictureAdder.this.iPicInfos.size();
                int added = 0;
                Iterator iter = PictureAdder.this.iPicInfos.iterator();
                while (iter.hasNext() && !this.iHalt) {
                    PicInfo info = (PicInfo)iter.next();
                    try {
                        info.setup();
                        Database.singleton().putPic(info, true);
                        int percent = (int)(100.0 * (double)(++added) / (double)numPics + 0.5);
                        PicDisplay disp = new PicDisplay(info);
                        thumbPanel.addPic(disp);
                        ThumbsPanel.singleton().putPercentDone(percent);
                    }
                    catch (Exception xcp) {
                        MAppMsg msg = BpmMsgs.get("unable_add_photo");
                        StatusBox.singleton().queueShowMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
                    }
                }
                DbInfoLabel.singleton().show();
                thumbPanel.showThumbs(false);
                MAppMsg msg = BpmMsgs.get("added_photos");
                StatusBox.singleton().queueShowMsg(msg.format(added, numPics), false);
                AlbumBar.singleton().enableAddPics(true);
                thumbPanel.setCursor(Cursor.getDefaultCursor());
                thumbsPanel.putPercentDone(0);
                AlbumDisplayer displayer = new AlbumDisplayer(PictureAdder.this.iCurAlbum);
                EventQueue.invokeLater(displayer);
                this.iDone = true;
            }
        }
    }
}

