/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumgui;

import dialog.ConfirmDialog;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import mlib.MAppMsg;
import oroma.albumgui.PicDisplay;
import oroma.albumgui.PicturePanel;
import oroma.albumgui.TagDialog;
import oroma.albumgui.TagPanel;
import oroma.albumgui.TagRect;
import oroma.albumgui.Thumbnail;
import oroma.albumgui.ThumbnailPanel;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.PicTag;
import oroma.db.ProgPreferences;
import oroma.gui.BpmMsgs;
import oroma.gui.Main;
import popup.PopupObject;
import popup.PopupPanel;
import swing.ColorPanel;
import swing.StatusBox;
import utilt.Utility;

public class ImagePanel
extends ColorPanel {
    private PopupHandler iPopupHandler = new PopupHandler();
    private Point2D iMousePoint = null;
    private LinkedList<TagRect> iTagRects = new LinkedList();
    private PicturePanel iPicPanel = null;
    private PicTag iMovingTag = null;
    private double iScale = 0.0;
    private double iZoom = 0.0;
    private double iX = 0.0;
    private double iY = 0.0;
    private double iPicWidth = 0.0;
    private double iPicHeight = 0.0;
    private Rectangle2D iImageRect = null;
    private Rectangle2D iTagsRect = null;
    private AffineTransform iTransform = null;
    private JPopupMenu iImageMenu = null;
    private boolean iShowTags = false;
    private JMenuItem iAddTagItem = new JMenuItem("Add tag");
    private JMenuItem iDeleteTagItem = new JMenuItem("Delete tag");
    private JMenuItem iResizeItem = new JMenuItem("Resize");
    private JMenuItem iZoominItem = new JMenuItem("Zoom in");
    private JMenuItem iZoomoutItem = new JMenuItem("Zoom out");
    private static final int NUMTEXTELLIPSES = 3;
    private static final int TAGSMARGIN = 10;
    private static final int NOBACKRGBVALUE = 1;
    private static final double WHEELZOOMFACTOR = 0.5;
    private static final double REFSCROLLFACTOR = 30.0;

    public ImagePanel() {
        this.iImageMenu = new JPopupMenu();
        this.setBackground(ProgPreferences.singleton().panelBackColor());
        AddTagHandler addTagHandler = new AddTagHandler();
        DeleteTagHandler deleteTagHandler = new DeleteTagHandler();
        ZoomHandler zoomHandler = new ZoomHandler();
        this.iResizeItem.addActionListener(zoomHandler);
        this.iImageMenu.add(this.iResizeItem);
        this.iZoominItem.addActionListener(zoomHandler);
        this.iImageMenu.add(this.iZoominItem);
        this.iZoomoutItem.addActionListener(zoomHandler);
        this.iImageMenu.add(this.iZoomoutItem);
        this.iImageMenu.add(this.iAddTagItem);
        this.iAddTagItem.addActionListener(addTagHandler);
        this.iImageMenu.add(this.iDeleteTagItem);
        this.iDeleteTagItem.addActionListener(deleteTagHandler);
        this.setupMenuItems();
        this.addMouseListener(this.iPopupHandler);
        this.addMouseWheelListener(new WheelHandler());
        this.addKeyListener(new KeyHandler());
        this.addMouseListener(new ResizeHandler());
    }

    private TagRect calcTagRect(FontRenderContext context, Point2D tagMousePoint, String text, int tagSize) {
        double maxCentered;
        double tagRectX = 0.0;
        double tagRectY = 0.0;
        Rectangle2D bounds = ProgPreferences.singleton().menuFont().getStringBounds(text, context);
        double tagRectHeight = bounds.getHeight() + 4.0;
        double tagRectWidth = bounds.getWidth();
        double lowestTagBelow = this.iPicHeight - (double)((int)(tagRectHeight * 3.0));
        Point2D tagRectPoint = this.convertMouseToRectPoint(tagMousePoint);
        tagRectY = tagRectPoint.getY() > lowestTagBelow ? tagRectPoint.getY() - tagRectHeight : tagRectPoint.getY() + (double)tagSize;
        double picCenter = this.getSize().width / 2;
        if (tagMousePoint.getX() > picCenter) {
            maxCentered = 2.0 * (this.iPicWidth - tagRectPoint.getX());
            if (maxCentered >= tagRectWidth) {
                tagRectX = tagRectPoint.getX() - tagRectWidth / 2.0;
            } else {
                tagRectX = this.iPicWidth - tagRectWidth;
                if (tagRectX < 0.0) {
                    tagRectX = 0.0;
                }
            }
        } else {
            maxCentered = tagRectPoint.getX() * 2.0;
            tagRectX = maxCentered >= tagRectWidth ? tagRectPoint.getX() - tagRectWidth / 2.0 : 0.0;
        }
        Point2D tagPoint = this.convertRectToMousePoint(new Point2D.Double(tagRectX, tagRectY));
        TagRect tagRect = new TagRect(tagPoint.getX(), tagPoint.getY(), tagRectWidth, tagRectHeight);
        return tagRect;
    }

    public void clear() {
        this.iTagRects.clear();
        this.repaint();
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    private TagRect clickedTagRect(Point2D mousePoint) {
        TagRect rect = null;
        for (TagRect aRect : this.iTagRects) {
            if (!aRect.contains(mousePoint.getX(), mousePoint.getY())) continue;
            rect = aRect;
            break;
        }
        return rect;
    }

    private Point2D convertImageToMousePoint(Point2D image) {
        double dispX = this.iScale * image.getX() + this.iX;
        double dispY = this.iScale * image.getY() + this.iY;
        return new Point2D.Double(dispX, dispY);
    }

    private Point2D convertMouseToImagePoint(Point2D mouse) {
        double imageX = (mouse.getX() - this.iX) / this.iScale;
        double imageY = (mouse.getY() - this.iY) / this.iScale;
        return new Point2D.Double(imageX, imageY);
    }

    private Point2D convertMouseToRectPoint(Point2D mouse) {
        return new Point2D.Double(mouse.getX() - this.iImageRect.getX(), mouse.getY() - this.iImageRect.getY());
    }

    private Point2D convertRectToMousePoint(Point2D mouse) {
        return new Point2D.Double(mouse.getX() + this.iImageRect.getX(), mouse.getY() + this.iImageRect.getY());
    }

    public void draw(double scale, double zoom, double x, double y, double picWidth, double picHeight) {
        this.iScale = scale;
        this.iZoom = zoom;
        this.iX = x;
        this.iY = y;
        this.iPicWidth = picWidth;
        this.iPicHeight = picHeight;
        this.iTagRects.clear();
        this.iTransform = AffineTransform.getTranslateInstance(this.iX, this.iY);
        AffineTransform scaleTrans = AffineTransform.getScaleInstance(this.iScale, this.iScale);
        this.iTransform.concatenate(scaleTrans);
        int picLeft = (int)(((double)this.getSize().width - this.iPicWidth) * 0.5);
        int picTop = (int)(((double)this.getSize().height - this.iPicHeight) * 0.5);
        int picRight = this.getSize().width - picLeft;
        int picBottom = this.getSize().height - picTop;
        this.iImageRect = new Rectangle2D.Double(picLeft, picTop, picRight - picLeft, picBottom - picTop);
        this.iTagsRect = new Rectangle2D.Double(picLeft + 10, picTop + 10, picRight - picLeft - 20, picBottom - picTop - 20);
        this.iMovingTag = null;
        this.setCursor(Cursor.getDefaultCursor());
        this.repaint();
    }

    public void drawPicTags(Graphics g, PicInfo info) {
        this.iMovingTag = null;
        this.iTagRects.clear();
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(ProgPreferences.singleton().tagMarkerColor());
        g2.setFont(ProgPreferences.singleton().menuFont());
        FontRenderContext context = g2.getFontRenderContext();
        LinkedList<PicTag> tags = info.tags();
        for (PicTag tag : tags) {
            this.drawTag(g2, context, tag);
        }
    }

    private void drawTag(Graphics2D g2, FontRenderContext context, PicTag tag) {
        ProgPreferences pref = ProgPreferences.singleton();
        int tagSize = pref.tagMarkerSize();
        Point2D.Double tagImagePoint = new Point2D.Double(tag.getX() - tagSize / 2, tag.getY() - tagSize / 2);
        Point2D tagMousePoint = this.convertImageToMousePoint(tagImagePoint);
        Ellipse2D.Double ellipse = new Ellipse2D.Double(tagMousePoint.getX(), tagMousePoint.getY(), tagSize, tagSize);
        g2.setPaint(pref.tagMarkerColor());
        g2.fill(ellipse);
        String text = this.obtainTagText(g2, context, tag);
        TagRect tagRect = this.calcTagRect(context, tagMousePoint, text, tagSize);
        tagRect.setPicTag(tag);
        this.iTagRects.add(tagRect);
        Color back = pref.tagBackColor();
        if (back.getRed() != 1 || back.getGreen() != 1 || back.getBlue() != 1) {
            g2.setPaint(pref.tagBackColor());
            g2.fill(tagRect);
            g2.setPaint(SystemColor.controlText);
            g2.draw(tagRect);
        }
        g2.setPaint(pref.tagMarkerColor());
        int baseline = (int)(tagRect.getY() + tagRect.getHeight() * 0.75);
        g2.drawString(text, (int)tagRect.getX(), baseline);
    }

    private String obtainTagText(Graphics2D g2, FontRenderContext context, PicTag tag) {
        String text = null;
        boolean truncated = false;
        int endIndex = tag.getText().length();
        double maxWidth = this.iPicWidth;
        while (endIndex > 1) {
            text = " " + tag.getText().substring(0, endIndex) + " ";
            Rectangle2D bounds = g2.getFont().getStringBounds(text, context);
            double width = bounds.getWidth();
            if (width < maxWidth) break;
            --endIndex;
            truncated = true;
        }
        if (truncated && text != null) {
            endIndex = text.length() - 1;
            text = text.substring(0, endIndex - 3);
            int i = 0;
            while (i < 3) {
                text = String.valueOf(text) + '.';
                ++i;
            }
            text = String.valueOf(text) + ' ';
        }
        return text;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.paintComponent(g2);
        PicDisplay picDisp = PicturePanel.singleton().picDisplay();
        try {
            if (picDisp != null && picDisp.image() != null) {
                Image image = picDisp.image();
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2.drawImage(image, this.iTransform, null);
                if (this.iShowTags) {
                    this.drawPicTags(g, picDisp.info());
                }
            } else {
                Dimension size = this.getSize();
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size.width, size.height);
                g2.setPaint(this.getBackground());
                g2.fill(rect);
            }
        }
        catch (Exception xcp) {
            MAppMsg msg = BpmMsgs.get("unable_display_photo");
            StatusBox.singleton().queueShowMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
        }
    }

    public void setPicPanel(PicturePanel newPicPanel) {
        this.iPicPanel = newPicPanel;
    }

    public void setShowTags(boolean show) {
        this.iShowTags = show;
    }

    private void setupMenuItems() {
        MenuElement[] eles = this.iImageMenu.getSubElements();
        int i = 0;
        while (i < eles.length) {
            if (eles[i] instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)eles[i];
                item.setBackground(SystemColor.control);
                item.setForeground(SystemColor.controlText);
                item.setFont(ProgPreferences.singleton().menuFont());
            }
            ++i;
        }
    }

    private void setupTagMenu(MouseEvent event) {
        this.iImageMenu.remove(this.iAddTagItem);
        this.iImageMenu.remove(this.iDeleteTagItem);
        int zoom = (int)(this.iZoom * 100.0 + 0.5);
        if (zoom == 100 && this.iShowTags) {
            this.iAddTagItem.setEnabled(true);
            this.iImageMenu.add(this.iAddTagItem);
            this.iDeleteTagItem.setEnabled(true);
            this.iImageMenu.add(this.iDeleteTagItem);
            this.iMousePoint = new Point2D.Float(event.getX(), event.getY());
            if (this.iTagsRect.contains(this.iMousePoint)) {
                boolean deleteOnly;
                PicInfo info = PicturePanel.singleton().picDisplay().info();
                Point2D mouseImagePoint = this.convertMouseToImagePoint(this.iMousePoint);
                boolean bl = deleteOnly = this.clickedTagRect(this.iMousePoint) != null;
                if (!deleteOnly) {
                    PicTag tag = PicTag.find(info.tags(), (int)mouseImagePoint.getX(), (int)mouseImagePoint.getY());
                    boolean bl2 = deleteOnly = tag != null;
                }
                if (deleteOnly) {
                    this.iDeleteTagItem.setEnabled(true);
                } else {
                    this.iAddTagItem.setEnabled(true);
                }
            }
        }
    }

    private class AddTagHandler
    implements ActionListener {
        private AddTagHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ImagePanel.this.iPopupHandler.clearMove();
            Point2D tagPoint = ImagePanel.this.convertMouseToImagePoint(ImagePanel.this.iMousePoint);
            TagDialog dialog = new TagDialog((Frame)Main.singleton(), new TagPanel(), ImagePanel.this, tagPoint);
            dialog.setTitle("Add Tag");
            dialog.center(TagDialog.horzFrac(), TagDialog.vertFrac());
            dialog.setVisible(true);
        }
    }

    private class DeleteTagHandler
    implements ActionListener {
        private DeleteTagHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ImagePanel.this.iPopupHandler.clearMove();
            PicInfo info = PicturePanel.singleton().picDisplay().info();
            Point2D mouseImagePoint = ImagePanel.this.convertMouseToImagePoint(ImagePanel.this.iMousePoint);
            Point2D mouseDispPoint = ImagePanel.this.convertImageToMousePoint(mouseImagePoint);
            PicTag tag = null;
            TagRect clickedRect = ImagePanel.this.clickedTagRect(mouseDispPoint);
            tag = clickedRect != null ? clickedRect.getPicTag() : PicTag.find(info.tags(), (int)mouseImagePoint.getX(), (int)mouseImagePoint.getY());
            if (tag == null) {
                MAppMsg msg = BpmMsgs.get("unable_delete_tag");
                StatusBox.singleton().showMsg(msg.format("tag not found"), msg.isError());
            } else {
                MAppMsg msg = BpmMsgs.get("delete_tag?");
                ProgPreferences pref = ProgPreferences.singleton();
                ImageIcon icon = Main.singleton().iconMgr().icon("confirmation");
                ConfirmDialog dialog = new ConfirmDialog((Frame)Main.singleton(), "Delete Confirmation", msg.format(tag.getText()), icon);
                dialog.setFont(pref.menuFont());
                if (dialog.display()) {
                    this.removePicTag(tag);
                    info.tags().remove(tag);
                    try {
                        Database.singleton().putPic(info, true);
                    }
                    catch (Exception xcp) {
                        msg = BpmMsgs.get("unable_delete_tag");
                        StatusBox.singleton().showMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
                    }
                    dialog.dispose();
                    ImagePanel.this.repaint();
                }
            }
        }

        public void removePicTag(PicTag tag) {
            boolean done = false;
            Iterator iter = ImagePanel.this.iTagRects.iterator();
            while (!done && iter.hasNext()) {
                TagRect aRect = (TagRect)iter.next();
                if (aRect.getPicTag() != tag) continue;
                iter.remove();
                done = true;
            }
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 32) {
                ThumbnailPanel.singleton().selectNextItem(true);
                LinkedList<PopupObject> selections = ThumbnailPanel.singleton().selections();
                Thumbnail thumb = (Thumbnail)selections.getFirst();
                if (thumb != null) {
                    thumb.handleOpen();
                }
            }
        }
    }

    private class PopupHandler
    extends MouseAdapter {
        private PopupHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (PicturePanel.singleton().picDisplay() != null) {
                int mods = event.getModifiers();
                if ((mods & PopupPanel.obtainPopupButtonMask()) > 0) {
                    if (ImagePanel.this.iMovingTag != null) {
                        this.clearMove();
                    }
                    ImagePanel.this.setupTagMenu(event);
                    ImagePanel.this.iImageMenu.show(ImagePanel.this, event.getX(), event.getY());
                } else if (event.getClickCount() > 1) {
                    if (ImagePanel.this.iMovingTag != null) {
                        this.clearMove();
                    }
                    if ((mods & 0x10) > 0 && (mods & 2) > 0) {
                        ImagePanel.this.iPicPanel.zoomOut(1.0);
                    } else if ((mods & 0x10) > 0) {
                        ImagePanel.this.iPicPanel.zoomIn(1.0);
                    }
                } else {
                    this.handleTagMove(event);
                }
            }
        }

        public void clearMove() {
            ImagePanel.this.iMovingTag = null;
            ImagePanel.this.setCursor(Cursor.getDefaultCursor());
        }

        public void handleTagMove(MouseEvent event) {
            ImagePanel.this.iMousePoint = new Point2D.Float(event.getX(), event.getY());
            if (ImagePanel.this.iMovingTag == null) {
                Point2D mouseImagePoint = ImagePanel.this.convertMouseToImagePoint(ImagePanel.this.iMousePoint);
                Point2D mouseDispPoint = ImagePanel.this.convertImageToMousePoint(mouseImagePoint);
                TagRect rect = ImagePanel.this.clickedTagRect(mouseDispPoint);
                if (rect != null) {
                    ImagePanel.this.iMovingTag = rect.getPicTag();
                    ImagePanel.this.setCursor(Cursor.getPredefinedCursor(13));
                }
            } else {
                ImagePanel.this.setCursor(Cursor.getDefaultCursor());
                if (!ImagePanel.this.iTagsRect.contains(ImagePanel.this.iMousePoint)) {
                    MAppMsg msg = BpmMsgs.get("tag_pos_reqd");
                    StatusBox.singleton().showMsg(msg.format(), msg.isError());
                } else {
                    Point2D tagPoint = ImagePanel.this.convertMouseToImagePoint(ImagePanel.this.iMousePoint);
                    ImagePanel.this.iMovingTag.setX((int)tagPoint.getX());
                    ImagePanel.this.iMovingTag.setY((int)tagPoint.getY());
                    try {
                        Database.singleton().putPic(PicturePanel.singleton().picDisplay().info(), true);
                        MAppMsg msg = BpmMsgs.get("tag_moved");
                        StatusBox.singleton().showMsg(msg.format(), msg.isError());
                        ImagePanel.this.repaint();
                    }
                    catch (Exception xcp) {
                        MAppMsg msg = BpmMsgs.get("unable_move_tag");
                        StatusBox.singleton().showMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
                    }
                }
                ImagePanel.this.iMovingTag = null;
            }
        }
    }

    private class ResizeHandler
    extends MouseAdapter {
        private ResizeHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (ImagePanel.this.iMovingTag == null) {
                ImagePanel.this.iPicPanel.resize();
            }
        }
    }

    private class WheelHandler
    implements MouseWheelListener {
        private WheelHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            if (PicturePanel.singleton().picDisplay() != null) {
                Toolkit tKit = Toolkit.getDefaultToolkit();
                Dimension screen = tKit.getScreenSize();
                double pFactor = 1.0 * (double)ImagePanel.this.getSize().width / (double)screen.width;
                double scrollFactor = pFactor * 30.0;
                if ((event.getModifiers() & 1) > 0) {
                    this.scrollVert(event, scrollFactor);
                } else if ((event.getModifiers() & 2) > 0) {
                    this.scrollHorz(event, scrollFactor);
                } else if (event.getWheelRotation() < 0) {
                    ImagePanel.this.iPicPanel.zoomIn(0.5);
                } else {
                    ImagePanel.this.iPicPanel.zoomOut(0.5);
                }
            }
        }

        private void scrollHorz(MouseWheelEvent event, double factor) {
            double origX = ImagePanel.this.iX;
            if (event.getWheelRotation() < 0) {
                ImagePanel imagePanel = ImagePanel.this;
                imagePanel.iX = imagePanel.iX - factor;
            } else {
                ImagePanel imagePanel = ImagePanel.this;
                imagePanel.iX = imagePanel.iX + factor;
            }
            double change = origX - ImagePanel.this.iX;
            if (ImagePanel.this.iPicPanel.alignScrollers(true, change)) {
                ImagePanel.this.draw(ImagePanel.this.iScale, ImagePanel.this.iZoom, ImagePanel.this.iX, ImagePanel.this.iY, ImagePanel.this.iPicWidth, ImagePanel.this.iPicHeight);
            } else {
                ImagePanel.this.iX = origX;
            }
        }

        private void scrollVert(MouseWheelEvent event, double factor) {
            double origY = ImagePanel.this.iY;
            if (event.getWheelRotation() < 0) {
                ImagePanel imagePanel = ImagePanel.this;
                imagePanel.iY = imagePanel.iY + factor;
            } else {
                ImagePanel imagePanel = ImagePanel.this;
                imagePanel.iY = imagePanel.iY - factor;
            }
            double change = ImagePanel.this.iY - origY;
            if (ImagePanel.this.iPicPanel.alignScrollers(false, change)) {
                ImagePanel.this.draw(ImagePanel.this.iScale, ImagePanel.this.iZoom, ImagePanel.this.iX, ImagePanel.this.iY, ImagePanel.this.iPicWidth, ImagePanel.this.iPicHeight);
            } else {
                ImagePanel.this.iY = origY;
            }
        }
    }

    private class ZoomHandler
    implements ActionListener {
        private ZoomHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == ImagePanel.this.iResizeItem) {
                ImagePanel.this.iPicPanel.resize();
            } else if (event.getSource() == ImagePanel.this.iZoominItem) {
                ImagePanel.this.iPicPanel.zoomIn(1.0);
            } else {
                ImagePanel.this.iPicPanel.zoomOut(1.0);
            }
        }
    }
}

