/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumgui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import mlib.MAppMsg;
import mswing.WheelComboBoxDb;
import oroma.albumgui.AlbumBar;
import oroma.albumgui.AlbumPanel;
import oroma.albumsgui.AlbumsPanel;
import oroma.db.Database;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import oroma.gui.Main;
import swing.StatusBox;
import swing.SwingProgram;
import swing.WheelComboBox;

public class AlbumSelectionBox
extends WheelComboBox {
    private Query iCurAlbum = null;
    private boolean iFillPics = true;
    private ActionHandler iHandler = new ActionHandler();
    private ImageIcon iAlbumIcon = null;
    private static AlbumSelectionBox Singleton = null;

    public static AlbumSelectionBox singleton() {
        if (Singleton == null) {
            Singleton = new AlbumSelectionBox();
            Singleton.removeFromList();
            Singleton.setBackground(ProgPreferences.singleton().headerBackColor());
        }
        return Singleton;
    }

    private AlbumSelectionBox() {
        this.setEnabled(true);
        this.setAcceptEmpty(false);
        this.addActionListener(this.iHandler);
        this.iAlbumIcon = Main.singleton().iconMgr().icon("album");
        this.setRenderer(new Renderer());
        this.setBorder(SwingProgram.STDBORDER);
        Singleton = this;
        WheelComboBoxDb db = Database.singleton().comboDb("album");
        this.setDb(db, false);
        Database.singleton().addListener(new DbHandler());
        this.setBackground(ProgPreferences.singleton().entryBackColor());
        this.setEnabled(true);
        this.setToolTipText("Album Selector");
        ProgPreferences pref = ProgPreferences.singleton();
        this.setFont(pref.menuFont());
    }

    public boolean addAlbum(String name) {
        boolean added = false;
        this.iFillPics = false;
        this.addItem(name);
        this.setSelectedItem(name);
        this.setEnabled(true);
        this.iFillPics = true;
        return added;
    }

    public Query getCurAlbum() {
        return this.iCurAlbum;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String selection = (String)AlbumSelectionBox.this.getSelectedItem();
            if (selection != null) {
                try {
                    AlbumSelectionBox.this.iCurAlbum = Database.singleton().query(selection, true);
                    AlbumSelectionBox.this.addItem(AlbumSelectionBox.this.iCurAlbum.name());
                    if (AlbumSelectionBox.this.iFillPics) {
                        AlbumsPanel.singleton().selectAlbum(AlbumSelectionBox.this.iCurAlbum.name());
                        AlbumSelectionBox.this.setEnabled(false);
                        AlbumBar.singleton().fireFillPics();
                    }
                }
                catch (Exception xcp) {
                    AlbumSelectionBox.this.removeItem(selection);
                    MAppMsg msg = BpmMsgs.get("album_not_found");
                    StatusBox.singleton().showMsg(msg.format(selection), msg.isError());
                }
            }
        }
    }

    private class DbHandler
    implements Database.Listener {
        private DbHandler() {
        }

        @Override
        public void queryAdded(Database.Event event) {
            AlbumSelectionBox.this.addAlbum(event.getParm());
        }

        @Override
        public void queryDeleted(Database.Event event) {
            if (AlbumSelectionBox.this.iCurAlbum != null && event.getParm().equals(AlbumSelectionBox.this.iCurAlbum.name())) {
                AlbumPanel.singleton().clear();
            }
            AlbumSelectionBox.this.removeItem(event.getParm());
        }

        @Override
        public void picAdded(Database.Event event) {
        }

        @Override
        public void picDeleted(Database.Event event) {
        }
    }

    private class Renderer
    implements ListCellRenderer<Object> {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = new JLabel((String)value);
            label.setOpaque(true);
            label.setHorizontalTextPosition(4);
            label.setIcon(AlbumSelectionBox.this.iAlbumIcon);
            ProgPreferences pref = ProgPreferences.singleton();
            label.setFont(pref.menuFont());
            label.setBackground(pref.panelBackColor());
            label.setForeground(pref.panelForeColor());
            return label;
        }
    }
}

