/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumgui;

import filedialog.FileChooser;
import help.HelpEvent;
import help.HelpListener;
import help.HelpPrefs;
import help.HelpWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import mlib.MAppMsg;
import oroma.albumgui.AlbumBar;
import oroma.albumgui.AlbumFiller;
import oroma.albumgui.AlbumSelectionBox;
import oroma.albumgui.PicDisplay;
import oroma.albumgui.PictureAdder;
import oroma.albumgui.PicturePanel;
import oroma.albumgui.Thumbnail;
import oroma.albumgui.ThumbnailPanel;
import oroma.albumgui.ThumbsPanel;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import oroma.gui.Main;
import oroma.gui.MainPanel;
import oroma.picinfogui.PicInfoPanel;
import popup.PopupObject;
import swing.ColorPanel;
import swing.NestedSplitPanel;
import swing.StatusBox;
import utilt.Utility;

public class AlbumPanel
extends ColorPanel {
    private LinkedList<Listener> iLis = new LinkedList();
    private NestedSplitPanel iNestedPanel = new NestedSplitPanel();
    private boolean iInfoDisplayed = true;
    private boolean iThumbDisplayed = true;
    private boolean iSelectionEnabled = true;
    private boolean iAddingPics = false;
    private static AlbumPanel Singleton = null;

    public static AlbumPanel singleton() {
        if (Singleton == null) {
            Singleton = new AlbumPanel();
        }
        return Singleton;
    }

    private AlbumPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)AlbumBar.singleton(), "North");
        this.add((Component)this.iNestedPanel, "Center");
        PicInfoPanel.singleton().setEnabled(false);
        AlbumBar.singleton().addListener(new ControlsHandler());
        this.iNestedPanel.setLeftComp(ThumbsPanel.singleton());
        this.iNestedPanel.setCenterComp(PicInfoPanel.singleton());
        this.iNestedPanel.setRightComp(PicturePanel.singleton());
        this.iNestedPanel.showComps(true, true);
        Singleton = this;
    }

    public synchronized void addListener(Listener lis) {
        boolean exists = lis == null;
        Iterator iter = this.iLis.iterator();
        while (!exists && iter.hasNext()) {
            boolean bl = exists = iter.next() == lis;
        }
        if (!exists) {
            this.iLis.add(lis);
        }
    }

    public boolean addAlbumSelection(String albumName) {
        return AlbumBar.singleton().addAlbumSelection(albumName);
    }

    public void reshowAlbumIfCurrent(Query album) {
        if (this.isCurAlbum(album.name())) {
            AlbumFiller.startNew(album);
        }
    }

    public boolean isCurAlbum(String name) {
        boolean isCur = false;
        Query curAlbum = AlbumSelectionBox.singleton().getCurAlbum();
        if (curAlbum != null) {
            isCur = curAlbum.name().equals(name);
        }
        return isCur;
    }

    public boolean isAddingPics() {
        return this.iAddingPics;
    }

    public boolean isSelectionEnabled() {
        return this.iSelectionEnabled;
    }

    public void setupSizes() {
        this.iNestedPanel.setupSizes();
    }

    public void clear() {
        this.clearPic();
        ThumbnailPanel.singleton().clear();
        ThumbsPanel.singleton().putIndicatorOn(false);
        ThumbsPanel.singleton().putPercentDone(0);
        AlbumBar.singleton().enableAddPics(false);
    }

    void showPicInfoPanel(boolean show) {
        this.iInfoDisplayed = show;
        this.iNestedPanel.showComps(this.iThumbDisplayed, this.iInfoDisplayed);
    }

    void clearPic() {
        PicturePanel.singleton().clear();
        this.enablePics(false);
        PicInfoPanel.singleton().setPicInfo(new PicInfo());
        PicInfoPanel.singleton().setEnabled(false);
        AlbumBar.singleton().enableTags(false);
    }

    boolean enableAlbumSelection(boolean enable) {
        boolean was = AlbumBar.singleton().enableAlbumSelection(enable);
        this.iSelectionEnabled = enable;
        return was;
    }

    void enableEdit(boolean enable) {
        PicInfoPanel.singleton().enableEdit(enable);
    }

    void enablePics(boolean enable) {
        AlbumBar.singleton().enableNextPrevPic(enable);
        AlbumBar.singleton().enableZoom(enable);
        AlbumBar.singleton().permitTags(enable);
        AlbumBar.singleton().enableTags(enable);
        AlbumBar.singleton().enableSlideshow(enable);
    }

    private void fireShowAlbums() {
        Event event = new Event(this);
        for (Listener lis : this.iLis) {
            lis.showAlbums(event);
        }
    }

    boolean isInfoDisplayed() {
        return this.iInfoDisplayed;
    }

    boolean isThumbDisplayed() {
        return this.iThumbDisplayed;
    }

    void removeListener(Listener lis) {
        this.iLis.remove(lis);
    }

    void putPic(PicDisplay disp) throws Exception {
        PicturePanel.singleton().clear();
        PicInfoPanel.singleton().setPicInfo(disp.info());
        PicturePanel.singleton().showPic(disp, 1.0);
    }

    void setAddingPics(boolean addingPics) {
        this.iAddingPics = addingPics;
    }

    private class ControlsHandler
    implements AlbumBar.Listener {
        private ControlsHandler() {
        }

        @Override
        public void showAlbums(AlbumBar.Event event) {
            AlbumPanel.this.fireShowAlbums();
        }

        @Override
        public void showTags(AlbumBar.Event event) {
            PicturePanel.singleton().enableTags(event.isUserEnabledTags());
        }

        @Override
        public void showPicInfo(AlbumBar.Event event) {
            boolean displayed = AlbumPanel.this.iInfoDisplayed;
            AlbumPanel.this.iInfoDisplayed = !displayed;
            AlbumPanel.this.iNestedPanel.showComps(AlbumPanel.this.iThumbDisplayed, AlbumPanel.this.iInfoDisplayed);
        }

        @Override
        public void showThumbnails(AlbumBar.Event event) {
            boolean displayed = AlbumPanel.this.iThumbDisplayed;
            AlbumPanel.this.iThumbDisplayed = !displayed;
            AlbumPanel.this.iNestedPanel.showComps(AlbumPanel.this.iThumbDisplayed, AlbumPanel.this.iInfoDisplayed);
        }

        @Override
        public void addPics(FileChooser.Event event) {
            Query curAlbum = AlbumSelectionBox.singleton().getCurAlbum();
            PictureAdder adder = new PictureAdder(curAlbum, event);
            AlbumBar.singleton().enableAddPics(false);
            adder.process();
        }

        @Override
        public void fillPics(AlbumBar.Event event) {
            AlbumBar.singleton().enableAddPics(false);
            AlbumFiller.startNew(event.getCurAlbum());
        }

        @Override
        public void showPrevPic(AlbumBar.Event event) {
            ThumbnailPanel.singleton().selectPrevItem(true);
            LinkedList<PopupObject> selections = ThumbnailPanel.singleton().selections();
            Thumbnail thumb = (Thumbnail)selections.getFirst();
            if (thumb != null) {
                thumb.handleOpen();
            }
        }

        @Override
        public void showNextPic(AlbumBar.Event event) {
            ThumbnailPanel.singleton().selectNextItem(true);
            LinkedList<PopupObject> selections = ThumbnailPanel.singleton().selections();
            Thumbnail thumb = (Thumbnail)selections.getFirst();
            if (thumb != null) {
                thumb.handleOpen();
            }
        }

        @Override
        public void zoomIn(AlbumBar.Event event) {
            PicturePanel.singleton().zoomIn(1.0);
        }

        @Override
        public void zoomOut(AlbumBar.Event event) {
            PicturePanel.singleton().zoomOut(1.0);
        }

        @Override
        public void resize(AlbumBar.Event event) {
            PicturePanel.singleton().resize();
        }

        @Override
        public void help(AlbumBar.Event event) {
            HelpPrefs prefs = ProgPreferences.singleton().helpPrefs();
            ImageIcon icon = Main.singleton().iconMgr().icon("bpm");
            HelpWindow dialog = HelpWindow.create(Main.TheHelpTree, icon, prefs);
            dialog.addHelpListener(new HelpHandler());
            MainPanel.enableHelp();
            dialog.setVisible(true);
        }
    }

    public static class Event
    extends EventObject {
        Event(Object source) {
            super(source);
        }
    }

    private class HelpHandler
    implements HelpListener {
        private HelpHandler() {
        }

        @Override
        public void ioError(HelpEvent event, Exception xcp) {
            MAppMsg msg = BpmMsgs.get("no_help");
            StatusBox.singleton().showMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
        }

        @Override
        public void selected(HelpEvent event) {
        }

        @Override
        public void windowClosing(HelpEvent event) {
            MainPanel.enableHelp();
        }
    }

    public static interface Listener
    extends EventListener {
        public void showAlbums(Event var1);
    }
}

