/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumgui;

import dialog.ConfirmDialog;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import misc.BackThreadGroup;
import mlib.MAppMsg;
import oroma.albumgui.AlbumBar;
import oroma.albumgui.AlbumPanel;
import oroma.albumgui.PicDisplay;
import oroma.albumgui.PicturePanel;
import oroma.albumgui.Thumbnail;
import oroma.albumgui.ThumbnailPanel;
import oroma.albumgui.ThumbsPanel;
import oroma.albumsgui.AlbumsPanel;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import oroma.gui.Main;
import oroma.picinfogui.InfoPanelTop;
import swing.StatusBox;
import utilt.Utility;

public class AlbumFiller
extends Thread {
    private Query iCurQuery = null;
    private boolean iHalt = false;
    private boolean iDone = false;
    private static AlbumFiller Singleton = null;

    public static synchronized boolean startNew(Query query) {
        boolean started = false;
        if (Singleton == null) {
            Singleton = new AlbumFiller(query);
            Singleton.start();
            started = true;
        } else {
            try {
                MAppMsg msg = BpmMsgs.get("synch");
                Main.singleton().logger().writeln(msg.format("startNew"));
                AlbumFiller.halt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return started;
    }

    public static synchronized void halt() {
        if (Singleton != null) {
            AlbumFiller.Singleton.iHalt = true;
            try {
                while (Singleton != null && !AlbumFiller.Singleton.iDone) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Singleton = null;
        }
    }

    private static boolean queryProceed(Collection<PicInfo> pics) throws Exception {
        ProgPreferences pref = ProgPreferences.singleton();
        ImageIcon icon = Main.singleton().iconMgr().icon("confirmation");
        MAppMsg msg = BpmMsgs.get("album_display");
        ConfirmDialog dialog = new ConfirmDialog((Frame)Main.singleton(), "Album Display Confirmation", msg.format(pics.size()), icon);
        dialog.setFont(pref.menuFont());
        dialog.center(0.5, 0.2);
        return dialog.display();
    }

    private static String albumSize(Collection<PicInfo> picInfos) {
        int sizeKB = 0;
        for (PicInfo info : picInfos) {
            sizeKB += info.getFileInfo().getSizeKB();
        }
        float sizeMB = (float)sizeKB * 0.001f;
        String size = (int)(0.5 + (double)sizeMB) + " MB";
        return size;
    }

    private AlbumFiller(Query query) {
        super((ThreadGroup)BackThreadGroup.group(), "AlbumFiller");
        this.iCurQuery = query;
        Singleton = this;
        this.iHalt = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Database database = Database.singleton();
        synchronized (database) {
            block17: {
                int errCount;
                int dispCount;
                boolean dispCanceled;
                block16: {
                    dispCanceled = false;
                    AlbumPanel aPanel = AlbumPanel.singleton();
                    aPanel.clear();
                    dispCount = 0;
                    errCount = 0;
                    try {
                        try {
                            aPanel.setCursor(Cursor.getPredefinedCursor(3));
                            Collection<PicInfo> pics = this.setup();
                            if (pics == null) break block16;
                            aPanel.setAddingPics(true);
                            MAppMsg msg = BpmMsgs.get("photos_found");
                            String size = String.valueOf(pics.size()) + " photos (" + AlbumFiller.albumSize(pics) + ")";
                            StatusBox.singleton().queueShowMsg(msg.format(size, this.iCurQuery.name()), msg.isError());
                            ThumbsPanel.singleton().putPercentDone(0);
                            ThumbsPanel.singleton().putIndicatorOn(true);
                            int numPics = pics.size();
                            int picNum = 0;
                            Iterator<PicInfo> iter = pics.iterator();
                            while (iter.hasNext() && !this.iHalt) {
                                int percent = (int)(100.0 * (double)(++picNum) / (double)numPics + 0.5);
                                PicInfo info = iter.next();
                                if (this.iHalt) continue;
                                try {
                                    info.setup();
                                    PicDisplay disp = new PicDisplay(info, ++dispCount);
                                    ThumbnailPanel.singleton().addPic(disp);
                                }
                                catch (Exception xcp) {
                                    ++errCount;
                                }
                                ThumbsPanel.singleton().putPercentDone(percent);
                            }
                        }
                        catch (Exception xcp) {
                            StatusBox.singleton().queueShowMsg(Utility.xcpMsg(xcp), true);
                            try {
                                this.cleanup(dispCount, errCount, dispCanceled);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.iDone = true;
                            Singleton = null;
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            this.cleanup(dispCount, errCount, dispCanceled);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.iDone = true;
                        Singleton = null;
                        throw throwable;
                    }
                }
                try {
                    this.cleanup(dispCount, errCount, dispCanceled);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.iDone = true;
                Singleton = null;
            }
        }
    }

    private Collection<PicInfo> setup() throws Exception {
        AlbumPanel aPanel = AlbumPanel.singleton();
        aPanel.enableEdit(false);
        AlbumBar.singleton().enableAddPics(false);
        AlbumBar.singleton().enableNextPrevPic(false);
        AlbumBar.singleton().enableZoom(false);
        AlbumBar.singleton().enableSlideshow(false);
        ThumbnailPanel thumbPanel = ThumbnailPanel.singleton();
        thumbPanel.clear();
        thumbPanel.enablePopupMenus(false);
        aPanel.setCursor(Cursor.getPredefinedCursor(3));
        MAppMsg msg = BpmMsgs.get("selecting_photos");
        StatusBox.singleton().queueShowMsg(msg.format(), msg.isError());
        TreeSet<PicInfo> pics = Database.singleton().selectPicInfos(this.iCurQuery);
        if (pics.size() == 0) {
            msg = BpmMsgs.get("album_empty");
            StatusBox.singleton().queueShowMsg(msg.format(this.iCurQuery.name()), msg.isError());
        } else {
            boolean proceed;
            ProgPreferences pref = ProgPreferences.singleton();
            boolean bl = proceed = pics.size() < pref.largeAlbumThreshold();
            if (!proceed) {
                proceed = AlbumFiller.queryProceed(pics);
            }
            if (proceed) {
                if (pref.resetFields().equals("Yes")) {
                    InfoPanelTop.singleton().updateComboBoxes(pics);
                }
                Iterator iter = pics.iterator();
                this.iCurQuery.setupThumb((PicInfo)iter.next());
            } else {
                pics = null;
            }
        }
        return pics;
    }

    private void cleanup(int dispCount, int errCount, boolean dispCanceled) throws Exception {
        AlbumPanel aPanel = AlbumPanel.singleton();
        ThumbsPanel.singleton().putIndicatorOn(false);
        if (!dispCanceled) {
            if (dispCount > 0) {
                ThumbnailPanel thumbPanel = ThumbnailPanel.singleton();
                thumbPanel.showThumbs(true);
                Thumbnail tnail = thumbPanel.firstThumb();
                PicDisplay picDisp = tnail.picDisp();
                if (picDisp.info().thumbnail() != Thumbnail.DefaultThumbnail) {
                    PicturePanel.singleton().showPic(picDisp, 1.0);
                }
            } else {
                this.iCurQuery.setupThumb(null);
            }
            if (errCount > 0) {
                MAppMsg msg = BpmMsgs.get("unable_display_photos");
                StatusBox.singleton().queueShowMsg(msg.format(Integer.toString(errCount)), msg.isError());
            }
        }
        AlbumsPanel.singleton().queueShowAlbums(false);
        AlbumBar.singleton().enableAddPics(true);
        aPanel.setAddingPics(false);
        aPanel.enableAlbumSelection(true);
        aPanel.setCursor(Cursor.getDefaultCursor());
        ThumbnailPanel.singleton().enablePopupMenus(true);
        ThumbsPanel.singleton().putPercentDone(0);
    }
}

