/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumgui;

import java.util.Iterator;
import java.util.TreeSet;
import mlib.MAppMsg;
import oroma.albumgui.AlbumBar;
import oroma.albumgui.AlbumPanel;
import oroma.albumgui.PicturePanel;
import oroma.albumgui.Thumbnail;
import oroma.albumgui.ThumbnailPanel;
import oroma.albumgui.ThumbsPanel;
import oroma.albumsgui.AlbumsPanel;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import oroma.picinfogui.PicInfoPanel;
import swing.StatusBox;
import utilt.Utility;

public class AlbumDisplayer
extends Thread {
    private Query iQuery = null;

    public AlbumDisplayer(Query query) {
        this.iQuery = query;
    }

    @Override
    public void run() {
        try {
            ThumbsPanel.singleton().putIndicatorOn(false);
            ThumbnailPanel.singleton().enablePopupMenus(true);
            AlbumPanel.singleton().enableAlbumSelection(true);
            AlbumBar.singleton().enableAddPics(true);
            AlbumPanel.singleton().setAddingPics(false);
            Thumbnail tnail = ThumbnailPanel.singleton().firstThumb();
            if (tnail != null) {
                PicturePanel.singleton().showPic(tnail.picDisp(), 1.0);
                ThumbnailPanel.singleton().selectFirstItem();
                if (PicturePanel.singleton().picDisplay() != null) {
                    PicInfoPanel.singleton().setEnabled(true);
                }
                TreeSet<PicInfo> pics = Database.singleton().selectPicInfos(this.iQuery);
                Iterator iter = pics.iterator();
                this.iQuery.setupThumb((PicInfo)iter.next());
            }
            AlbumsPanel.singleton().showAlbums(false);
        }
        catch (Exception xcp) {
            MAppMsg msg = BpmMsgs.get("unable_update_album");
            StatusBox.singleton().queueShowMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
        }
    }
}

