/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumgui;

import filedialog.FileChooser;
import filedialog.FilePopupObject;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import oroma.albumgui.AlbumPanel;
import oroma.albumgui.AlbumSelectionBox;
import oroma.albumgui.ImageChooserFilter;
import oroma.albumgui.PicturePanel;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.gui.Main;
import oroma.slideshow.SlideshowDialog;
import swing.ColorPanel;
import swing.ControlButton;
import swing.StatusBox;
import utilt.ImageIOUtil;

public class AlbumBar
extends ColorPanel {
    private JButton jShowThumbnailsButton = null;
    private JButton jAddPicButton = null;
    private JButton jNextPicButton = null;
    private JButton jPrevPicButton = null;
    private JButton jShowPicInfoButton = null;
    private JButton jShowAlbumsButton = null;
    private JButton jHelpButton = null;
    private JButton jZoomInButton = null;
    private JButton jZoomOutButton = null;
    private JButton jSlideshowButton = null;
    private LinkedList<Listener> iLis = new LinkedList();
    private FileChooser iChooser = null;
    private boolean iUserEnabledTags = false;
    private JButton jResizeButton = null;
    private JButton jShowTagsButton = null;
    private ColorPanel iLeftPanel = null;
    private static AlbumBar Singleton = null;

    public static AlbumBar singleton() {
        if (Singleton == null) {
            Singleton = new AlbumBar();
        }
        return Singleton;
    }

    private AlbumBar() {
        ProgPreferences pref = ProgPreferences.singleton();
        if (pref.albumBarLayout().equals("Grid")) {
            this.setLayout(new GridLayout(0, 3));
        } else {
            this.setLayout(new BoxLayout(this, 0));
        }
        this.setBackground(pref.headerBackColor());
        this.setForeground(SystemColor.controlText);
        AlbumSelectionBox.singleton().setFont(pref.menuFont());
        this.fill(false);
    }

    private void fill(boolean showStatus) {
        this.removeAll();
        this.iLeftPanel = new ColorPanel();
        this.iLeftPanel.setLayout(new BoxLayout(this.iLeftPanel, 0));
        this.iLeftPanel.add(this.getShowAlbumsButton());
        this.iLeftPanel.add(this.getShowThumbnailsButton());
        this.iLeftPanel.add(this.getShowPicInfoButton());
        this.iLeftPanel.add(this.getAddPicButton());
        this.iLeftPanel.add(this.getPrevPicButton());
        this.iLeftPanel.add(this.getNextPicButton());
        this.iLeftPanel.add(this.getZoomOutButton());
        this.iLeftPanel.add(this.getZoomInButton());
        this.iLeftPanel.add(this.getResizeButton());
        this.iLeftPanel.add(this.getShowTagsButton());
        this.iLeftPanel.add(this.getSlideshowButton());
        this.iLeftPanel.add(Box.createHorizontalStrut(5));
        this.add(this.iLeftPanel);
        this.add(AlbumSelectionBox.singleton());
        if (showStatus) {
            this.add(StatusBox.singleton());
        }
    }

    public synchronized void addListener(Listener lis) {
        boolean exists = lis == null;
        Iterator iter = this.iLis.iterator();
        while (!exists && iter.hasNext()) {
            boolean bl = exists = iter.next() == lis;
        }
        if (!exists) {
            this.iLis.add(lis);
        }
    }

    public boolean addAlbumSelection(String albumName) {
        return AlbumSelectionBox.singleton().addAlbum(albumName);
    }

    public boolean enableAddPics(boolean enable) {
        boolean was = this.getAddPicButton().isEnabled();
        this.getAddPicButton().setEnabled(enable);
        return was;
    }

    public boolean enableAlbumSelection(boolean enable) {
        boolean was = AlbumSelectionBox.singleton().isEnabled();
        AlbumSelectionBox.singleton().setEnabled(enable);
        return was;
    }

    public boolean enableHelp(boolean enable) {
        boolean was = this.getHelpButton().isEnabled();
        this.getHelpButton().setEnabled(enable);
        if (enable) {
            this.iLeftPanel.add((Component)this.getHelpButton(), 11);
            this.getShowAlbumsButton().setIcon(Main.singleton().iconMgr().icon("down"));
        } else {
            this.iLeftPanel.remove(this.getHelpButton());
            this.getShowAlbumsButton().setIcon(Main.singleton().iconMgr().icon("up"));
        }
        this.validate();
        return was;
    }

    public boolean enableNextPrevPic(boolean enable) {
        boolean was = this.getNextPicButton().isEnabled();
        this.getNextPicButton().setEnabled(enable);
        this.getPrevPicButton().setEnabled(enable);
        return was;
    }

    public boolean enableTags(boolean enable) {
        boolean was = this.getShowTagsButton().isEnabled();
        this.getShowTagsButton().setEnabled(enable);
        return was;
    }

    public boolean enableZoom(boolean enable) {
        boolean was = this.getZoomInButton().isEnabled();
        this.getZoomInButton().setEnabled(enable);
        this.getZoomOutButton().setEnabled(enable);
        this.getResizeButton().setEnabled(enable);
        return was;
    }

    public boolean enableZoomIn(boolean enable) {
        boolean was = this.getZoomInButton().isEnabled();
        this.getZoomInButton().setEnabled(enable);
        return was;
    }

    public boolean enableZoomOut(boolean enable) {
        boolean was = this.getZoomOutButton().isEnabled();
        this.getZoomOutButton().setEnabled(enable);
        return was;
    }

    public boolean enableSlideshow(boolean enable) {
        boolean was = this.getSlideshowButton().isEnabled();
        if (this.getNextPicButton().isEnabled()) {
            this.getSlideshowButton().setEnabled(enable);
        }
        return was;
    }

    public void fireFillPics() {
        Event event = new Event(this);
        event.setCurAlbum(AlbumSelectionBox.singleton().getCurAlbum());
        for (Listener lis : this.iLis) {
            lis.fillPics(event);
        }
    }

    public void permitTags(boolean permit) {
        this.getShowTagsButton().setEnabled(permit);
        if (this.iUserEnabledTags) {
            this.getShowTagsButton().setIcon(Main.singleton().iconMgr().icon("tagon"));
        } else {
            this.getShowTagsButton().setIcon(Main.singleton().iconMgr().icon("tagoff"));
        }
    }

    public synchronized void removeAlbumPanelControlsListener(Listener lis) {
        this.iLis.remove(lis);
    }

    private JButton getAddPicButton() {
        if (this.jAddPicButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("plus");
            this.jAddPicButton = new ControlButton("Add photos", icon, 'c');
            this.jAddPicButton.setEnabled(false);
            this.jAddPicButton.addActionListener(new AddPicHandler());
            ProgPreferences pref = ProgPreferences.singleton();
            this.jAddPicButton.setBackground(pref.headerBackColor());
        }
        return this.jAddPicButton;
    }

    private JButton getHelpButton() {
        if (this.jHelpButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("help");
            this.jHelpButton = new ControlButton("Help", icon, 'h');
            this.jHelpButton.setEnabled(false);
            this.jHelpButton.addActionListener(new HelpHandler());
            ProgPreferences pref = ProgPreferences.singleton();
            this.jHelpButton.setBackground(pref.headerBackColor());
        }
        return this.jHelpButton;
    }

    private JButton getNextPicButton() {
        if (this.jNextPicButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("next");
            this.jNextPicButton = new ControlButton("Next photo", icon, 'n');
            this.jNextPicButton.setEnabled(false);
            this.jNextPicButton.addActionListener(new NextPicHandler());
            ProgPreferences pref = ProgPreferences.singleton();
            this.jNextPicButton.setBackground(pref.headerBackColor());
        }
        return this.jNextPicButton;
    }

    private JButton getPrevPicButton() {
        if (this.jPrevPicButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("prev");
            this.jPrevPicButton = new ControlButton("Previous photo", icon, 'p');
            this.jPrevPicButton.setEnabled(false);
            this.jPrevPicButton.addActionListener(new PrevPicHandler());
            ProgPreferences pref = ProgPreferences.singleton();
            this.jPrevPicButton.setBackground(pref.headerBackColor());
        }
        return this.jPrevPicButton;
    }

    private JButton getResizeButton() {
        if (this.jResizeButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("resize");
            this.jResizeButton = new ControlButton("Resize image", icon, 'r');
            this.jResizeButton.setEnabled(false);
            this.jResizeButton.addActionListener(new ResizeHandler());
            ProgPreferences pref = ProgPreferences.singleton();
            this.jResizeButton.setBackground(pref.headerBackColor());
        }
        return this.jResizeButton;
    }

    private JButton getShowAlbumsButton() {
        if (this.jShowAlbumsButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("up");
            this.jShowAlbumsButton = new ControlButton("Display albums panel", icon, 'u');
            this.jShowAlbumsButton.addActionListener(new ShowAlbumsHandler());
            ProgPreferences pref = ProgPreferences.singleton();
            this.jShowAlbumsButton.setBackground(pref.headerBackColor());
        }
        return this.jShowAlbumsButton;
    }

    private JButton getShowPicInfoButton() {
        if (this.jShowPicInfoButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("infoon");
            this.jShowPicInfoButton = new ControlButton("Display photo information panel", icon, 'i');
            this.jShowPicInfoButton.addActionListener(new ShowInfoHandler());
            ProgPreferences pref = ProgPreferences.singleton();
            this.jShowPicInfoButton.setBackground(pref.headerBackColor());
        }
        return this.jShowPicInfoButton;
    }

    private JButton getShowTagsButton() {
        if (this.jShowTagsButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("tagoff");
            this.jShowTagsButton = new ControlButton("Display photo tags", icon, 'g');
            this.jShowTagsButton.setEnabled(false);
            this.jShowTagsButton.addActionListener(new ShowTagsHandler());
            ProgPreferences pref = ProgPreferences.singleton();
            this.jShowTagsButton.setBackground(pref.headerBackColor());
        }
        return this.jShowTagsButton;
    }

    private JButton getShowThumbnailsButton() {
        if (this.jShowThumbnailsButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("thumbson");
            this.jShowThumbnailsButton = new ControlButton("Display thumbnails panel", icon, 't');
            this.jShowThumbnailsButton.addActionListener(new ShowThumbnailsHandler());
            ProgPreferences pref = ProgPreferences.singleton();
            this.jShowThumbnailsButton.setBackground(pref.headerBackColor());
        }
        return this.jShowThumbnailsButton;
    }

    private JButton getZoomInButton() {
        if (this.jZoomInButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("zoomin");
            this.jZoomInButton = new ControlButton("Zoom image in", icon, 'z');
            this.jZoomInButton.setEnabled(false);
            this.jZoomInButton.addActionListener(new ZoomInHandler());
            ProgPreferences pref = ProgPreferences.singleton();
            this.jZoomInButton.setBackground(pref.headerBackColor());
        }
        return this.jZoomInButton;
    }

    private JButton getZoomOutButton() {
        if (this.jZoomOutButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("zoomout");
            this.jZoomOutButton = new ControlButton("Zoom image out", icon, 'o');
            this.jZoomOutButton.setEnabled(false);
            this.jZoomOutButton.addActionListener(new ZoomOutHandler());
            ProgPreferences pref = ProgPreferences.singleton();
            this.jZoomOutButton.setBackground(pref.headerBackColor());
        }
        return this.jZoomOutButton;
    }

    private JButton getSlideshowButton() {
        if (this.jSlideshowButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("slideshow");
            this.jSlideshowButton = new ControlButton("Slideshow", icon, 's');
            this.jSlideshowButton.setEnabled(false);
            this.jSlideshowButton.addActionListener(new SlideshowHandler());
            ProgPreferences pref = ProgPreferences.singleton();
            this.jSlideshowButton.setBackground(pref.headerBackColor());
        }
        return this.jSlideshowButton;
    }

    private class AddPicHandler
    implements ActionListener {
        private AddPicHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            ProgPreferences pref = ProgPreferences.singleton();
            AlbumBar.this.enableAddPics(false);
            String[] picExts = ImageIOUtil.IMAGEEXTS;
            if (!pref.addPicExt().equals("All")) {
                picExts = new String[]{"." + pref.addPicExt()};
            }
            Query query = AlbumSelectionBox.singleton().getCurAlbum();
            TreeSet<PicInfo> pics = Database.singleton().selectPicInfos(query);
            ImageChooserFilter filter = new ImageChooserFilter(picExts, false, true, "new image files");
            AlbumBar.this.iChooser = new FileChooser(ProgPreferences.singleton(), filter, true, false, true, Main.singleton(), true);
            PicInfo selected = null;
            Iterator iter = pics.iterator();
            if (pics.size() == 1) {
                selected = (PicInfo)iter.next();
            } else if (pics.size() > 1) {
                boolean found = false;
                PicInfo info1 = (PicInfo)iter.next();
                while (!found) {
                    PicInfo info2 = (PicInfo)iter.next();
                    File file1 = new File(info1.picPathname());
                    File file2 = new File(info2.picPathname());
                    found = file1.getParent().equals(file2.getParent());
                    if (found) continue;
                    info1 = info2;
                }
                if (found) {
                    selected = info1;
                } else {
                    iter = pics.iterator();
                    selected = (PicInfo)iter.next();
                }
                String dirPath = selected.picPathname();
                int index = dirPath.lastIndexOf(47);
                dirPath = dirPath.substring(0, index);
                dirPath = dirPath.replace('/', File.separatorChar);
                AlbumBar.this.iChooser.setCurDir(dirPath);
            }
            AlbumBar.this.iChooser.center(0.7, 0.7);
            AlbumBar.this.iChooser.setFont(pref.menuFont());
            AlbumBar.this.iChooser.addListener(new ChooserHandler());
            AlbumBar.this.iChooser.setTitle("Add Photos");
            AlbumBar.this.iChooser.setThumbSize(ProgPreferences.singleton().thumbnailSize());
            AlbumBar.this.iChooser.setVisible(true);
            PicturePanel.singleton().requestFocus();
        }
    }

    private class ChooserHandler
    implements FileChooser.Listener {
        private ChooserHandler() {
        }

        @Override
        public void selected(FileChooser.Event event) {
            LinkedList<FilePopupObject> selections = event.selections();
            if (selections.size() > 0) {
                for (Listener lis : AlbumBar.this.iLis) {
                    lis.addPics(event);
                }
            }
            AlbumBar.this.enableAddPics(true);
        }

        @Override
        public void message(FileChooser.Event event) {
            StatusBox.singleton().showMsg(event.msg(), false);
        }
    }

    public static class Event
    extends EventObject {
        private String iSelection = null;
        private Query iCurAlbum = null;
        private boolean iUserEnabledTags = false;

        public Event(Object source) {
            super(source);
        }

        public Query getCurAlbum() {
            return this.iCurAlbum;
        }

        public String getSelection() {
            return this.iSelection;
        }

        public boolean isUserEnabledTags() {
            return this.iUserEnabledTags;
        }

        public void setCurAlbum(Query query) {
            this.iCurAlbum = query;
        }

        public void setSelection(String newSelection) {
            this.iSelection = newSelection;
        }

        public void setUserEnabledTags(boolean enabled) {
            this.iUserEnabledTags = enabled;
        }
    }

    private class HelpHandler
    implements ActionListener {
        private HelpHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            Event event = new Event(AlbumBar.this);
            event.setCurAlbum(AlbumSelectionBox.singleton().getCurAlbum());
            for (Listener lis : AlbumBar.this.iLis) {
                lis.help(event);
            }
            PicturePanel.singleton().requestFocus();
        }
    }

    public static interface Listener
    extends EventListener {
        public void addPics(FileChooser.Event var1);

        public void fillPics(Event var1);

        public void help(Event var1);

        public void resize(Event var1);

        public void showAlbums(Event var1);

        public void showNextPic(Event var1);

        public void showPicInfo(Event var1);

        public void showPrevPic(Event var1);

        public void showTags(Event var1);

        public void showThumbnails(Event var1);

        public void zoomIn(Event var1);

        public void zoomOut(Event var1);
    }

    private class NextPicHandler
    implements ActionListener {
        private NextPicHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            Event event = new Event(AlbumBar.this);
            event.setCurAlbum(AlbumSelectionBox.singleton().getCurAlbum());
            for (Listener lis : AlbumBar.this.iLis) {
                lis.showNextPic(event);
            }
            PicturePanel.singleton().requestFocus();
        }
    }

    private class PrevPicHandler
    implements ActionListener {
        private PrevPicHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            Event event = new Event(AlbumBar.this);
            event.setCurAlbum(AlbumSelectionBox.singleton().getCurAlbum());
            for (Listener lis : AlbumBar.this.iLis) {
                lis.showPrevPic(event);
            }
            PicturePanel.singleton().requestFocus();
        }
    }

    private class ResizeHandler
    implements ActionListener {
        private ResizeHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            Event event = new Event(AlbumBar.this);
            event.setCurAlbum(AlbumSelectionBox.singleton().getCurAlbum());
            for (Listener lis : AlbumBar.this.iLis) {
                lis.resize(event);
            }
            AlbumBar.this.enableTags(true);
            PicturePanel.singleton().requestFocus();
        }
    }

    private class ShowAlbumsHandler
    implements ActionListener {
        private ShowAlbumsHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            Event event = new Event(AlbumBar.this);
            event.setCurAlbum(AlbumSelectionBox.singleton().getCurAlbum());
            for (Listener lis : AlbumBar.this.iLis) {
                lis.showAlbums(event);
            }
            PicturePanel.singleton().requestFocus();
        }
    }

    private class ShowInfoHandler
    implements ActionListener {
        private ShowInfoHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            Event event = new Event(AlbumBar.this);
            event.setCurAlbum(AlbumSelectionBox.singleton().getCurAlbum());
            for (Listener lis : AlbumBar.this.iLis) {
                lis.showPicInfo(event);
            }
            if (AlbumPanel.singleton().isInfoDisplayed()) {
                AlbumBar.this.getShowPicInfoButton().setIcon(Main.singleton().iconMgr().icon("infoon"));
            } else {
                AlbumBar.this.getShowPicInfoButton().setIcon(Main.singleton().iconMgr().icon("infooff"));
            }
            PicturePanel.singleton().requestFocus();
        }
    }

    private class ShowTagsHandler
    implements ActionListener {
        private ShowTagsHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            AlbumBar.this.iUserEnabledTags = !AlbumBar.this.iUserEnabledTags;
            Event event = new Event(AlbumBar.this);
            event.setCurAlbum(AlbumSelectionBox.singleton().getCurAlbum());
            event.setUserEnabledTags(AlbumBar.this.iUserEnabledTags);
            for (Listener lis : AlbumBar.this.iLis) {
                lis.showTags(event);
            }
            AlbumBar.this.permitTags(true);
            PicturePanel.singleton().requestFocus();
        }
    }

    private class ShowThumbnailsHandler
    implements ActionListener {
        private ShowThumbnailsHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            Event event = new Event(AlbumBar.this);
            event.setCurAlbum(AlbumSelectionBox.singleton().getCurAlbum());
            for (Listener lis : AlbumBar.this.iLis) {
                lis.showThumbnails(event);
            }
            if (AlbumPanel.singleton().isThumbDisplayed()) {
                AlbumBar.this.getShowThumbnailsButton().setIcon(Main.singleton().iconMgr().icon("thumbson"));
            } else {
                AlbumBar.this.getShowThumbnailsButton().setIcon(Main.singleton().iconMgr().icon("thumbsoff"));
            }
            PicturePanel.singleton().requestFocus();
        }
    }

    private class SlideshowHandler
    implements ActionListener {
        private SlideshowHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            PicturePanel.singleton().requestFocus();
            Query query = AlbumSelectionBox.singleton().getCurAlbum();
            AlbumBar.this.enableSlideshow(false);
            SlideshowDialog dialog = new SlideshowDialog(query);
        }
    }

    private class ZoomInHandler
    implements ActionListener {
        private ZoomInHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            Event event = new Event(AlbumBar.this);
            event.setCurAlbum(AlbumSelectionBox.singleton().getCurAlbum());
            for (Listener lis : AlbumBar.this.iLis) {
                lis.zoomIn(event);
            }
            PicturePanel.singleton().requestFocus();
        }
    }

    private class ZoomOutHandler
    implements ActionListener {
        private ZoomOutHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            Event event = new Event(AlbumBar.this);
            event.setCurAlbum(AlbumSelectionBox.singleton().getCurAlbum());
            for (Listener lis : AlbumBar.this.iLis) {
                lis.zoomOut(event);
            }
            PicturePanel.singleton().requestFocus();
        }
    }
}

