/*
 * Decompiled with CFR 0.152.
 */
package mswing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import utilt.ImageIOUtil;

public class ThumbnailImage
implements Icon,
Serializable {
    private String iPath = null;
    private String iImagePath = null;
    private transient ImageIcon iIcon = null;
    private transient BufferedImage iImage = null;
    private static final int IMGQUAL = 50;
    static final long serialVersionUID = -2161651290945962225L;

    public ThumbnailImage() {
    }

    public ThumbnailImage(ImageIcon icon) {
        this.iIcon = icon;
    }

    public String getPath() {
        return this.iPath;
    }

    public void setPath(String path) {
        this.iPath = path;
    }

    public String getImagePath() {
        return this.iImagePath;
    }

    public void setImagePath(String path) {
        this.iImagePath = path;
    }

    public ImageIcon getIcon() {
        return this.iIcon;
    }

    @Override
    public int getIconHeight() {
        int height = 0;
        if (this.iIcon != null) {
            height = this.iIcon.getIconHeight();
        }
        return height;
    }

    @Override
    public int getIconWidth() {
        int width = 0;
        if (this.iIcon != null) {
            width = this.iIcon.getIconWidth();
        }
        return width;
    }

    public int iconSize() {
        int size = this.getIconHeight();
        if (this.getIconWidth() > size) {
            size = this.getIconWidth();
        }
        return size;
    }

    @Override
    public void paintIcon(Component comp, Graphics g, int x, int y) {
        if (this.iIcon != null) {
            g.drawImage(this.iIcon.getImage(), x, y, this.iIcon.getIconWidth(), this.iIcon.getIconHeight(), null);
        }
    }

    public boolean read(String path) throws Exception {
        this.iPath = path;
        this.iPath = this.iPath.replace('\\', '/');
        File file = new File(this.iPath);
        boolean result = file.exists();
        if (result) {
            this.iImage = ImageIOUtil.load(this.iPath);
            this.iIcon = null;
            this.iIcon = new ImageIcon(this.iImage);
            result = this.iIcon != null;
        }
        return result;
    }

    public void setup(BufferedImage image, int maxDimen) throws Exception {
        this.iImage = ImageIOUtil.resize(image, maxDimen);
        this.iIcon = new ImageIcon(this.iImage);
    }

    public void write(String path) throws Exception {
        ImageIOUtil.writeJpeg(this.iImage, path, 50);
    }
}

