/*
 * Decompiled with CFR 0.152.
 */
package mswing;

import help.HelpPrefs;
import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import mswing.StdColor;
import utilt.Utility;

public class Preferences
implements Serializable,
Cloneable {
    private String iFontName = "SansSerif";
    private Font iMenuFont = null;
    private Font iMonoFont = null;
    private Color iEntryBackColor = StdColor.PALEYELLOW.color();
    private Color iEntryForeColor = new Color(0, 0, 255);
    private Color iEntryHilightColor = SystemColor.control;
    private Color iSelectionColor = Color.magenta;
    private Color iPanelBackColor = SystemColor.control;
    private Color iPanelForeColor = Color.black;
    private Color iHeaderBackColor = SystemColor.control;
    private Color iDialogColor = Color.white;
    private Color iErrorMsgColor = Color.red;
    private String iLookAndFeel = "Metal";
    private boolean iUseBoldFonts = false;
    private double iWindowHeight = 1.0;
    private double iWindowWidth = 1.0;
    private transient Font iBoldMenuFont = null;
    private transient Font iBoldMonoFont = null;
    public static final String DEFFONTNAME = "SansSerif";
    public static final String PREFFILENAME = "pref";
    public static final String LARGESIZE = "Large";
    public static final String MEDIUMSIZE = "Medium";
    public static final String SMALLSIZE = "Small";
    public static final String YES = "Yes";
    public static final String NO = "No";
    static final long serialVersionUID = 7276221380565834950L;

    public static void main(String[] args) {
        try {
            Preferences pref = new Preferences();
            String pathName = String.valueOf(System.getProperty("user.dir")) + File.separator + "pref.dat";
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(pathName));
            out.writeObject(pref);
            out.close();
            System.out.println("Wrote " + pathName);
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public Preferences() {
        int fontSize = Utility.stdFontSize();
        this.iMenuFont = new Font(this.iFontName, 0, fontSize);
        this.iMonoFont = new Font("Monospaced", 0, fontSize);
    }

    public Object clone() {
        Preferences copy = null;
        try {
            copy = (Preferences)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }

    public void assign(Preferences pref) {
        this.iMenuFont = pref.iMenuFont;
        this.iMonoFont = pref.iMonoFont;
        this.iEntryBackColor = pref.iEntryBackColor;
        this.iEntryForeColor = pref.iEntryForeColor;
        this.iEntryHilightColor = pref.iEntryHilightColor;
        this.iErrorMsgColor = pref.iErrorMsgColor;
        this.iSelectionColor = pref.iSelectionColor;
        this.iPanelBackColor = pref.iPanelBackColor;
        this.iPanelForeColor = pref.iPanelForeColor;
        this.iHeaderBackColor = pref.iHeaderBackColor;
        this.iDialogColor = pref.iDialogColor;
        this.iLookAndFeel = pref.iLookAndFeel;
        this.iUseBoldFonts = pref.iUseBoldFonts;
        this.iWindowHeight = pref.iWindowHeight;
        this.iWindowWidth = pref.iWindowWidth;
        this.iFontName = pref.iFontName;
        this.iBoldMenuFont = pref.iBoldMenuFont;
        this.iBoldMonoFont = pref.iBoldMonoFont;
    }

    public Color entryBackColor() {
        return this.iEntryBackColor;
    }

    public Color entryForeColor() {
        return this.iEntryForeColor;
    }

    public Color entryHilightColor() {
        return this.iEntryHilightColor;
    }

    public Color selectionColor() {
        return this.iSelectionColor;
    }

    public boolean useBoldFonts() {
        return this.iUseBoldFonts;
    }

    public String fontName() {
        return this.iFontName;
    }

    public Color panelBackColor() {
        return this.iPanelBackColor;
    }

    public Color panelForeColor() {
        return this.iPanelForeColor;
    }

    public Color headerBackColor() {
        return this.iHeaderBackColor;
    }

    public Color dialogColor() {
        return this.iDialogColor;
    }

    public Color errorMsgColor() {
        return this.iErrorMsgColor;
    }

    public Font menuFont() {
        Font font = this.iMenuFont;
        if (this.iUseBoldFonts) {
            font = this.iBoldMenuFont = this.iMenuFont.deriveFont(1);
        }
        return font;
    }

    public Font monoFont() {
        Font font = this.iMonoFont;
        if (this.iUseBoldFonts) {
            font = this.iBoldMonoFont = this.iMonoFont.deriveFont(1);
        }
        return font;
    }

    public double windowHeight() {
        return this.iWindowHeight;
    }

    public String lookAndFeel() {
        return this.iLookAndFeel;
    }

    public void setEntryBackColor(Color color) {
        this.iEntryBackColor = color;
    }

    public void setEntryForeColor(Color color) {
        this.iEntryForeColor = color;
    }

    public void setSelectionColor(Color color) {
        this.iSelectionColor = color;
    }

    public void setUseBoldFonts(boolean newUseBoldFonts) {
        this.iUseBoldFonts = newUseBoldFonts;
    }

    public void setPanelBackColor(Color color) {
        this.iPanelBackColor = color;
    }

    public void setPanelForeColor(Color color) {
        this.iPanelForeColor = color;
    }

    public void setHeaderBackColor(Color color) {
        this.iHeaderBackColor = color;
    }

    public void setDialogColor(Color color) {
        this.iDialogColor = color;
    }

    public void setErrorMsgColor(Color color) {
        this.iErrorMsgColor = color;
    }

    public void setEntryHilightColor(Color color) {
        this.iEntryHilightColor = color;
    }

    public void setMenuFont(Font font) {
        this.iMenuFont = font;
    }

    public void setMonoFont(Font monoFont) {
        this.iMonoFont = monoFont;
    }

    public void setFontName(String fontName) {
        this.iFontName = fontName;
    }

    public void setFontSize(int size) {
        this.iMenuFont = new Font(this.iFontName, 0, size);
    }

    public void setWindowHeight(double height) {
        this.iWindowHeight = height;
    }

    public double windowWidth() {
        return this.iWindowWidth;
    }

    public void setWindowWidth(double windowWidth) {
        this.iWindowWidth = windowWidth;
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.iLookAndFeel = lookAndFeel;
    }

    public HelpPrefs helpPrefs() {
        HelpPrefs prefs = new HelpPrefs();
        prefs.setSelectionColor(this.iSelectionColor);
        if (this.useBoldFonts()) {
            this.iMenuFont = this.iMenuFont.deriveFont(1);
        }
        prefs.setTextFont(this.iMenuFont);
        Font font = this.iMenuFont.deriveFont(3, this.iMenuFont.getSize());
        prefs.setHeaderFont(font);
        font = this.iMenuFont.deriveFont(3, this.iMenuFont.getSize() + 10);
        prefs.setTitleFont(font);
        prefs.setFoundColor(this.iSelectionColor);
        return prefs;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.iErrorMsgColor == null) {
            this.iErrorMsgColor = Color.red;
        }
    }
}

